/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.DefaultJob;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.PlanCreationException;
import com.atlassian.bamboo.build.creation.JobCreationConstants;
import com.atlassian.bamboo.build.creation.JobCreationService;
import com.atlassian.bamboo.build.creation.JobParamMapHelper;
import com.atlassian.bamboo.build.creation.PlanConfigHelper;
import com.atlassian.bamboo.build.creation.PlanCreationBean;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.build.creation.PlanCreationTemplate;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.build.docker.DockerPipelineValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.chains.ChainStage;
import com.atlassian.bamboo.chains.ChainStageImpl;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.event.BuildConfigurationUpdatedEvent;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.fieldvalue.TaskConfigurationUtils;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.persister.AuditLogEntityType;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionImpl;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.branch.ChainPropagatingFacade;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.TaskDefinitionImpl;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.BambooPredicates;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.agent.capability.Requirement;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementImpl;
import com.atlassian.bamboo.v2.build.agent.capability.RequirementSet;
import com.atlassian.bamboo.v2.events.BuildCreatedEvent;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.FixedDirectoryWorkingCopyManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.ValidationAware;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.acegisecurity.acls.MutableAcl;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class JobCreationServiceImpl
extends PlanCreationTemplate
implements JobCreationService {
    private static final Logger log = Logger.getLogger(JobCreationServiceImpl.class);
    private final ChainBranchManager chainBranchManager;
    private final VcsRepositoryManager vcsRepositoryManager;
    private final DockerPipelineValidationService dockerPipelineValidationService;
    private final TaskManager taskManager;

    public JobCreationServiceImpl(PlanManager planManager, ProjectManager projectManager, BambooAclUpdateHelper aclUpdateHelper, BambooAuthenticationContext authenticationContext, BambooLicenseManager bambooLicenseManager, HibernateMutableAclService aclService, PlanScheduler planScheduler, EventPublisher eventPublisher, PlanValidationService planValidationService, AuditLogService auditLogService, BuildDefinitionConverter buildDefinitionConverter, ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionManager artifactSubscriptionManager, VariableDefinitionManager variableDefinitionManager, RepositoryDefinitionManager repositoryDefinitionManager, TaskConfigurationService taskConfigurationService, NotificationManager notificationManager, BranchCommitInformationManager branchCommitInformationManager, VcsBranchManager vcsBranchManager, TriggerConfigurationService triggerConfigurationService, ChainBranchManager chainBranchManager, BuildNumberGeneratorService buildNumberGeneratorService, VcsRepositoryManager vcsRepositoryManager, DockerPipelineValidationService dockerPipelineValidationService, TaskManager taskManager) {
        super(planManager, projectManager, aclUpdateHelper, authenticationContext, bambooLicenseManager, aclService, planScheduler, eventPublisher, planValidationService, auditLogService, buildDefinitionConverter, artifactDefinitionManager, artifactSubscriptionManager, variableDefinitionManager, repositoryDefinitionManager, taskConfigurationService, notificationManager, branchCommitInformationManager, vcsBranchManager, triggerConfigurationService, buildNumberGeneratorService);
        this.chainBranchManager = chainBranchManager;
        this.vcsRepositoryManager = vcsRepositoryManager;
        this.dockerPipelineValidationService = dockerPipelineValidationService;
        this.taskManager = taskManager;
    }

    public void validatePlan(ValidationAware validationAware, BuildConfiguration buildConfiguration, ActionParametersMap params) {
        block8: {
            block6: {
                Plan buildToClone;
                block7: {
                    String buildKey = JobParamMapHelper.getSubBuildKey(params);
                    String buildName = JobParamMapHelper.getBuildName(params);
                    String buildDescription = JobParamMapHelper.getBuildDescription(params);
                    String stageName = JobParamMapHelper.getStageName(params);
                    String existingStage = JobParamMapHelper.getExistingStage(params);
                    String stageDescription = JobParamMapHelper.getStageDescription(params);
                    boolean cloneJob = JobParamMapHelper.isCloneJob(params);
                    String jobKeyToClone = JobParamMapHelper.getJobKeyToClone(params);
                    Chain chain = this.getChain(params);
                    if (JobCreationServiceImpl.isNewStage(existingStage)) {
                        this.planValidationService.validateName(validationAware, JobCreationConstants.STAGE_NAME, "stage", stageName);
                        this.planValidationService.validateDescription(validationAware, JobCreationConstants.STAGE_DESCRIPTION, stageDescription);
                        this.planValidationService.validateNewStageForChain(validationAware, chain, stageName);
                    } else {
                        this.planValidationService.validateStageExistsForChain(validationAware, chain, existingStage);
                    }
                    this.planValidationService.validateKey(validationAware, JobCreationConstants.SUB_BUILD_KEY, "job", buildKey);
                    this.planValidationService.validateName(validationAware, JobCreationConstants.BUILD_NAME, "job", buildName);
                    this.planValidationService.validateDescription(validationAware, JobCreationConstants.BUILD_DESCRIPTION, buildDescription);
                    if (!validationAware.hasErrors()) {
                        this.planValidationService.validateNewJobForExistingChain(validationAware, chain, buildKey, buildName);
                    }
                    DockerPipelineConfigurationImpl dockerPipelineConfiguration = new DockerPipelineConfigurationImpl();
                    dockerPipelineConfiguration.populateFromConfig((HierarchicalConfiguration)buildConfiguration);
                    ErrorCollection dockerValidationErrorCollection = this.dockerPipelineValidationService.validateDockerPipelineConfiguration((DockerPipelineConfiguration)dockerPipelineConfiguration);
                    dockerValidationErrorCollection.getErrorMessages().forEach(arg_0 -> ((ValidationAware)validationAware).addActionError(arg_0));
                    dockerValidationErrorCollection.getFieldErrors().forEach((field, errors) -> errors.forEach(error -> validationAware.addFieldError(field, error)));
                    if (validationAware.hasErrors()) {
                        return;
                    }
                    if (!cloneJob || !StringUtils.isNotBlank((CharSequence)jobKeyToClone)) break block6;
                    buildToClone = this.planManager.getPlanByKey(jobKeyToClone);
                    if (buildToClone != null) break block7;
                    validationAware.addFieldError(JobCreationConstants.JOB_KEY_TO_CLONE, "Could not find job to clone with key " + jobKeyToClone);
                    break block8;
                }
                Buildable buildable = (Buildable)Narrow.to((Object)buildToClone, Buildable.class);
                if (buildable != null) break block8;
                validationAware.addFieldError(JobCreationConstants.JOB_KEY_TO_CLONE, "You cannot clone a plan of type " + buildToClone.getType() + " to job");
                break block8;
            }
            for (PlanConfigHelper helper : this.getComponentsOnPage()) {
                helper.prepareConfig(buildConfiguration);
            }
            for (PlanConfigHelper helper : this.getComponentsOnPage()) {
                helper.validateConfig(validationAware, buildConfiguration);
            }
        }
    }

    public Job getNewInstance() {
        DefaultJob buildBeingCreated = new DefaultJob();
        ContainerManager.autowireComponent((Object)buildBeingCreated);
        return buildBeingCreated;
    }

    @Override
    protected MutableAcl getDefaultPermissionsForPlan(boolean accessForAllUsers) {
        return null;
    }

    public BuildConfiguration getBuildConfigurationWithDefaults() {
        BuildConfiguration buildConfiguration = new BuildConfiguration();
        buildConfiguration.setProperty("inheritRepository", (Object)"true");
        for (PlanConfigHelper helper : this.getComponentsOnPage()) {
            helper.addDefaultsToConfig(buildConfiguration);
        }
        return buildConfiguration;
    }

    @Override
    protected boolean performCloneIfRequired(@NotNull BuildConfiguration buildConfiguration, @NotNull PlanCreationBean planCreationBean, @NotNull ActionParametersMap params) {
        boolean cloneJob = JobParamMapHelper.isCloneJob(params);
        String jobKeyToClone = JobParamMapHelper.getJobKeyToClone(params);
        if (cloneJob && StringUtils.isNotBlank((CharSequence)jobKeyToClone) && this.isCreatingMasterJob(params)) {
            Plan plan = planCreationBean.getPlanBeingCreated();
            Plan planToClone = this.planManager.getPlanByKey(jobKeyToClone);
            if (plan == null) {
                throw new PlanCreationException("An internal error occurred, the plan you are creating went missing");
            }
            if (planToClone == null) {
                throw new PlanCreationException("Unable to find plan to clone (" + jobKeyToClone + ")");
            }
            Job job = (Job)Narrow.to((Object)plan, Job.class);
            if (job == null) {
                throw new PlanCreationException("An internal error occurred, cloning is not available for plan type: " + plan.getClass() + ".");
            }
            Job jobToClone = (Job)Narrow.to((Object)planToClone, Job.class);
            if (jobToClone == null) {
                throw new PlanCreationException("Cannot clone plan " + planToClone.getKey() + " it is the wrong plan type: " + planToClone.getClass());
            }
            return this.cloneBuildable(planCreationBean, params, jobToClone, job);
        }
        return false;
    }

    private boolean isCreatingMasterJob(ActionParametersMap params) {
        return !JobParamMapHelper.containsMasterJob(params);
    }

    public boolean cloneBuildable(@NotNull PlanCreationBean planCreationBean, @NotNull ActionParametersMap params, Job jobToClone, Job job) {
        XMLConfiguration configuration = this.buildDefinitionConverter.fromObject((PartialBuildDefinition)jobToClone.getBuildDefinition());
        BuildConfiguration buildConfiguration = new BuildConfiguration((HierarchicalConfiguration)configuration);
        planCreationBean.setConfigurationBeingEdited(buildConfiguration);
        RequirementSet requirementSetToClone = jobToClone.getRequirementSet();
        for (Requirement requirement : requirementSetToClone.getRequirements()) {
            RequirementImpl newRequirement = new RequirementImpl(requirement);
            job.getRequirementSet().addRequirement((Requirement)newRequirement);
        }
        Map clonedArtifactDefinitions = this.artifactDefinitionManager.cloneArtifactDefinitions(jobToClone, job, false);
        planCreationBean.setArtifactDefinitionsBeingCreated(new ArrayList(clonedArtifactDefinitions.values()));
        List subscriptionsToClone = this.artifactSubscriptionManager.findSubscriptionsOfPlan((PlanIdentifier)jobToClone);
        List unclonableArtifactSubscriptions = this.artifactSubscriptionManager.validateSubscriptions((ImmutableJob)jobToClone, (ImmutableChain)job.getParent(), job.getStage().getName());
        List clonedArtifactSubscriptions = subscriptionsToClone.stream().filter(subscription -> !unclonableArtifactSubscriptions.contains(subscription)).map(subscription -> new ArtifactSubscriptionImpl(subscription.getArtifactDefinition(), job, subscription.getDestinationDirectory())).collect(Collectors.toCollection(ArrayList::new));
        planCreationBean.setArtifactSubscriptionsBeingCreated(clonedArtifactSubscriptions);
        if (planCreationBean.getConfigurationBeingEdited() == null) {
            throw new PlanCreationException("Unable to clone plan " + jobToClone.getKey() + ". Unknown exception has occurred");
        }
        if (!jobToClone.getParent().getPlanKey().equals((Object)job.getParent().getPlanKey())) {
            List<PlanRepositoryDefinition> sourceChainRepositories = PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)jobToClone);
            List<PlanRepositoryDefinition> targetChainRepositories = PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)job);
            long defaultRepositoryId = targetChainRepositories.isEmpty() ? -1L : targetChainRepositories.get(0).getId();
            HashMap<Long, Long> repositoryIdChanges = new HashMap<Long, Long>();
            for (PlanRepositoryDefinition sourceRepo : sourceChainRepositories) {
                if (Iterables.any(targetChainRepositories, BambooPredicates.hasBambooObjectEqualId((BambooIdProvider)sourceRepo))) continue;
                repositoryIdChanges.put(sourceRepo.getId(), defaultRepositoryId);
            }
            planCreationBean.setRepositoryIdChanges(repositoryIdChanges);
        }
        return true;
    }

    @Override
    protected void prepareBuildConfiguration(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan, @NotNull PlanCreationBean planCreationBean) {
        if (!plan.hasMaster()) {
            for (PlanConfigHelper helper : this.getComponentsOnPage()) {
                helper.performPostActionsOnConfig(buildConfiguration, (ImmutablePlan)plan);
            }
            this.createDefaultCheckoutTask(buildConfiguration, (Job)plan);
        }
    }

    @Override
    public void cleanBuildConfiguration(@NotNull BuildConfiguration buildConfiguration, @NotNull Plan plan) {
        for (PlanConfigHelper helper : this.getComponentsOnPage()) {
            helper.cleanConfig(buildConfiguration);
        }
        JobCreationServiceImpl.cleanBuildConfiguration(buildConfiguration);
        buildConfiguration.clearTree("dependencies");
    }

    @Override
    public void setFullPlanKey(@NotNull Plan plan) {
        Job job = (Job)Narrow.to((Object)plan, Job.class);
        if (job == null) {
            throw new IllegalStateException("Plan type should be Job");
        }
        plan.setPlanKey(PlanKeys.getJobKey((PlanKey)job.getParent().getPlanKey(), (String)plan.getBuildKey()));
    }

    @Override
    public void saveAndUpdateParents(@NotNull PlanCreationBean planCreationBean) {
        Plan plan = planCreationBean.getPlanBeingCreated();
        Job job = (Job)Narrow.to((Object)plan, Job.class);
        if (job == null) {
            throw new IllegalStateException("trying to perform job operations on something that isn't a job - " + plan.getClass());
        }
        ChainStage chainStage = job.getStage();
        if (chainStage.getId() == -1L) {
            Chain chain = chainStage.getChain();
            chain.addStage(chainStage);
            this.planManager.savePlan((Plan)chain);
        }
    }

    @Override
    protected void performPostCreateAction(@NotNull Plan plan) {
    }

    @Override
    public void triggerCreationCompleteEvents(PlanKey planKey) {
        this.eventPublisher.publish((Object)new BuildCreatedEvent((Object)this, planKey.getKey()));
        this.eventPublisher.publish((Object)new BuildConfigurationUpdatedEvent((Object)this, planKey));
        this.auditLogService.log("Job has been created.", (Key)planKey, AuditLogEntityType.PLAN);
    }

    public List<PlanConfigHelper> getComponentsOnPage() {
        ArrayList<PlanConfigHelper> helpers = new ArrayList<PlanConfigHelper>();
        return helpers;
    }

    public String createSingleJob(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enabled) throws PlanCreationDeniedException, PlanCreationException {
        return this.createPlan(this.isCreatingMasterJob(actionParametersMap) ? buildConfiguration : new BuildConfiguration(), actionParametersMap, enabled, this::preparePlanDetails);
    }

    @Deprecated
    public String createPlan(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enabled) throws PlanCreationDeniedException, PlanCreationException {
        List<PlanKey> jobAndBranches = this.createJobAndBranches(buildConfiguration, actionParametersMap, enabled);
        return jobAndBranches.get(0).toString();
    }

    public List<PlanKey> createJobAndBranches(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enabled) throws PlanCreationDeniedException, PlanCreationException {
        ChainPropagatingFacade chainPropagatingFacade = new ChainPropagatingFacade(this.chainBranchManager, this.getChain(actionParametersMap));
        List<PlanKey> jobs = chainPropagatingFacade.createJob(this, buildConfiguration, (Map<String, ?>)actionParametersMap, enabled);
        return jobs;
    }

    private void preparePlanDetails(@NotNull Plan plan, @NotNull ActionParametersMap params) {
        String buildKey = JobParamMapHelper.getSubBuildKey(params);
        String buildName = JobParamMapHelper.getBuildName(params);
        String buildDescription = JobParamMapHelper.getBuildDescription(params);
        Chain chain = this.getChain(params);
        Job job = (Job)Narrow.to((Object)plan, Job.class);
        if (job == null) {
            throw new PlanCreationException("Cant add a plan of type " + plan.getClass() + " to a stage.");
        }
        Job masterJob = JobParamMapHelper.getMasterJob(params);
        job.setMaster((Plan)masterJob);
        plan.setProject(chain.getProject());
        plan.setBuildName(buildName);
        plan.setBuildKey(buildKey);
        plan.setDescription(buildDescription);
        String stageName = JobParamMapHelper.getStageName(params);
        String existingStage = JobParamMapHelper.getExistingStage(params);
        String stageDescription = JobParamMapHelper.getStageDescription(params);
        boolean stageManual = JobParamMapHelper.isStageManual(params);
        String dockerImage = JobParamMapHelper.getDockerImage(params);
        if (JobCreationServiceImpl.isNewStage(existingStage)) {
            this.createStageAndAddBuild(job, chain, stageName, stageDescription, stageManual);
        } else {
            this.addBuildToExistingStage(job, chain, existingStage);
        }
        if (StringUtils.isNotEmpty((CharSequence)dockerImage)) {
            this.taskManager.recalculateRequirementsForJob(job, true);
        }
    }

    private Chain getChain(ActionParametersMap params) {
        if (JobParamMapHelper.containsChain(params)) {
            return JobParamMapHelper.getChain(params);
        }
        String chainKey = JobParamMapHelper.getBuildKey(params);
        Plan parentPlan = this.planManager.getPlanByKey(chainKey, Plan.class);
        if (parentPlan == null) {
            throw new IllegalStateException("Unable to find Job's parent (plan key: " + chainKey + ")");
        }
        Chain chain = (Chain)Narrow.to((Object)parentPlan, Chain.class);
        if (chain == null) {
            throw new IllegalStateException("Parent plan was not a Chain, parent key: " + chainKey + " parent type: " + parentPlan.getClass());
        }
        return chain;
    }

    private static boolean isNewStage(String existingStage) {
        return JobCreationConstants.NEW_STAGE_MARKER.equals(existingStage) || StringUtils.isEmpty((CharSequence)existingStage);
    }

    private void addBuildToExistingStage(Job job, Chain chain, String stageName) {
        chain.getStages().stream().filter(chainStage -> Objects.equals(chainStage.getName(), stageName)).findFirst().ifPresent(arg_0 -> ((Job)job).setStage(arg_0));
    }

    private void createStageAndAddBuild(Job job, Chain chain, String stageName, String stageDescription, boolean optional) {
        ChainStageImpl stage = new ChainStageImpl(chain, stageName, stageDescription, optional, false);
        job.setStage((ChainStage)stage);
    }

    private void createDefaultCheckoutTask(BuildConfiguration buildConfiguration, Job job) {
        List<PlanRepositoryDefinition> repositoryDefinitions = PlanHelper.getPlanRepositoryDefinitions((ImmutablePlan)job);
        if (!repositoryDefinitions.isEmpty()) {
            LinkedList<TaskDefinition> tasks = new LinkedList<TaskDefinition>(TaskConfigurationUtils.getTaskDefinitionsFromConfig("buildTasks.", (HierarchicalConfiguration)buildConfiguration));
            TaskDefinitionImpl checkoutTask = new TaskDefinitionImpl(TaskConfigurationUtils.getUniqueId(tasks), "com.atlassian.bamboo.plugins.vcs:task.vcs.checkout", "Checkout Default Repository", true, Collections.emptyMap());
            checkoutTask.getConfiguration().put("selectedRepository_0", RepositoryTaskHelper.CFG_DEFAULT_REPOSITORY);
            checkoutTask.getConfiguration().put("checkoutDir_0", "");
            tasks.addFirst(checkoutTask);
            buildConfiguration.clearTree("buildTasks");
            TaskConfigurationUtils.addTaskDefinitionsToConfig(tasks, (HierarchicalConfiguration)buildConfiguration, "buildTasks.");
            PlanRepositoryDefinition defaultRepositoryDefinition = (PlanRepositoryDefinition)Iterables.getFirst(repositoryDefinitions, null);
            VcsRepositoryModuleDescriptor moduleDescriptor = this.vcsRepositoryManager.getVcsRepositoryModuleDescriptor(defaultRepositoryDefinition.getPluginKey());
            if (moduleDescriptor != null && moduleDescriptor.getWorkingCopyManager() instanceof FixedDirectoryWorkingCopyManager) {
                buildConfiguration.setProperty("repositoryDefiningWorkingDirectory", (Object)defaultRepositoryDefinition.getId());
            }
        }
    }
}

