/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.creation.JobCreationConstants;
import com.atlassian.bamboo.build.docker.BuildEnvironmentType;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.collections.ActionParametersMap;
import org.apache.commons.lang3.StringUtils;

public class JobParamMapHelper {
    private JobParamMapHelper() {
    }

    public static void setBuildKey(ActionParametersMap actionParametersMap, String buildKey) {
        actionParametersMap.put((Object)JobCreationConstants.BUILD_KEY, (Object)buildKey);
    }

    public static String getBuildKey(ActionParametersMap params) {
        return JobParamMapHelper.getKey(params, JobCreationConstants.BUILD_KEY);
    }

    public static void setSubBuildKey(ActionParametersMap actionParametersMap, String subBuildKey) {
        actionParametersMap.put((Object)JobCreationConstants.SUB_BUILD_KEY, (Object)subBuildKey);
    }

    public static String getSubBuildKey(ActionParametersMap params) {
        return JobParamMapHelper.getKey(params, JobCreationConstants.SUB_BUILD_KEY);
    }

    public static void setBuildName(ActionParametersMap actionParametersMap, String buildName) {
        actionParametersMap.put((Object)JobCreationConstants.BUILD_NAME, (Object)buildName);
    }

    public static String getBuildName(ActionParametersMap params) {
        return JobParamMapHelper.getTrimmedString(params, JobCreationConstants.BUILD_NAME);
    }

    public static void setBuildDescription(ActionParametersMap actionParametersMap, String buildDescription) {
        actionParametersMap.put((Object)JobCreationConstants.BUILD_DESCRIPTION, (Object)buildDescription);
    }

    public static String getBuildDescription(ActionParametersMap params) {
        return JobParamMapHelper.getTrimmedString(params, JobCreationConstants.BUILD_DESCRIPTION);
    }

    public static void setExistingStage(ActionParametersMap actionParametersMap, String existingStage) {
        actionParametersMap.put((Object)JobCreationConstants.EXISTING_STAGE, (Object)existingStage);
    }

    public static String getExistingStage(ActionParametersMap params) {
        return JobParamMapHelper.getTrimmedString(params, JobCreationConstants.EXISTING_STAGE);
    }

    public static void setStageName(ActionParametersMap actionParametersMap, String stageName) {
        actionParametersMap.put((Object)JobCreationConstants.STAGE_NAME, (Object)stageName);
    }

    public static String getStageName(ActionParametersMap params) {
        return JobParamMapHelper.getTrimmedString(params, JobCreationConstants.STAGE_NAME);
    }

    public static void setStageDescription(ActionParametersMap actionParametersMap, String stageDescription) {
        actionParametersMap.put((Object)JobCreationConstants.STAGE_DESCRIPTION, (Object)stageDescription);
    }

    public static String getStageDescription(ActionParametersMap params) {
        return JobParamMapHelper.getTrimmedString(params, JobCreationConstants.STAGE_DESCRIPTION);
    }

    public static void setStageManual(ActionParametersMap actionParametersMap, boolean stageManual) {
        actionParametersMap.put((Object)JobCreationConstants.STAGE_MANUAL, (Object)stageManual);
    }

    public static boolean isStageManual(ActionParametersMap params) {
        return params.getBoolean(JobCreationConstants.STAGE_MANUAL);
    }

    public static void setChain(ActionParametersMap actionParametersMap, Chain chain) {
        actionParametersMap.put((Object)JobCreationConstants.CHAIN, (Object)chain);
    }

    public static boolean containsChain(ActionParametersMap params) {
        return params.containsKey((Object)JobCreationConstants.CHAIN);
    }

    public static Chain getChain(ActionParametersMap params) {
        return (Chain)params.get((Object)JobCreationConstants.CHAIN);
    }

    public static void setMasterJob(ActionParametersMap actionParametersMap, Job masterJob) {
        actionParametersMap.put((Object)JobCreationConstants.MASTER_JOB, (Object)masterJob);
    }

    public static boolean containsMasterJob(ActionParametersMap params) {
        return params.containsKey((Object)JobCreationConstants.MASTER_JOB);
    }

    public static Job getMasterJob(ActionParametersMap params) {
        return (Job)params.get((Object)JobCreationConstants.MASTER_JOB);
    }

    public static void setCloneJob(ActionParametersMap actionParametersMap, boolean cloneJob) {
        actionParametersMap.put((Object)JobCreationConstants.CLONE_JOB, (Object)cloneJob);
    }

    public static boolean isCloneJob(ActionParametersMap params) {
        return params.getBoolean(JobCreationConstants.CLONE_JOB);
    }

    public static void setJobKeyToClone(ActionParametersMap actionParametersMap, String jobKeyToClone) {
        actionParametersMap.put((Object)JobCreationConstants.JOB_KEY_TO_CLONE, (Object)jobKeyToClone);
    }

    public static String getJobKeyToClone(ActionParametersMap params) {
        return JobParamMapHelper.getTrimmedString(params, JobCreationConstants.JOB_KEY_TO_CLONE);
    }

    private static String getKey(ActionParametersMap params, String key) {
        return StringUtils.upperCase((String)JobParamMapHelper.getTrimmedString(params, key));
    }

    private static String getTrimmedString(ActionParametersMap params, String key) {
        return params.getString(key, "").trim();
    }

    public static BuildEnvironmentType getRunEnvironmentIsolation(ActionParametersMap params) {
        return BuildEnvironmentType.valueOf(JobParamMapHelper.getTrimmedString(params, JobCreationConstants.JOB_RUN_ENVIRONMENT_ISOLATION));
    }

    public static String getDockerImage(ActionParametersMap parametersMap) {
        return parametersMap.getString(JobCreationConstants.DOCKER_IMAGE);
    }
}

