/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.build.creation.PlanConfigHelper;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.struts.ValidationAware;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Internal
@NotThreadSafe
public class PlanConfigHelpers {
    private static final Logger log = Logger.getLogger(PlanConfigHelpers.class);

    private PlanConfigHelpers() {
    }

    public static Runnable getValidationRunnableForHelpers(@NotNull ValidationAware validationAware, @NotNull BuildConfiguration buildConfiguration, PlanConfigHelper ... planConfigHelpers) {
        return new ValidationRunnable(validationAware, buildConfiguration, planConfigHelpers);
    }

    private static class ValidationRunnable
    implements Runnable {
        private final ValidationAware validationAware;
        private final BuildConfiguration buildConfiguration;
        private final PlanConfigHelper[] planConfigHelpers;

        public ValidationRunnable(ValidationAware validationAware, BuildConfiguration buildConfiguration, PlanConfigHelper[] planConfigHelpers) {
            this.validationAware = validationAware;
            this.buildConfiguration = buildConfiguration;
            this.planConfigHelpers = planConfigHelpers;
        }

        @Override
        public void run() {
            for (PlanConfigHelper helper : this.planConfigHelpers) {
                helper.prepareConfig(this.buildConfiguration);
            }
            for (PlanConfigHelper helper : this.planConfigHelpers) {
                helper.validateConfig(this.validationAware, this.buildConfiguration);
            }
        }
    }
}

