/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionForBuild;
import com.atlassian.bamboo.build.BuildNumberGeneratorService;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.DefaultBuildDefinition;
import com.atlassian.bamboo.build.DefaultBuildDefinitionForBuild;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.PartialBuildDefinition;
import com.atlassian.bamboo.build.PartialBuildDefinitionImpl;
import com.atlassian.bamboo.build.PlanCreationDeniedException;
import com.atlassian.bamboo.build.PlanCreationException;
import com.atlassian.bamboo.build.creation.ChainParamMapHelper;
import com.atlassian.bamboo.build.creation.PlanCreationBean;
import com.atlassian.bamboo.build.creation.PlanCreationService;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.fieldvalue.BuildDefinitionConverter;
import com.atlassian.bamboo.license.BambooLicenseManager;
import com.atlassian.bamboo.notification.NotificationManager;
import com.atlassian.bamboo.persister.AuditLogService;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanIdentifier;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.artifact.ArtifactDefinitionManager;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionManager;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.branch.VcsBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.repository.RepositoryDataEntity;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.schedule.PlanScheduler;
import com.atlassian.bamboo.security.acegi.acls.BambooAclUpdateHelper;
import com.atlassian.bamboo.security.acegi.acls.BambooPermission;
import com.atlassian.bamboo.security.acegi.acls.HibernateAcl;
import com.atlassian.bamboo.security.acegi.acls.HibernateAclImpl;
import com.atlassian.bamboo.security.acegi.acls.HibernateMutableAclService;
import com.atlassian.bamboo.security.acegi.acls.HibernateObjectIdentityImpl;
import com.atlassian.bamboo.task.TaskConfigurationService;
import com.atlassian.bamboo.trigger.TriggerConfigurationService;
import com.atlassian.bamboo.user.BambooAuthenticationContext;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.OptionalNarrow;
import com.atlassian.bamboo.variable.VariableDefinitionManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.ManagedLock;
import io.atlassian.util.concurrent.ManagedLocks;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.acegisecurity.acls.AccessControlEntry;
import org.acegisecurity.acls.Acl;
import org.acegisecurity.acls.MutableAcl;
import org.acegisecurity.acls.NotFoundException;
import org.acegisecurity.acls.OwnershipAcl;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.objectidentity.ObjectIdentity;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class PlanCreationTemplate
implements PlanCreationService {
    private static final Logger log = Logger.getLogger(PlanCreationTemplate.class);
    private final ManagedLock planCreationLock = ManagedLocks.newManagedLock();
    protected final PlanManager planManager;
    protected final BambooAuthenticationContext authenticationContext;
    protected final ProjectManager projectManager;
    protected final EventPublisher eventPublisher;
    protected final PlanValidationService planValidationService;
    protected final AuditLogService auditLogService;
    protected final BuildDefinitionConverter buildDefinitionConverter;
    protected final BambooAclUpdateHelper aclUpdateHelper;
    protected final BambooLicenseManager bambooLicenseManager;
    protected final ArtifactDefinitionManager artifactDefinitionManager;
    protected final ArtifactSubscriptionManager artifactSubscriptionManager;
    protected final VariableDefinitionManager variableDefinitionManager;
    protected final RepositoryDefinitionManager repositoryDefinitionManager;
    private final HibernateMutableAclService aclService;
    private final PlanScheduler planScheduler;
    private final TaskConfigurationService taskConfigurationService;
    protected final NotificationManager notificationManager;
    protected final BranchCommitInformationManager branchCommitInformationManager;
    protected final VcsBranchManager vcsBranchManager;
    protected final TriggerConfigurationService triggerConfigurationService;
    private final BuildNumberGeneratorService buildNumberGeneratorService;

    protected PlanCreationTemplate(PlanManager planManager, ProjectManager projectManager, BambooAclUpdateHelper aclUpdateHelper, BambooAuthenticationContext authenticationContext, BambooLicenseManager bambooLicenseManager, HibernateMutableAclService aclService, PlanScheduler planScheduler, EventPublisher eventPublisher, PlanValidationService planValidationService, AuditLogService auditLogService, BuildDefinitionConverter buildDefinitionConverter, ArtifactDefinitionManager artifactDefinitionManager, ArtifactSubscriptionManager artifactSubscriptionManager, VariableDefinitionManager variableDefinitionManager, RepositoryDefinitionManager repositoryDefinitionManager, TaskConfigurationService taskConfigurationService, NotificationManager notificationManager, BranchCommitInformationManager branchCommitInformationManager, VcsBranchManager vcsBranchManager, TriggerConfigurationService triggerConfigurationService, BuildNumberGeneratorService buildNumberGeneratorService) {
        this.planManager = planManager;
        this.authenticationContext = authenticationContext;
        this.projectManager = projectManager;
        this.aclUpdateHelper = aclUpdateHelper;
        this.bambooLicenseManager = bambooLicenseManager;
        this.aclService = aclService;
        this.planScheduler = planScheduler;
        this.eventPublisher = eventPublisher;
        this.planValidationService = planValidationService;
        this.auditLogService = auditLogService;
        this.buildDefinitionConverter = buildDefinitionConverter;
        this.artifactDefinitionManager = artifactDefinitionManager;
        this.artifactSubscriptionManager = artifactSubscriptionManager;
        this.variableDefinitionManager = variableDefinitionManager;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.taskConfigurationService = taskConfigurationService;
        this.notificationManager = notificationManager;
        this.branchCommitInformationManager = branchCommitInformationManager;
        this.vcsBranchManager = vcsBranchManager;
        this.triggerConfigurationService = triggerConfigurationService;
        this.buildNumberGeneratorService = buildNumberGeneratorService;
    }

    protected abstract boolean performCloneIfRequired(@NotNull BuildConfiguration var1, @NotNull PlanCreationBean var2, @NotNull ActionParametersMap var3) throws PlanCreationException, PlanCreationDeniedException;

    @Nullable
    protected abstract MutableAcl getDefaultPermissionsForPlan(boolean var1);

    protected abstract void prepareBuildConfiguration(@NotNull BuildConfiguration var1, @NotNull Plan var2, @NotNull PlanCreationBean var3);

    protected abstract void cleanBuildConfiguration(@NotNull BuildConfiguration var1, @NotNull Plan var2);

    @Deprecated
    protected void saveAndUpdateParents(@NotNull Plan plan) {
        PlanCreationBean planCreationBean = new PlanCreationBean();
        planCreationBean.setPlanBeingCreated(plan);
        this.saveAndUpdateParents(planCreationBean);
    }

    protected abstract void saveAndUpdateParents(@NotNull PlanCreationBean var1);

    protected abstract void setFullPlanKey(@NotNull Plan var1);

    protected abstract void performPostCreateAction(@NotNull Plan var1);

    public abstract void triggerCreationCompleteEvents(PlanKey var1);

    protected String createPlan(@NotNull BuildConfiguration buildConfiguration, @NotNull ActionParametersMap actionParametersMap, @NotNull PlanCreationService.EnablePlan enabled, @NotNull BiConsumer<Plan, ActionParametersMap> preparePlanDetails) throws PlanCreationDeniedException, PlanCreationException {
        BuildConfiguration completeConfig;
        Plan plan = this.getNewInstance();
        preparePlanDetails.accept(plan, actionParametersMap);
        this.setFullPlanKey(plan);
        if (enabled == PlanCreationService.EnablePlan.DISABLED) {
            plan.setSuspendedFromBuilding(true);
        }
        PlanCreationBean planCreationBean = new PlanCreationBean();
        boolean accessForAllUsers = ChainParamMapHelper.getPublicPlanAccess(actionParametersMap);
        planCreationBean.setAclBeingCreated(this.getDefaultPermissionsForPlan(accessForAllUsers));
        planCreationBean.setPublicAccessForNewProject(accessForAllUsers);
        planCreationBean.setPlanBeingCreated(plan);
        boolean cloned = this.performCloneIfRequired(buildConfiguration, planCreationBean, actionParametersMap);
        if (!cloned) {
            this.prepareBuildConfiguration(buildConfiguration, plan, planCreationBean);
            planCreationBean.setConfigurationBeingEdited(buildConfiguration);
        }
        if ((completeConfig = planCreationBean.getConfigurationBeingEdited()) == null) {
            throw new IllegalStateException("Half way through creating a Plan and for some reason we don't have a build config!!");
        }
        this.cleanBuildConfiguration(completeConfig, plan);
        if (log.isDebugEnabled()) {
            this.logBuildConfiguration(planCreationBean.getConfigurationBeingEdited());
        }
        try {
            return (String)this.planCreationLock.withLock(() -> {
                this.savePlan(planCreationBean);
                log.info((Object)("New Plan created with key " + plan.getKey()));
                return plan.getKey();
            });
        }
        catch (Exception e) {
            throw new PlanCreationException(e.getMessage(), (Throwable)e);
        }
    }

    public String savePlan(@NotNull PlanCreationBean planCreationBean) throws PlanCreationDeniedException, PlanCreationException {
        int currentPlans;
        BuildConfiguration buildConfiguration = planCreationBean.getConfigurationBeingEdited();
        Plan plan = planCreationBean.getPlanBeingCreated();
        OwnershipAcl acl = (OwnershipAcl)planCreationBean.getAclBeingCreated();
        this.validateThrowingPlanCreationException(plan != null, planCreationBean);
        this.validateThrowingPlanCreationException(buildConfiguration != null, planCreationBean);
        BuildDefinition buildDefinition = this.buildDefinitionConverter.copyConfigurationToDefinition((HierarchicalConfiguration)buildConfiguration, plan.hasMaster() ? new PartialBuildDefinitionImpl() : new DefaultBuildDefinition(false));
        String cleanedXml = ConfigUtils.asXmlString((XMLConfiguration)this.buildDefinitionConverter.fromObject((PartialBuildDefinition)buildDefinition));
        DefaultBuildDefinitionForBuild buildDefinitionForBuild = new DefaultBuildDefinitionForBuild(false);
        buildDefinitionForBuild.setXmlData(cleanedXml);
        plan.setBuildDefinitionXml((BuildDefinitionForBuild)buildDefinitionForBuild);
        int planLimit = this.bambooLicenseManager.getAllowedNumberOfPlans();
        if (-1 != planLimit && (currentPlans = this.planManager.getPlanCount(Buildable.class)) >= planLimit) {
            String message = String.format("Could not create plan, plan limit has been reached.  You currently have %d plans and your license allows only %d plans.", currentPlans, planLimit);
            throw new PlanCreationDeniedException(message);
        }
        if (plan.getKey() == null) {
            this.setFullPlanKey(plan);
        }
        this.saveAndUpdateParents(planCreationBean);
        try {
            this.planManager.createPlan(plan);
        }
        catch (DataIntegrityViolationException e) {
            throw new PlanCreationException("Plan " + plan.getKey() + " already exists.", (Throwable)e);
        }
        log.info((Object)("Creating plan with key: " + plan.getKey()));
        Plan createdBuild = this.planManager.getPlanByKey(plan.getPlanKey());
        if (acl != null && createdBuild != null) {
            ((HibernateAcl)acl).setObjectIdentity((ObjectIdentity)new HibernateObjectIdentityImpl(createdBuild));
            this.aclService.updateAcl((MutableAcl)acl);
        }
        this.savePlanArtifacts(planCreationBean);
        this.savePlanVariables(planCreationBean);
        this.savePlanRepositories(planCreationBean);
        if (CollectionUtils.isNotEmpty((Collection)planCreationBean.getVcsBranches())) {
            this.vcsBranchManager.createAll((Iterable)planCreationBean.getVcsBranches());
        }
        if (plan instanceof Chain) {
            this.buildNumberGeneratorService.initBuildNumbers((PlanIdentifier)plan);
        }
        this.performPostCreateAction(plan);
        this.planScheduler.scheduleTasksForPlanAndBranches((ImmutablePlan)plan);
        return plan.getKey();
    }

    private void savePlanArtifacts(PlanCreationBean planCreationBean) {
        if (CollectionUtils.isNotEmpty((Collection)planCreationBean.getArtifactDefinitionsBeingCreated())) {
            log.info((Object)"Saving artifact definitions...");
            this.artifactDefinitionManager.saveArtifactDefinitions((Collection)planCreationBean.getArtifactDefinitionsBeingCreated());
            log.info((Object)"Artifact definitions saved");
        }
        if (CollectionUtils.isNotEmpty((Collection)planCreationBean.getArtifactSubscriptionsBeingCreated())) {
            log.info((Object)"Saving artifact subscriptions...");
            this.artifactSubscriptionManager.saveArtifactSubscriptions((Collection)planCreationBean.getArtifactSubscriptionsBeingCreated());
            log.info((Object)"Artifact subscriptions saved");
        }
    }

    private void savePlanVariables(PlanCreationBean planCreationBean) {
        if (CollectionUtils.isNotEmpty((Collection)planCreationBean.getVariableDefinitionsBeingCreated())) {
            log.info((Object)"Saving variable definitions...");
            this.variableDefinitionManager.saveVariableDefinitions(planCreationBean.getVariableDefinitionsBeingCreated());
            log.info((Object)"Variable definitions saved");
        }
    }

    private void savePlanRepositories(PlanCreationBean planCreationBean) {
        List planRepositoriesBeingCreated;
        Plan plan = planCreationBean.getPlanBeingCreated();
        Map repositoriesBeingCreated = planCreationBean.getRepositoriesBeingCreated();
        if (MapUtils.isNotEmpty((Map)repositoriesBeingCreated)) {
            log.info((Object)"Saving repositories");
            this.repositoryDefinitionManager.saveRepositoryDefinitions(repositoriesBeingCreated.values());
            log.info((Object)"Repository definitions saved");
        }
        if (CollectionUtils.isNotEmpty((Collection)(planRepositoriesBeingCreated = planCreationBean.getPlanRepositoriesBeingCreated()))) {
            log.info((Object)"Saving plan repositories");
            this.repositoryDefinitionManager.savePlanRepositoryLinks(planRepositoriesBeingCreated);
            log.info((Object)"Plan repositories saved");
        }
        if (MapUtils.isNotEmpty((Map)repositoriesBeingCreated)) {
            HashMap repositoryIdChanges = new HashMap();
            for (Map.Entry entry : repositoriesBeingCreated.entrySet()) {
                repositoryIdChanges.put(entry.getKey(), ((RepositoryDataEntity)entry.getValue()).getId());
            }
            Chain chain = (Chain)Narrow.to((Object)plan, Chain.class);
            if (chain != null) {
                this.triggerConfigurationService.updateRepositoryIdsInTriggers(chain, repositoryIdChanges, false);
                chain.getAllJobs().forEach(job -> this.taskConfigurationService.updateRepositoryIdsInJobsTasks(job, repositoryIdChanges));
            }
        } else if (planCreationBean.getRepositoryIdChanges() != null) {
            OptionalNarrow.downTo((Object)plan, Job.class).ifPresent(job -> this.taskConfigurationService.updateRepositoryIdsInJobsTasks(job, planCreationBean.getRepositoryIdChanges()));
        }
    }

    public static void cleanBuildConfiguration(BuildConfiguration buildConfiguration) {
        buildConfiguration.clearTree("tmp");
        buildConfiguration.clearTree("temporary");
        buildConfiguration.clearTree("repository");
        buildConfiguration.clearTree("buildKey");
        buildConfiguration.clearTree("buildName");
        buildConfiguration.clearTree("buildDescription");
        buildConfiguration.clearTree("buildKeyToClone");
        buildConfiguration.clearTree("selectedPlanType");
        buildConfiguration.clearTree("projectKey");
        buildConfiguration.clearTree("projectName");
        buildConfiguration.clearTree("buildDescription");
        buildConfiguration.clearTree("existingProjectKey");
        buildConfiguration.clearTree("newProject");
        buildConfiguration.clearTree("chainKey");
        buildConfiguration.clearTree("chainName");
        buildConfiguration.clearTree("chainDescription");
        buildConfiguration.clearTree("checkBoxFields");
        buildConfiguration.clearTree("selectFields");
        buildConfiguration.clearTree("save");
        buildConfiguration.clearTree("isolationType");
        buildConfiguration.clearTree("dockerImage");
        buildConfiguration.clearProperty("linkedRepositoryAccessOption");
        Iterator buildConfigurationKeysIterator = buildConfiguration.getKeys();
        while (buildConfigurationKeysIterator.hasNext()) {
            String key = (String)buildConfigurationKeysIterator.next();
            if (!key.startsWith("bambooPermission_")) continue;
            buildConfiguration.clearProperty(key);
        }
    }

    protected void clonePlanPermissionsToSession(Plan buildToClone, PlanCreationBean planCreationBean, String planOwner) {
        AccessControlEntry[] accessControlEntries;
        Acl aclToClone;
        try {
            aclToClone = this.aclService.readAclById((ObjectIdentity)new HibernateObjectIdentityImpl(buildToClone));
        }
        catch (NotFoundException e) {
            log.error((Object)"Cloning a plan which does not have an Acl.");
            throw e;
        }
        PrincipalSid creator = new PrincipalSid(planOwner);
        HibernateAclImpl acl = new HibernateAclImpl(new HibernateObjectIdentityImpl(buildToClone.getClass(), (Serializable)Long.valueOf(-1L)), null, true, (Sid)creator);
        ContainerManager.autowireComponent((Object)acl);
        acl.insertAce(null, (Permission)BambooPermission.ADMINISTRATION, (Sid)creator, true);
        acl.insertAce(null, (Permission)BambooPermission.READ, (Sid)creator, true);
        acl.insertAce(null, (Permission)BambooPermission.CLONE, (Sid)creator, true);
        acl.insertAce(null, (Permission)BambooPermission.BUILD, (Sid)creator, true);
        acl.insertAce(null, (Permission)BambooPermission.WRITE, (Sid)creator, true);
        for (AccessControlEntry accessControlEntry : accessControlEntries = aclToClone.getEntries()) {
            Sid sid = accessControlEntry.getSid();
            Permission perm = accessControlEntry.getPermission();
            boolean alreadyGranted = false;
            try {
                alreadyGranted = acl.isGranted(new Permission[]{perm}, new Sid[]{sid}, false);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (alreadyGranted) continue;
            acl.insertAce(null, perm, sid, true);
        }
        planCreationBean.setAclBeingCreated((MutableAcl)acl);
    }

    protected void logBuildConfiguration(BuildConfiguration buildConfiguration) {
        Iterator buildConfigurationKeysIterator = buildConfiguration.getKeys();
        while (buildConfigurationKeysIterator.hasNext()) {
            String key = (String)buildConfigurationKeysIterator.next();
            buildConfiguration.getProperty(key);
            log.debug((Object)String.format("BuildConfiguration property, key: %s, value: %s", key, buildConfiguration.getProperty(key)));
        }
    }

    @Contract(value="false,_ -> fail")
    private void validateThrowingPlanCreationException(boolean condition, PlanCreationBean planCreationBean) {
        if (!condition) {
            throw new PlanCreationException("Unable to create a build plan. Information incomplete: " + ToStringBuilder.reflectionToString((Object)planCreationBean));
        }
    }

    @Contract(value="false,_ -> fail")
    protected void validateThrowingPlanCreationException(boolean condition, String message) {
        if (!condition) {
            throw new PlanCreationException(message);
        }
    }
}

