/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.build.creation.JobCreationConstants;
import com.atlassian.bamboo.build.creation.PlanValidationService;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.branch.ChainBranchManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.project.ProjectConfigurationService;
import com.atlassian.bamboo.project.ProjectManager;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.validation.ValidationService;
import com.atlassian.struts.ValidationAware;
import com.opensymphony.xwork2.TextProvider;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanValidationServiceImpl
implements PlanValidationService {
    public static final Pattern KEY_PATTERN = Pattern.compile("[A-Z][A-Z0-9]{1,}");
    public static final String PLAN_PREFIX = "plan";
    public static final String PROJECT_PREFIX = "project";
    public static final String CHAIN_PREFIX = "chain";
    public static final String JOB_PREFIX = "job";
    public static final String STAGE_PREFIX = "stage";
    private final ValidationService validationService;
    private final ProjectManager projectManager;
    private final PlanManager planManager;
    private final TextProvider textProvider;
    private final ChainBranchManager chainBranchManager;
    private final ProjectConfigurationService projectConfigurationService;

    public PlanValidationServiceImpl(ValidationService validationService, ProjectManager projectManager, PlanManager planManager, TextProvider textProvider, ChainBranchManager chainBranchManager, ProjectConfigurationService projectConfigurationService) {
        this.validationService = validationService;
        this.projectManager = projectManager;
        this.planManager = planManager;
        this.textProvider = textProvider;
        this.chainBranchManager = chainBranchManager;
        this.projectConfigurationService = projectConfigurationService;
    }

    public void validateKey(@NotNull ValidationAware validationAware, String fieldName, String errorPrefix, String key) {
        switch (PlanValidationServiceImpl.validateKeyInternal(key)) {
            case EMPTY_KEY: {
                validationAware.addFieldError(fieldName, this.textProvider.getText(errorPrefix + ".key.empty"));
                return;
            }
            case DOES_NOT_MATCH_PATTERN: {
                validationAware.addFieldError(fieldName, this.textProvider.getText(errorPrefix + ".key.invalid"));
                return;
            }
            case TOO_LONG: {
                validationAware.addFieldError(fieldName, this.textProvider.getText(errorPrefix + ".key.tooLong"));
            }
        }
    }

    static ValidateKeyResult validateKeyInternal(@Nullable String key) {
        if (StringUtils.isBlank((CharSequence)key)) {
            return ValidateKeyResult.EMPTY_KEY;
        }
        assert (key != null);
        if (!KEY_PATTERN.matcher(key).matches()) {
            return ValidateKeyResult.DOES_NOT_MATCH_PATTERN;
        }
        if (key.length() > 255) {
            return ValidateKeyResult.TOO_LONG;
        }
        return ValidateKeyResult.OK;
    }

    public void validateName(@NotNull ValidationAware validationAware, String fieldName, String errorPrefix, String name) {
        ErrorCollection errorCollection = this.validationService.validateName(fieldName, errorPrefix, name);
        this.copyToValidationAware(errorCollection, validationAware);
    }

    public void validateDescription(@NotNull ValidationAware validationAware, String fieldName, String description) {
        ErrorCollection errorCollection = this.validationService.validateDescription(fieldName, description);
        this.copyToValidationAware(errorCollection, validationAware);
    }

    public void validatePlanToCloneExists(@NotNull ValidationAware validationAware, @Nullable String buildKeyToClone) {
        if (StringUtils.isBlank((CharSequence)buildKeyToClone)) {
            validationAware.addFieldError("clonePlan", this.textProvider.getText("plan.clone.missing"));
        } else {
            Plan planToClone = this.planManager.getPlanByKey(buildKeyToClone);
            if (planToClone == null) {
                validationAware.addFieldError("buildKeyToClone", this.textProvider.getText("build.clone.invalid"));
            }
        }
    }

    public void validateNewPlanDetails(@NotNull ValidationAware validationAware, String buildKey, String buildName) {
        this.validateKey(validationAware, JobCreationConstants.BUILD_KEY, PLAN_PREFIX, buildKey);
        this.validateName(validationAware, JobCreationConstants.BUILD_NAME, PLAN_PREFIX, buildName);
    }

    public void validateNewJobForExistingChain(@NotNull ValidationAware validationAware, @NotNull Chain existingChain, @NotNull String buildKey, @Nullable String buildName) {
        PlanKey jobKey = PlanKeys.getJobKey((PlanKey)existingChain.getPlanKey(), (String)buildKey);
        if (this.planManager.getPlanByPartialKeyAndName(existingChain.getPlanKey(), buildName, Plan.class) != null) {
            validationAware.addFieldError(JobCreationConstants.BUILD_NAME, this.textProvider.getText("job.name.exists"));
        }
        if (this.planManager.getPlanByKey(jobKey, Plan.class) != null) {
            validationAware.addFieldError(JobCreationConstants.SUB_BUILD_KEY, this.textProvider.getText("job.key.exists"));
        }
    }

    public void validateNewChainForExistingProject(@NotNull ValidationAware validationAware, String existingProjectKey, String buildKey, String buildName) {
        Plan conflictingKeyPlan;
        PlanKey planKey = PlanKeys.getPlanKey((String)existingProjectKey, (String)buildKey);
        this.validateNewChainForExistingProject(validationAware, existingProjectKey, buildName);
        if (this.planManager.isPlanKeyConflicting(planKey) && (conflictingKeyPlan = this.planManager.getPlanByKey(planKey)) != null) {
            if (conflictingKeyPlan.isMarkedForDeletion()) {
                validationAware.addFieldError("chainKey", this.textProvider.getText("plan.key.exists.marked.for.deletion"));
            } else {
                validationAware.addFieldError("chainKey", this.textProvider.getText("plan.key.exists"));
            }
        }
    }

    public void validateNewChainForExistingProject(@NotNull ValidationAware validationAware, @NotNull String existingProjectKey, @NotNull String buildName) {
        this.validateProjectKey(validationAware, existingProjectKey);
        if (this.planManager.isChainNameConflicting(existingProjectKey, -1L, buildName)) {
            validationAware.addFieldError("chainName", this.textProvider.getText("chain.name.exists"));
        }
    }

    public void validateNewPlanBranchForMaster(@NotNull ValidationAware validationAware, @NotNull ImmutableChain masterChain, @NotNull String branchName) {
        if (this.chainBranchManager.isPlanBranchNameConflicting(masterChain, -1L, branchName)) {
            validationAware.addFieldError("branchName", this.textProvider.getText("branch.name.exists"));
        }
    }

    public void validateNewProjectDetails(@NotNull ValidationAware validationAware, String projectName, String projectKey) {
        this.validateNewProjectDetails(validationAware, projectName, projectKey, "");
    }

    public void validateNewProjectDetails(@NotNull ValidationAware validationAware, @Nullable String projectName, @Nullable String projectKey, @Nullable String projectDescription) {
        ErrorCollection errorCollection = this.projectConfigurationService.validateProjectForCreation(projectKey, projectName, projectDescription);
        this.copyToValidationAware(errorCollection, validationAware);
    }

    public void validateNewStageForChain(@NotNull ValidationAware validationAware, @NotNull Chain chain, @Nullable String stageName) {
        if (!StringUtils.isBlank((CharSequence)stageName) && chain.containsStage(stageName)) {
            validationAware.addFieldError("stageName", this.textProvider.getText("stage.name.exists"));
        }
    }

    public void validateStageExistsForChain(ValidationAware validationAware, Chain chain, String stageName) {
        if (!chain.containsStage(stageName)) {
            validationAware.addFieldError("existingStage", this.textProvider.getText("stage.name.nonExistant"));
        }
    }

    private void validateProjectKey(ValidationAware validationAware, String existingProjectKey) {
        if (this.projectManager.getProjectByKey(existingProjectKey) == null) {
            validationAware.addFieldError("existingProjectKey", this.textProvider.getText("project.existing.invalid"));
        }
    }

    private void copyToValidationAware(@NotNull ErrorCollection errorCollection, @NotNull ValidationAware validationAware) {
        for (String string : errorCollection.getErrorMessages()) {
            validationAware.addActionError(string);
        }
        for (Map.Entry entry : errorCollection.getFieldErrors().entrySet()) {
            for (String s : (List)entry.getValue()) {
                validationAware.addFieldError((String)entry.getKey(), s);
            }
        }
    }

    public void validateKey(@NotNull com.opensymphony.xwork.ValidationAware validationAware, String fieldName, String errorPrefix, String key) {
        this.validateKey((ValidationAware)validationAware, fieldName, errorPrefix, key);
    }

    public void validateName(@NotNull com.opensymphony.xwork.ValidationAware validationAware, String fieldName, String errorPrefix, String name) {
        this.validateName((ValidationAware)validationAware, fieldName, errorPrefix, name);
    }

    public void validateDescription(@NotNull com.opensymphony.xwork.ValidationAware validationAware, String fieldName, String description) {
        this.validateDescription((ValidationAware)validationAware, fieldName, description);
    }

    public void validatePlanToCloneExists(@NotNull com.opensymphony.xwork.ValidationAware validationAware, @Nullable String buildKeyToClone) {
        this.validatePlanToCloneExists((ValidationAware)validationAware, buildKeyToClone);
    }

    public void validateNewPlanDetails(@NotNull com.opensymphony.xwork.ValidationAware validationAware, @Nullable String buildKey, @Nullable String buildName) {
        this.validateNewPlanDetails((ValidationAware)validationAware, buildKey, buildName);
    }

    public void validateNewJobForExistingChain(@NotNull com.opensymphony.xwork.ValidationAware validationAware, @NotNull Chain existingChain, @NotNull String buildKey, @Nullable String buildName) {
        this.validateNewJobForExistingChain((ValidationAware)validationAware, existingChain, buildKey, buildName);
    }

    public void validateNewChainForExistingProject(@NotNull com.opensymphony.xwork.ValidationAware validationAware, String existingProjectKey, String chainKey, String chainName) {
        this.validateNewChainForExistingProject((ValidationAware)validationAware, existingProjectKey, chainKey, chainName);
    }

    public void validateNewChainForExistingProject(@NotNull com.opensymphony.xwork.ValidationAware validationAware, @NotNull String existingProjectKey, @NotNull String chainName) {
        this.validateNewChainForExistingProject((ValidationAware)validationAware, existingProjectKey, chainName);
    }

    public void validateNewPlanBranchForMaster(@NotNull com.opensymphony.xwork.ValidationAware validationAware, @NotNull ImmutableChain masterChain, @NotNull String branchName) {
        this.validateNewPlanBranchForMaster((ValidationAware)validationAware, masterChain, branchName);
    }

    public void validateNewProjectDetails(@NotNull com.opensymphony.xwork.ValidationAware validationAware, @Nullable String projectName, @Nullable String projectKey) {
        this.validateNewProjectDetails((ValidationAware)validationAware, projectName, projectKey);
    }

    public void validateNewStageForChain(com.opensymphony.xwork.ValidationAware validationAware, Chain chain, String stageName) {
        this.validateNewStageForChain((ValidationAware)validationAware, chain, stageName);
    }

    public void validateStageExistsForChain(com.opensymphony.xwork.ValidationAware validationAware, Chain chain, String stageName) {
        this.validateStageExistsForChain((ValidationAware)validationAware, chain, stageName);
    }

    static enum ValidateKeyResult {
        OK,
        DOES_NOT_MATCH_PATTERN,
        TOO_LONG,
        EMPTY_KEY;

    }
}

