/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutableJob;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.repository.Repository;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.repository.RepositoryTaskHelper;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.vcs.configuration.PlanRepositoryDefinition;
import com.atlassian.bamboo.vcs.module.VcsRepositoryManager;
import com.atlassian.bamboo.vcs.module.VcsRepositoryModuleDescriptor;
import com.atlassian.bamboo.vcs.runtime.FixedDirectoryWorkingCopyManager;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@Internal
public class RepositoryConfigHelper {
    private static final Logger log = Logger.getLogger(RepositoryConfigHelper.class);
    private static final String REPOSITORY_ROOT = "repository";
    private static final String CHANGE_ROOT = "repository.change";

    private RepositoryConfigHelper() {
    }

    public static XMLConfiguration prepareXmlConfiguration(@NotNull Repository repository, @Nullable WebRepositoryViewer webRepositoryViewer) {
        HierarchicalConfiguration hierarchicalConfiguration = repository.toConfiguration();
        if (webRepositoryViewer != null) {
            HierarchicalConfiguration webRepositoryConfiguration = webRepositoryViewer.toConfiguration();
            Iterator keys = webRepositoryConfiguration.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = webRepositoryConfiguration.getProperty(key);
                hierarchicalConfiguration.setProperty(key, value);
            }
            hierarchicalConfiguration.setProperty("selectedWebRepositoryViewer", (Object)webRepositoryViewer.getKey());
        }
        return ConfigUtils.newConfiguration((HierarchicalConfiguration)hierarchicalConfiguration);
    }

    public static String prepareXmlConfigurationString(@NotNull Repository repository, @Nullable WebRepositoryViewer webRepositoryViewer) {
        return ConfigUtils.asXmlString((XMLConfiguration)RepositoryConfigHelper.prepareXmlConfiguration(repository, webRepositoryViewer));
    }

    public static Map<Long, String> getRepositoriesForWorkingDirSelection(@NotNull ImmutableJob job, @NotNull VcsRepositoryManager vcsRepositoryManager) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        int repositoryCounter = 0;
        for (TaskDefinition taskDefinition : BambooPluginUtils.filterTasks(job, "com.atlassian.bamboo.plugins.vcs:task.vcs.checkout")) {
            for (PlanRepositoryDefinition repositoryDefinition : RepositoryTaskHelper.safeGetPlanRepositoriesUsedByTask(taskDefinition, new ArrayList<PlanRepositoryDefinition>(PlanHelper.getPlanRepositoryDefinitionMap((ImmutablePlan)job).values()))) {
                VcsRepositoryModuleDescriptor moduleDescriptor = vcsRepositoryManager.getVcsRepositoryModuleDescriptor(repositoryDefinition.getPluginKey());
                ++repositoryCounter;
                if (moduleDescriptor == null || !FixedDirectoryWorkingCopyManager.class.isAssignableFrom(moduleDescriptor.getModuleClass())) continue;
                map.put(repositoryDefinition.getId(), repositoryDefinition.getName());
            }
        }
        if (repositoryCounter > 1 && !map.isEmpty()) {
            return map;
        }
        return Collections.emptyMap();
    }
}

