/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.event.ChainCreatedEvent;
import com.atlassian.bamboo.plan.branch.BranchCommitInformationManager;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutableChainBranch;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryException;
import com.atlassian.bamboo.variable.CustomVariableContext;
import com.atlassian.bamboo.variable.substitutor.VariableSubstitutorFactory;
import com.atlassian.event.api.EventListener;
import com.google.common.base.Throwables;
import javax.inject.Inject;
import org.apache.log4j.Logger;

public class UpdateCreatingCommitInformationListener {
    private static final Logger log = Logger.getLogger(UpdateCreatingCommitInformationListener.class);
    @Inject
    private BranchCommitInformationManager branchCommitInformationManager;
    @Inject
    private CachedPlanManager cachedPlanManager;
    @Inject
    private VariableSubstitutorFactory variableSubstitutorFactory;
    @Inject
    private CustomVariableContext customVariableContext;

    @EventListener
    public void onChainCreatedEvent(ChainCreatedEvent event) {
        try {
            this.onChainCreatedEventInternal(event);
        }
        catch (RuntimeException e) {
            log.error((Object)"Exception when initiating chain branch status", (Throwable)e);
        }
    }

    private void onChainCreatedEventInternal(ChainCreatedEvent event) {
        ImmutableChain chain = (ImmutableChain)this.cachedPlanManager.getPlanByKey(event.getPlanKey(), ImmutableChain.class);
        if (chain == null || !chain.hasMaster() || !(chain instanceof ImmutableChainBranch)) {
            return;
        }
        ImmutableChainBranch branch = (ImmutableChainBranch)chain;
        if (branch.getCommitInformation() != null && branch.getCommitInformation().getCreatingChangeSetId() != null) {
            return;
        }
        this.customVariableContext.withVariableSubstitutor(this.variableSubstitutorFactory.newSubstitutorForPlan((ImmutablePlan)branch), () -> {
            try {
                this.branchCommitInformationManager.initialiseCommitInformation(branch);
            }
            catch (RepositoryException e) {
                throw Throwables.propagate((Throwable)e);
            }
        });
    }
}

