/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.creation;

import com.atlassian.bamboo.build.creation.PlanConfigHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.ErrorCollectionUtils;
import com.atlassian.bamboo.webrepository.WebRepositoryViewer;
import com.atlassian.bamboo.webrepository.WebRepositoryViewerManager;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class WebRepositoryConfigHelper
implements PlanConfigHelper {
    private static final Logger log = Logger.getLogger(WebRepositoryConfigHelper.class);
    private final WebRepositoryViewerManager webRepositoryViewerManager;
    private final TextProvider textProvider;

    public WebRepositoryConfigHelper(WebRepositoryViewerManager webRepositoryViewerManager, TextProvider textProvider) {
        this.webRepositoryViewerManager = webRepositoryViewerManager;
        this.textProvider = textProvider;
    }

    public void addDefaultsToConfig(@NotNull BuildConfiguration buildConfiguration) {
        for (WebRepositoryViewer webRepository : this.webRepositoryViewerManager.getWebRepositoryViewers()) {
            webRepository.addDefaultValues(buildConfiguration);
        }
    }

    public void validateConfig(@NotNull com.atlassian.struts.ValidationAware validationAware, @NotNull BuildConfiguration buildConfiguration) {
        String repositoryKey = buildConfiguration.getString("selectedRepository");
        String selectedWebRepositoryViewer = buildConfiguration.getString("selectedWebRepositoryViewer");
        WebRepositoryViewer viewer = this.webRepositoryViewerManager.getNewWebRepositoryViewerInstance(selectedWebRepositoryViewer);
        if (viewer != null) {
            Collection supportedRepos = viewer.getSupportedRepositories();
            if (!supportedRepos.isEmpty() && !supportedRepos.contains(repositoryKey)) {
                validationAware.addFieldError("selectedWebRepositoryViewer", this.textProvider.getText("webRepositoryViewer.unsupportedRepository"));
            }
            ErrorCollectionUtils.addErrorCollection(validationAware, viewer.validate(buildConfiguration));
        } else {
            validationAware.addFieldError("selectedWebRepositoryViewer", this.textProvider.getText("webRepositoryViewer.incorrectKey"));
        }
    }

    public void validateConfig(@NotNull ValidationAware validationAware, @NotNull BuildConfiguration buildConfiguration) {
        this.validateConfig((com.atlassian.struts.ValidationAware)validationAware, buildConfiguration);
    }

    public void prepareConfig(@NotNull BuildConfiguration buildConfiguration) {
        String selectedWebRepository = buildConfiguration.getString("selectedWebRepositoryViewer");
        if (StringUtils.isBlank((CharSequence)selectedWebRepository)) {
            buildConfiguration.addProperty("selectedWebRepositoryViewer", (Object)"bamboo.webrepositoryviewer.provided:noRepositoryViewer");
            selectedWebRepository = "bamboo.webrepositoryviewer.provided:noRepositoryViewer";
        }
        for (WebRepositoryViewer webRepository : this.webRepositoryViewerManager.getWebRepositoryViewers()) {
            if (!webRepository.getKey().equals(selectedWebRepository)) continue;
            webRepository.prepareConfigObject(buildConfiguration);
            return;
        }
    }

    public void cleanConfig(@NotNull BuildConfiguration buildConfiguration) {
        String selectedWebRepository = buildConfiguration.getString("selectedWebRepositoryViewer");
        for (WebRepositoryViewer webRepository : this.webRepositoryViewerManager.getWebRepositoryViewers()) {
            if (webRepository.getKey().equals(selectedWebRepository)) continue;
            buildConfiguration.clearTree("webRepository." + webRepository.getShortKey());
        }
    }

    public void performPostActionsOnConfig(@NotNull BuildConfiguration buildConfiguration, @NotNull ImmutablePlan plan) {
    }
}

