/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.docker;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.docker.BuildEnvironmentType;
import com.atlassian.bamboo.build.docker.DockerHandler;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.build.docker.DockerPipelineValidationService;
import com.atlassian.bamboo.deployments.configuration.service.EnvironmentCustomConfigService;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.docker.DockerConfigurationHelper;
import com.atlassian.bamboo.struts.OgnlStackUtils;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.utils.ConfigUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;

public class DefaultDockerHandlerImpl
implements DockerHandler {
    private final ModuleDescriptor moduleDescriptor;
    private final TemplateRenderer templateRenderer;
    private final DockerPipelineConfiguration configuration;
    private final DockerPipelineValidationService dockerPipelineValidationService;
    private final EnvironmentCustomConfigService environmentCustomConfigService;
    private final TaskManager taskManager;
    private final boolean create;

    public DefaultDockerHandlerImpl(DockerPipelineConfiguration configuration, DockerPipelineValidationService dockerPipelineValidationService, EnvironmentCustomConfigService environmentCustomConfigService, ModuleDescriptor moduleDescriptor, TemplateRenderer templateRenderer, TaskManager taskManager, boolean create) {
        this.moduleDescriptor = moduleDescriptor;
        this.templateRenderer = templateRenderer;
        this.configuration = configuration;
        this.dockerPipelineValidationService = dockerPipelineValidationService;
        this.environmentCustomConfigService = environmentCustomConfigService;
        this.taskManager = taskManager;
        this.create = create;
    }

    @Override
    public String getEditHtml() {
        return this.render("edit");
    }

    String render(String type) {
        ResourceLocation resourceLocation = this.moduleDescriptor.getResourceLocation("freemarker", type);
        if (resourceLocation != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("create", this.create);
            context.put("dockerImage", this.configuration.getImage() == null ? "" : this.configuration.getImage());
            context.put("dataVolumes", this.configuration.getDataVolumes());
            OgnlStackUtils.putAll(context);
            String templatePath = resourceLocation.getLocation();
            return this.templateRenderer.render(templatePath, context);
        }
        return "";
    }

    @Override
    public String getViewHtml() {
        return this.render("view");
    }

    @Override
    public boolean isEnabled() {
        return this.configuration.isEnabled();
    }

    @Override
    public String getIsolationType() {
        return BuildEnvironmentType.DOCKER.name();
    }

    @Override
    public ErrorCollection validateConfig(Map<String, Object> webFragmentsContextMap) {
        DockerPipelineConfiguration dockerPipelineConfiguration = DefaultDockerHandlerImpl.createDockerPipelineConfiguration(webFragmentsContextMap, this.extractVolumes(webFragmentsContextMap));
        return this.dockerPipelineValidationService.validateDockerPipelineConfiguration(dockerPipelineConfiguration);
    }

    @Override
    public void enableAndUpdate(BuildDefinition buildDefinition, Job job, Map<String, Object> webFragmentsContextMap) {
        DockerPipelineConfiguration dc = buildDefinition.getDockerPipelineConfiguration();
        dc.setEnabled(true);
        dc.setImage((String)webFragmentsContextMap.getOrDefault("dockerImage", null));
        dc.setDataVolumes(this.extractVolumes(webFragmentsContextMap));
        this.taskManager.recalculateRequirementsForJob(job, true);
    }

    @Override
    public void enableAndUpdate(Environment environment, Map<String, Object> webFragmentsContextMap) {
        DockerPipelineConfiguration dc = this.environmentCustomConfigService.getDockerPipelineConfiguration(environment.getId());
        dc.setEnabled(true);
        dc.setImage((String)webFragmentsContextMap.getOrDefault("dockerImage", null));
        dc.setDataVolumes(this.extractVolumes(webFragmentsContextMap));
        this.environmentCustomConfigService.saveDockerPipelineConfiguration(dc, environment.getId());
    }

    @Override
    public void disable(BuildDefinition buildDefinition, Job job) {
        DockerPipelineConfiguration dc = buildDefinition.getDockerPipelineConfiguration();
        this.disable(dc);
        this.taskManager.recalculateRequirementsForJob(job, false);
    }

    @Override
    public void disable(Environment environment) {
        DockerPipelineConfiguration dc = this.environmentCustomConfigService.getDockerPipelineConfiguration(environment.getId());
        this.disable(dc);
        this.environmentCustomConfigService.saveDockerPipelineConfiguration(dc, environment.getId());
    }

    private DockerPipelineConfiguration disable(DockerPipelineConfiguration dc) {
        dc.setEnabled(false);
        dc.setImage(null);
        dc.setDataVolumes((Iterable)Collections.EMPTY_LIST);
        return dc;
    }

    private List<DataVolume> extractVolumes(Map<String, Object> webFragmentsContextMap) {
        return this.create ? DockerConfigurationHelper.DEFAULT_VOLUMES : DockerConfigurationHelper.DATA_VOLUME_FROM_CONFIG_EXTRACTOR.apply(webFragmentsContextMap);
    }

    static DockerPipelineConfiguration createDockerPipelineConfiguration(Map<String, Object> webfragmentsContextMap, List<DataVolume> dataVolumes) {
        String dockerImage = webfragmentsContextMap.getOrDefault("dockerImage", null);
        DockerPipelineConfigurationImpl dockerPipelineConfiguration = new DockerPipelineConfigurationImpl();
        dockerPipelineConfiguration.setEnabled(true);
        dockerPipelineConfiguration.setImage(dockerImage);
        dockerPipelineConfiguration.setDataVolumes(dataVolumes);
        return dockerPipelineConfiguration;
    }

    @Override
    public void appendConfiguration(BuildConfiguration buildConfiguration, Map<String, Object> webFragmentsContextMap, boolean enabled) {
        DockerPipelineConfiguration dockerPipelineConfiguration = DefaultDockerHandlerImpl.createDockerPipelineConfiguration(webFragmentsContextMap, DockerConfigurationHelper.DEFAULT_VOLUMES);
        if (!enabled) {
            dockerPipelineConfiguration = this.disable(dockerPipelineConfiguration);
        }
        buildConfiguration.clearTree(DockerPipelineConfigurationImpl.CONFIG_FIELD_PREFIX);
        ConfigUtils.copyNodes((HierarchicalConfiguration)dockerPipelineConfiguration.toConfiguration(), (HierarchicalConfiguration)buildConfiguration.getProjectConfig());
    }
}

