/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.docker;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.docker.BuildEnvironmentType;
import com.atlassian.bamboo.build.docker.DefaultDockerHandlerImpl;
import com.atlassian.bamboo.build.docker.DockerHandler;
import com.atlassian.bamboo.build.docker.DockerHandlerProvider;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineConfigurationImpl;
import com.atlassian.bamboo.build.docker.DockerPipelineValidationService;
import com.atlassian.bamboo.deployments.configuration.service.EnvironmentCustomConfigService;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.docker.DockerConfigurationHelper;
import com.atlassian.bamboo.task.TaskManager;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.plugin.ModuleDescriptor;
import com.opensymphony.xwork2.TextProvider;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDockerHandlerProvider
implements DockerHandlerProvider<ModuleDescriptor> {
    private ModuleDescriptor moduleDescriptor;
    private final EnvironmentCustomConfigService environmentCustomConfigService;
    private final TemplateRenderer templateRenderer;
    private final DockerPipelineValidationService dockerPipelineValidationService;
    private final TaskManager taskManager;

    public DefaultDockerHandlerProvider(EnvironmentCustomConfigService environmentCustomConfigService, DockerPipelineValidationService dockerPipelineValidationService, TemplateRenderer templateRenderer, TaskManager taskManager) {
        this.environmentCustomConfigService = environmentCustomConfigService;
        this.templateRenderer = templateRenderer;
        this.dockerPipelineValidationService = dockerPipelineValidationService;
        this.taskManager = taskManager;
    }

    public void init(ModuleDescriptor moduleDescriptor) {
        this.moduleDescriptor = moduleDescriptor;
    }

    @Override
    public String getIsolationType() {
        return BuildEnvironmentType.DOCKER.name();
    }

    @Override
    public DockerHandler getHandler(@Nullable BuildDefinition job, boolean create) {
        DockerPipelineConfiguration impl = job == null ? this.createNew() : job.getDockerPipelineConfiguration();
        return this.getSelectedConfig(impl, create);
    }

    @Override
    public DockerHandler getHandler(@Nullable Environment environment, boolean create) {
        DockerPipelineConfiguration impl = environment == null ? this.createNew() : this.environmentCustomConfigService.getDockerPipelineConfiguration(environment.getId());
        return this.getSelectedConfig(impl, create);
    }

    @Override
    public DockerHandler getHandler(Map<String, Object> webFragmentsContextMap, boolean create) {
        DockerPipelineConfiguration impl = DefaultDockerHandlerImpl.createDockerPipelineConfiguration(webFragmentsContextMap, DockerConfigurationHelper.DATA_VOLUME_FROM_CONFIG_EXTRACTOR.apply(webFragmentsContextMap));
        return this.getSelectedConfig(impl, create);
    }

    private DockerHandler getSelectedConfig(@NotNull DockerPipelineConfiguration dockerPipelineConfiguration, boolean create) {
        if (!dockerPipelineConfiguration.isEnabled()) {
            dockerPipelineConfiguration.setDataVolumes(DockerConfigurationHelper.DEFAULT_VOLUMES);
        }
        DefaultDockerHandlerImpl impl = new DefaultDockerHandlerImpl(dockerPipelineConfiguration, this.dockerPipelineValidationService, this.environmentCustomConfigService, this.moduleDescriptor, this.templateRenderer, this.taskManager, create);
        return impl;
    }

    private DockerPipelineConfiguration createNew() {
        DockerPipelineConfigurationImpl dc = new DockerPipelineConfigurationImpl();
        dc.setEnabled(false);
        dc.setDataVolumes(DockerConfigurationHelper.DEFAULT_VOLUMES);
        return dc;
    }

    @Override
    public String getIsolationTypeLabel(TextProvider textProvider) {
        return textProvider.getText("build.isolation.release.radio.docker");
    }
}

