/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.docker;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.BuildDefinitionManager;
import com.atlassian.bamboo.build.Job;
import com.atlassian.bamboo.build.docker.BuildEnvironmentType;
import com.atlassian.bamboo.build.docker.DockerHandler;
import com.atlassian.bamboo.build.docker.DockerHandlerProvider;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.ImmutableMap;
import com.opensymphony.xwork2.TextProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jetbrains.annotations.Nullable;

@ExperimentalApi
public class DockerConfigurationProviders {
    @Inject
    private BuildDefinitionManager buildDefinitionManager;
    @Inject
    private PluginAccessor pluginAccessor;

    public boolean isAllowedIsolationTypeValue(String isolationType) {
        List providers = this.pluginAccessor.getEnabledModulesByClass(DockerHandlerProvider.class);
        return providers.stream().map(DockerHandlerProvider::getIsolationType).anyMatch(t -> Objects.equals(t, isolationType)) || Objects.equals(BuildEnvironmentType.AGENT.name(), isolationType);
    }

    public BuildConfiguration appendToConfiguration(BuildConfiguration buildConfiguration, String selectedType, Map<String, Object> webFragmentsContextMap) {
        List<Config> configs = this.getConfigs((BuildDefinition)null, true);
        configs.forEach(t -> {
            boolean enabled = t.getIsolationType().equals(selectedType);
            ((Config)t).appendToConfiguration(buildConfiguration, webFragmentsContextMap, enabled);
        });
        return buildConfiguration;
    }

    public ErrorCollection validateAndSaveSelectedConfig(Job job, boolean create, String selectedType, Map<String, Object> webFragmentsContextMap) {
        List<Config> configs = this.getConfigs(job.getBuildDefinition(), create);
        Optional<Config> selectedConfig = configs.stream().filter(t -> t.getIsolationType().equals(selectedType)).findFirst();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        selectedConfig.ifPresent(arg_0 -> DockerConfigurationProviders.lambda$validateAndSaveSelectedConfig$3((ErrorCollection)errors, webFragmentsContextMap, arg_0));
        if (!errors.hasAnyErrors()) {
            BuildDefinition buildDefinition = job.getBuildDefinition();
            configs.forEach(t -> {
                boolean enabled = t.getIsolationType().equals(selectedType);
                if (enabled) {
                    ((Config)t).storeAndEnableConfiguration(buildDefinition, job, webFragmentsContextMap);
                } else {
                    ((Config)t).disableConfiguration(buildDefinition, job);
                }
            });
            this.buildDefinitionManager.savePlanAndDefinition((Plan)job, buildDefinition);
        }
        return errors;
    }

    public ErrorCollection validateAndSaveSelectedConfig(Environment environment, boolean create, String selectedType, Map<String, Object> webFragmentsContextMap) {
        List<Config> configs = this.getConfigs(environment, create);
        Optional<Config> selectedConfig = configs.stream().filter(t -> t.getIsolationType().equals(selectedType)).findFirst();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        selectedConfig.ifPresent(arg_0 -> DockerConfigurationProviders.lambda$validateAndSaveSelectedConfig$6((ErrorCollection)errors, webFragmentsContextMap, arg_0));
        if (!errors.hasAnyErrors()) {
            configs.forEach(t -> {
                boolean enabled = t.getIsolationType().equals(selectedType);
                if (enabled) {
                    ((Config)t).storeAndEnableConfiguration(environment, webFragmentsContextMap);
                } else {
                    ((Config)t).disableConfiguration(environment);
                }
            });
        }
        return errors;
    }

    public Map<String, String> getIsolationTypeLabels(TextProvider textProvider) {
        List providers = this.pluginAccessor.getEnabledModulesByClass(DockerHandlerProvider.class);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)BuildEnvironmentType.AGENT.name(), (Object)textProvider.getText("build.isolation.release.radio.agent"));
        providers.forEach(t -> builder.put((Object)t.getIsolationType(), (Object)t.getIsolationTypeLabel(textProvider)));
        return builder.build();
    }

    public List<Config> getConfigs(@Nullable BuildDefinition buildDefinition, boolean create) {
        List providers = this.pluginAccessor.getEnabledModulesByClass(DockerHandlerProvider.class);
        return providers.stream().map(t -> t.getHandler(buildDefinition, create)).map(Config::new).collect(Collectors.toList());
    }

    public List<Config> getConfigs(@Nullable Environment environment, boolean create) {
        List providers = this.pluginAccessor.getEnabledModulesByClass(DockerHandlerProvider.class);
        return providers.stream().map(t -> t.getHandler(environment, create)).map(Config::new).collect(Collectors.toList());
    }

    public List<Config> getConfigs(Map<String, Object> webFragmentsContextMap, boolean create) {
        List providers = this.pluginAccessor.getEnabledModulesByClass(DockerHandlerProvider.class);
        return providers.stream().map(t -> t.getHandler(webFragmentsContextMap, create)).map(Config::new).collect(Collectors.toList());
    }

    private static /* synthetic */ void lambda$validateAndSaveSelectedConfig$6(ErrorCollection errors, Map webFragmentsContextMap, Config config) {
        errors.addErrorCollection(config.validateConfig(webFragmentsContextMap));
    }

    private static /* synthetic */ void lambda$validateAndSaveSelectedConfig$3(ErrorCollection errors, Map webFragmentsContextMap, Config config) {
        errors.addErrorCollection(config.validateConfig(webFragmentsContextMap));
    }

    public static class Config {
        private final DockerHandler handler;

        public Config(DockerHandler handler) {
            this.handler = handler;
        }

        public String getIsolationType() {
            return this.handler.getIsolationType();
        }

        public String getViewHtml() {
            return BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<String>(null){

                @Override
                public String call() {
                    return handler.getViewHtml();
                }
            });
        }

        public String getEditHtml() {
            return BambooPluginUtils.callUnsafeCode(new BambooPluginUtils.NoThrowCallable<String>(null){

                @Override
                public String call() {
                    return handler.getEditHtml();
                }
            });
        }

        public boolean isSelected() {
            return this.handler.isEnabled();
        }

        private void storeAndEnableConfiguration(BuildDefinition buildDefinition, Job job, Map<String, Object> webFragmentsContextMap) {
            this.handler.enableAndUpdate(buildDefinition, job, webFragmentsContextMap);
        }

        private void storeAndEnableConfiguration(Environment environment, Map<String, Object> webFragmentsContextMap) {
            this.handler.enableAndUpdate(environment, webFragmentsContextMap);
        }

        private void disableConfiguration(BuildDefinition buildDefinition, Job job) {
            this.handler.disable(buildDefinition, job);
        }

        private void disableConfiguration(Environment environment) {
            this.handler.disable(environment);
        }

        private ErrorCollection validateConfig(Map<String, Object> webFragmentsContextMap) {
            return this.handler.validateConfig(webFragmentsContextMap);
        }

        private void appendToConfiguration(BuildConfiguration buildConfiguration, Map<String, Object> webFragmentsContextMap, boolean enabled) {
            this.handler.appendConfiguration(buildConfiguration, webFragmentsContextMap, enabled);
        }
    }
}

