/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.docker;

import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.collections.message.FinalArrayList;
import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.util.BambooConstantUtils;
import com.atlassian.bamboo.utils.ConfigUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerPipelineConfigurationImpl
implements DockerPipelineConfiguration {
    public static final String CONFIG_FIELD_PREFIX = (String)BambooConstantUtils.preventInlining((Object)"docker.pipeline");
    private static final String DATA_VOLUME_HOST_DIR = "hostDir";
    private static final String DATA_VOLUME_CONTAINER_DIR = "containerDir";
    private boolean isValid;
    private boolean enabled;
    private String image;
    private FinalArrayList<DataVolume> dataVolumes = new FinalArrayList();

    public DockerPipelineConfigurationImpl() {
    }

    public DockerPipelineConfigurationImpl(@NotNull DockerPipelineConfiguration dockerPipelineConfiguration) {
        this.isValid = dockerPipelineConfiguration.isValid();
        this.enabled = dockerPipelineConfiguration.isEnabled();
        this.image = dockerPipelineConfiguration.getImage();
        this.dataVolumes = new FinalArrayList((Collection)dockerPipelineConfiguration.getDataVolumes());
    }

    @NotNull
    private static String configField(@NotNull String fieldName) {
        return String.format("%s.%s", CONFIG_FIELD_PREFIX, fieldName);
    }

    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.isValid = config.containsKey(ConfigFields.ENABLED);
        this.enabled = config.getBoolean(ConfigFields.ENABLED, false);
        this.image = config.getString(ConfigFields.IMAGE, null);
        this.dataVolumes = new FinalArrayList();
        List volumes = config.configurationsAt(ConfigFields.VOLUMES);
        for (SubnodeConfiguration subnode : volumes) {
            String hostDir = subnode.getString(DATA_VOLUME_HOST_DIR);
            String containerDir = subnode.getString(DATA_VOLUME_CONTAINER_DIR);
            this.dataVolumes.add((Object)new DataVolume(hostDir, containerDir));
        }
    }

    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = new HierarchicalConfiguration();
        configuration.setProperty(ConfigFields.ENABLED, (Object)this.enabled);
        configuration.setProperty(ConfigFields.IMAGE, (Object)this.image);
        for (DataVolume dataVolume : this.dataVolumes) {
            configuration.addProperty(ConfigFields.VOLUMES + ConfigUtils.FIRST_ELEMENT_IN_LIST + ConfigUtils.SEPARATOR + DATA_VOLUME_CONTAINER_DIR, (Object)dataVolume.getContainerDirectory());
            configuration.addProperty(ConfigFields.VOLUMES + ConfigUtils.SEPARATOR + DATA_VOLUME_HOST_DIR, (Object)dataVolume.getHostDirectory());
        }
        return configuration;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerPipelineConfigurationImpl that = (DockerPipelineConfigurationImpl)o;
        return this.enabled == that.enabled && Objects.equals(this.image, that.image) && Objects.equals(this.dataVolumes, that.dataVolumes);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("enabled", this.enabled).append("image", (Object)this.image).append("dataVolumes", this.dataVolumes).toString();
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.image, this.dataVolumes);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Nullable
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    @NotNull
    public List<DataVolume> getDataVolumes() {
        return this.dataVolumes;
    }

    public void setDataVolumes(@NotNull Iterable<DataVolume> dataVolumes) {
        this.dataVolumes = new FinalArrayList(dataVolumes);
    }

    static /* synthetic */ String access$000(String x0) {
        return DockerPipelineConfigurationImpl.configField(x0);
    }

    public static interface ConfigFields {
        public static final String ENABLED = DockerPipelineConfigurationImpl.access$000("enabled");
        public static final String IMAGE = DockerPipelineConfigurationImpl.access$000("image");
        public static final String VOLUMES = DockerPipelineConfigurationImpl.access$000("volumes");
    }
}

