/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.docker;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.build.docker.DockerPipelineConfiguration;
import com.atlassian.bamboo.build.docker.DockerPipelineValidationService;
import com.atlassian.bamboo.docker.DataVolume;
import com.atlassian.bamboo.docker.DockerConfigurationHelper;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.opensymphony.xwork2.TextProvider;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DockerPipelineValidationServiceImpl
implements DockerPipelineValidationService {
    public static final String CFG_DOCKER_IMAGE = "dockerImage";
    public static final String CFG_HOST_DIR_PREFIX = DockerConfigurationHelper.HOST_DIRECTORY_PREFIX;
    public static final String CFG_CONTAINER_DIR_PREFIX = DockerConfigurationHelper.CONTAINER_DIRECTORY_PREFIX;
    public static final String IMAGE_MISSING_ERROR_KEY = "build.isolation.docker.image.missing";
    private final TextProvider textProvider;
    private final FeatureManager featureManager;

    @Inject
    public DockerPipelineValidationServiceImpl(TextProvider textProvider, FeatureManager featureManager) {
        this.textProvider = textProvider;
        this.featureManager = featureManager;
    }

    @NotNull
    public ErrorCollection validateDockerPipelineConfiguration(@NotNull DockerPipelineConfiguration dockerPipelineConfiguration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!this.featureManager.isDockerPipelinesEnabled() && dockerPipelineConfiguration.isEnabled()) {
            errorCollection.addErrorMessage("Docker functionality is disabled on this Bamboo server");
        }
        if (!this.isDockerImageValid(dockerPipelineConfiguration)) {
            errorCollection.addError(CFG_DOCKER_IMAGE, this.textProvider.getText(IMAGE_MISSING_ERROR_KEY));
        }
        List dataVolumes = dockerPipelineConfiguration.getDataVolumes();
        for (int i = 0; i < dataVolumes.size(); ++i) {
            DataVolume dataVolume = (DataVolume)dataVolumes.get(i);
            int fieldIndex = i + 1;
            boolean duplicateHostDir = false;
            boolean duplicateContainerDir = false;
            List previousVolumes = dataVolumes.subList(0, i);
            for (DataVolume previousVolume : previousVolumes) {
                duplicateHostDir = duplicateHostDir || Objects.equals(previousVolume.getHostDirectory(), dataVolume.getHostDirectory());
                duplicateContainerDir = duplicateContainerDir || Objects.equals(previousVolume.getContainerDirectory(), dataVolume.getContainerDirectory());
            }
            if (StringUtils.isBlank((CharSequence)dataVolume.getHostDirectory())) {
                errorCollection.addError(CFG_HOST_DIR_PREFIX + fieldIndex, this.textProvider.getText("build.isolation.docker.volumes.hostdir.empty"));
            } else if (duplicateHostDir) {
                errorCollection.addError(CFG_HOST_DIR_PREFIX + fieldIndex, this.textProvider.getText("build.isolation.docker.volumes.hostdir.used", Collections.singletonList(dataVolume.getHostDirectory())));
            }
            if (StringUtils.isBlank((CharSequence)dataVolume.getContainerDirectory())) {
                errorCollection.addError(CFG_CONTAINER_DIR_PREFIX + fieldIndex, this.textProvider.getText("build.isolation.docker.volumes.containerdir.empty"));
                continue;
            }
            if (!duplicateContainerDir) continue;
            errorCollection.addError(CFG_CONTAINER_DIR_PREFIX + fieldIndex, this.textProvider.getText("build.isolation.docker.volumes.containerdir.used", Collections.singletonList(dataVolume.getContainerDirectory())));
        }
        return errorCollection;
    }

    private boolean isDockerImageValid(@NotNull DockerPipelineConfiguration dockerPipelineConfiguration) {
        return !dockerPipelineConfiguration.isEnabled() || !StringUtils.isBlank((CharSequence)dockerPipelineConfiguration.getImage());
    }
}

