/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.bandana.PlanAwareBandanaContext;
import com.atlassian.bamboo.build.expiry.BuildExpiryBean;
import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.chains.Chain;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.expiry.ExpiryStatus;
import com.atlassian.bamboo.executor.SystemSecurityContextExecutors;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.persistence.TransactionAndHibernateTemplate;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.repository.RepositoryDefinitionManager;
import com.atlassian.bamboo.resultsummary.ExpiryCriteria;
import com.atlassian.bamboo.resultsummary.MutableExpiryCriteria;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;
import org.springframework.util.Assert;

public class BuildExpiryBeanImpl
implements BuildExpiryBean {
    private static final Logger log = Logger.getLogger(BuildExpiryBeanImpl.class);
    private static final String LAST_EXPIRY_DATE_BANDANA_KEY = "expiry.build.lastRun";
    private static final String LAST_EXPIRY_END_DATE_BANDANA_KEY = "expiry.build.lastFinished";
    private static final String LAST_EXPIRY_SUCCESSFUL_BANDANA_KEY = "expiry.build.successful";
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicReference<Future<Long>> expiryResult = new AtomicReference();
    private final ListeningExecutorService expiryExecutorService = SystemSecurityContextExecutors.newSingleThreadExecutor("BuildExpiryBean");
    private final ResultsSummaryManager resultsSummaryManager;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private final PlanManager planManager;
    private final RepositoryDefinitionManager repositoryDefinitionManager;
    private final ErrorUpdateHandler errorUpdateHandler;
    private final BandanaManager bandanaManager;
    private final TransactionAndHibernateTemplate template;

    public BuildExpiryBeanImpl(ResultsSummaryManager resultsSummaryManager, PlanManager planManager, AdministrationConfigurationAccessor administrationConfigurationAccessor, RepositoryDefinitionManager repositoryDefinitionManager, ErrorUpdateHandler errorUpdateHandler, BandanaManager bandanaManager, TransactionAndHibernateTemplate template) {
        this.resultsSummaryManager = resultsSummaryManager;
        this.planManager = planManager;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
        this.repositoryDefinitionManager = repositoryDefinitionManager;
        this.errorUpdateHandler = errorUpdateHandler;
        this.bandanaManager = bandanaManager;
        this.template = template;
    }

    @Override
    @NotNull
    public Future<Long> triggerBuildExpiry() {
        if (!this.running.compareAndSet(false, true)) {
            log.info((Object)"Build expiry is already running");
            return this.expiryResult.get();
        }
        ListenableFuture future = this.expiryExecutorService.submit(this.expiryTask());
        this.expiryResult.set((Future<Long>)future);
        return this.expiryResult.get();
    }

    @NotNull
    private Callable<Long> expiryTask() {
        final AtomicBoolean successful = new AtomicBoolean(false);
        return new Callable<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long call() throws Exception {
                try {
                    long totalBuilds = 0L;
                    BuildExpiryConfig config = BuildExpiryBeanImpl.this.administrationConfigurationAccessor.getAdministrationConfiguration().getBuildExpiryConfig();
                    BuildExpiryBeanImpl.this.saveExpiryStartDate();
                    boolean doGlobalExpiry = config.isEnabled() && (config.isExpireByBuild() || config.isExpireByDate() || config.hasMaximumBuildsToKeep());
                    Stopwatch stopWatch = Stopwatch.createStarted();
                    log.info((Object)"Running cleanup task... checking for build expiry configuration");
                    for (Chain plan : BuildExpiryBeanImpl.this.planManager.getAllPlans(Chain.class)) {
                        ResultsSummary lastBuildResultsSummary = plan.getLatestResultsSummary();
                        if (lastBuildResultsSummary == null) continue;
                        BuildExpiryConfig planExpiryConfig = PlanHelper.getConfigObject((ImmutablePlan)plan, "buildExpiryConfig", BuildExpiryConfig.class);
                        BuildExpiryConfig expiryConfigToUse = null;
                        if (planExpiryConfig != null && planExpiryConfig.isEnabled()) {
                            log.info((Object)("Using plan defined expiry config for " + plan.getKey() + ": " + planExpiryConfig));
                            expiryConfigToUse = planExpiryConfig;
                        } else if (doGlobalExpiry) {
                            log.debug((Object)("Using globally defined expiry config for plan " + plan.getKey() + ": " + config));
                            expiryConfigToUse = config;
                        }
                        if (expiryConfigToUse == null) continue;
                        try {
                            totalBuilds += BuildExpiryBeanImpl.this.expireBuildPlan(expiryConfigToUse, (ImmutablePlan)plan, lastBuildResultsSummary);
                        }
                        catch (RuntimeException e) {
                            log.error((Object)("A problem has occurred during expiry of " + plan.getPlanKey()), (Throwable)e);
                        }
                    }
                    BuildExpiryBeanImpl.this.repositoryDefinitionManager.removeUnusedRepositories();
                    log.info((Object)String.format("Cleanup task completed in %s, removed %d builds", stopWatch, totalBuilds));
                    successful.set(true);
                    Long l = totalBuilds;
                    return l;
                }
                finally {
                    BuildExpiryBeanImpl.this.saveExpiryEndDate(successful.get());
                    BuildExpiryBeanImpl.this.running.set(false);
                }
            }
        };
    }

    private boolean isBuildExpiryRunning() {
        return this.running.get();
    }

    @Nullable
    private Date getLastRunDate() {
        return (Date)Narrow.to((Object)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, LAST_EXPIRY_DATE_BANDANA_KEY), Date.class);
    }

    @Override
    @NotNull
    public ExpiryStatus getStatus() {
        return new ExpiryStatus(this.isBuildExpiryRunning(), this.isLastRunSuccessful(), this.getLastRunDate(), this.getLastFinishedDate());
    }

    private void saveExpiryStartDate() {
        this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, LAST_EXPIRY_DATE_BANDANA_KEY, (Object)new Date());
    }

    private void saveExpiryEndDate(boolean isSuccessful) {
        try {
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, LAST_EXPIRY_END_DATE_BANDANA_KEY, (Object)new Date());
            this.bandanaManager.setValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, LAST_EXPIRY_SUCCESSFUL_BANDANA_KEY, (Object)isSuccessful);
        }
        catch (Exception e) {
            log.error((Object)"Error saving in Bandana", (Throwable)e);
        }
    }

    @VisibleForTesting
    protected long expireBuildPlan(@NotNull BuildExpiryConfig config, @NotNull ImmutablePlan plan, @NotNull ResultsSummary lastResultsSummary) {
        boolean shouldContinue;
        Assert.notNull((Object)config, (String)"BuildExpiryConfig is required");
        Assert.notNull((Object)plan, (String)"Plan is required");
        Assert.notNull((Object)lastResultsSummary, (String)"last build results summary is required");
        if (config.isExpiryTypeNothing()) {
            log.info((Object)("Global Expiry overridden and prevented by plan: " + plan.getKey()));
            return 0L;
        }
        if (!(config.isExpiryTypeNothing() || config.isExpiryTypeBuildLog() || config.isExpiryTypeArtifact() || config.isExpiryTypeResult())) {
            log.warn((Object)("Wrong expiry configuration detected for plan: " + plan.getKey() + ". Please edit expiry configuration in plan and save it to override with a valid one."));
            return 0L;
        }
        if (!(config.isExpireByBuild() || config.isExpireByDate() || config.hasMaximumBuildsToKeep())) {
            String message = "The expiry configuration for " + plan.getPlanKey() + " would expire *all* builds. Please update the configuration, no builds were expired for the plan. " + ToStringBuilder.reflectionToString((Object)config);
            this.errorUpdateHandler.recordError((Key)plan.getPlanKey(), message);
            return 0L;
        }
        log.debug((Object)("Searching for builds to expire for " + plan.getName() + " " + plan.getKey() + ". Latest summary " + lastResultsSummary.getPlanResultKey()));
        MutableExpiryCriteria expiryCriteria = new MutableExpiryCriteria(plan.getPlanKey());
        if (config.isExpireByBuild()) {
            if (config.getBuildsToKeep() >= lastResultsSummary.getBuildNumber()) {
                return 0L;
            }
            int removeBuildsUpTo = lastResultsSummary.getBuildNumber() - config.getBuildsToKeep();
            log.debug((Object)("Removing only build results prior to build #" + removeBuildsUpTo + " due to configure minimum number of builds to keep"));
            expiryCriteria.setMaxBuildNumber(Integer.valueOf(removeBuildsUpTo));
        }
        if (config.isExpireByDate()) {
            Date lastBuildDate = lastResultsSummary.getBuildCompletedDate();
            if (lastBuildDate == null) {
                log.debug((Object)("Last build completed date for '" + plan + ":" + lastResultsSummary + "' is null. Ensuring the last build is not removed."));
                if (expiryCriteria.getMaxBuildNumber() == null) {
                    expiryCriteria.setMaxBuildNumber(Integer.valueOf(lastResultsSummary.getBuildNumber() - 1));
                }
            }
            DateTime todaysDate = new DateTime();
            Date removeBuildsOlderThan = BambooDateUtils.makeReasonableDate((Date)todaysDate.minus((ReadablePeriod)config.getExpiryPeriod()).toDate());
            log.debug((Object)("Removing builds older than " + removeBuildsOlderThan));
            expiryCriteria.setMaxBuildCompletedDate(new DateTime((Object)removeBuildsOlderThan));
        }
        if (config.hasMaximumBuildsToKeep()) {
            int keepBuildsWithBuildNumberEqOrGreater = lastResultsSummary.getBuildNumber() - config.getMaximumBuildsToKeep() + 1;
            log.debug((Object)("Removing all build results prior to build #" + keepBuildsWithBuildNumberEqOrGreater + " due to configured maximum number of builds to keep"));
            expiryCriteria.setMinBuildNumberToKeep(Integer.valueOf(keepBuildsWithBuildNumberEqOrGreater));
        }
        if (!config.isExpiryTypeResult()) {
            if (config.isExpiryTypeArtifact()) {
                log.debug((Object)"Removing builds which have artifact links");
                expiryCriteria.setRequireArtifactLinks(true);
            }
            if (config.isExpiryTypeBuildLog()) {
                log.debug((Object)("Removing builds with log size greater than " + config.getMaxIgnoredLogSize() + 'B'));
                expiryCriteria.setMaxIgnoredLogSize(Long.valueOf(config.getMaxIgnoredLogSize()));
            }
        }
        if (!config.getLabelsList().isEmpty()) {
            log.debug((Object)("Excluding builds with labels: " + config.getLabelsList()));
            expiryCriteria.setLabelsToExclude((Iterable)config.getLabelsList());
        }
        AtomicLong totalExpiredBuilds = new AtomicLong();
        HashSet failedResultSummaries = new HashSet();
        while (shouldContinue = ((Boolean)this.template.execute(session -> {
            LinkedList<ResultsSummary> resultSummaries = new LinkedList<ResultsSummary>(this.resultsSummaryManager.getResultSummariesForExpiry((ExpiryCriteria)expiryCriteria));
            if (resultSummaries.isEmpty()) {
                return false;
            }
            int resultSummariesToExpire = resultSummaries.size();
            int expiredBuilds = this.expireResultSummaries(plan, resultSummaries, config, failedResultSummaries);
            session.flush();
            session.clear();
            totalExpiredBuilds.addAndGet(expiredBuilds);
            if ((double)expiredBuilds < 0.2 * (double)resultSummariesToExpire) {
                log.warn((Object)"Less than 20% of builds were successfully expired, quitting the loop");
                return false;
            }
            return resultSummariesToExpire == expiryCriteria.getMaxResults();
        })).booleanValue()) {
        }
        if (totalExpiredBuilds.get() > 0L) {
            log.info((Object)("Affected " + totalExpiredBuilds + " results in plan " + plan.getKey()));
        }
        return totalExpiredBuilds.get();
    }

    private int expireResultSummaries(ImmutablePlan plan, Queue<ResultsSummary> resultSummaries, BuildExpiryConfig config, Set<PlanResultKey> failedResultSummaries) {
        ResultsSummary summary;
        int expiredBuilds = 0;
        log.info((Object)("Found " + resultSummaries.size() + " build(s) to expire for " + plan.getPlanKey()));
        while ((summary = resultSummaries.poll()) != null) {
            if (failedResultSummaries.contains(summary.getPlanResultKey())) continue;
            try {
                log.debug((Object)("Checking expiry for " + summary.getPlanResultKey()));
                if (config.isExpiryTypeResult()) {
                    log.debug((Object)("Removing build result of " + summary.getPlanResultKey()));
                    this.resultsSummaryManager.removeResultSummary(plan, summary);
                } else {
                    if (config.isExpiryTypeArtifact()) {
                        log.debug((Object)("Removing artifacts of " + summary.getPlanResultKey()));
                        this.resultsSummaryManager.removeArtifacts(summary);
                    }
                    if (config.isExpiryTypeBuildLog()) {
                        log.debug((Object)("Removing build logs of " + summary.getPlanResultKey()));
                        this.resultsSummaryManager.removeBuildLogs(summary, config.getMaxIgnoredLogSize());
                    }
                }
                ++expiredBuilds;
            }
            catch (Exception e) {
                log.warn((Object)("Unable to expire " + summary.getPlanResultKey()), (Throwable)e);
                failedResultSummaries.add(summary.getPlanResultKey());
            }
        }
        return expiredBuilds;
    }

    @Nullable
    private Date getLastFinishedDate() {
        return this.isBuildExpiryRunning() ? null : (Date)Narrow.to((Object)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, LAST_EXPIRY_END_DATE_BANDANA_KEY), Date.class);
    }

    @Nullable
    private Boolean isLastRunSuccessful() {
        return this.isBuildExpiryRunning() ? null : (Boolean)Narrow.to((Object)this.bandanaManager.getValue((BandanaContext)PlanAwareBandanaContext.GLOBAL_CONTEXT, LAST_EXPIRY_SUCCESSFUL_BANDANA_KEY), Boolean.class);
    }
}

