/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.expiry.BuildExpiryType;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfig;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfigBuilder;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryType;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormat;

public class CombinedExpiryConfig {
    private static final Map<BuildExpiryType, String> EXPIRY_TYPE_LABELS = ImmutableMap.of((Object)BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.artifact", (Object)BuildExpiryType.BUILD_LOG_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.buildlog", (Object)BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.result", (Object)BuildExpiryType.NOTHING_BUILD_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.nothing");
    private static final Map<BuildExpiryType, String> EXPIRY_TYPE_LABELS_WITH_DEPLOYMENTS = ImmutableMap.of((Object)BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.artifact.withDeployments", (Object)BuildExpiryType.BUILD_LOG_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.buildlog.withDeployments", (Object)BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.result.withDeployments", (Object)BuildExpiryType.NOTHING_BUILD_EXPIRY_TYPE, (Object)"buildExpiry.enable.type.nothing");
    private String cronExpression;
    private boolean expiryTypeNothing;
    private boolean expiryTypeResult;
    private boolean expiryTypeArtifact;
    private boolean expiryTypeBuildLog;
    private String period;
    private int duration;
    private int buildsToKeep;
    private int maximumBuildsToKeep;
    private int deploymentsToKeep;
    private String labelsToKeep;
    private long maxIgnoredLogSize = -1L;

    public CombinedExpiryConfig() {
    }

    public CombinedExpiryConfig(@Nullable BuildExpiryConfig buildExpiryConfig) {
        if (buildExpiryConfig != null) {
            this.cronExpression = buildExpiryConfig.getCronExpression();
            this.expiryTypeNothing = buildExpiryConfig.isExpiryTypeNothing();
            this.expiryTypeResult = buildExpiryConfig.isExpiryTypeResult();
            this.expiryTypeArtifact = buildExpiryConfig.isExpiryTypeArtifact();
            this.expiryTypeBuildLog = buildExpiryConfig.isExpiryTypeBuildLog();
            this.period = buildExpiryConfig.getPeriod();
            this.duration = buildExpiryConfig.getDuration();
            this.buildsToKeep = buildExpiryConfig.getBuildsToKeep();
            this.labelsToKeep = buildExpiryConfig.getLabelsToKeep();
            this.maxIgnoredLogSize = buildExpiryConfig.getMaxIgnoredLogSize();
            this.maximumBuildsToKeep = buildExpiryConfig.getMaximumBuildsToKeep();
        }
    }

    public CombinedExpiryConfig(@Nullable DeploymentExpiryConfig deploymentExpiryConfig) {
        if (deploymentExpiryConfig != null) {
            this.expiryTypeResult = deploymentExpiryConfig.shouldExpireDeploymentResults();
            this.expiryTypeArtifact = deploymentExpiryConfig.shouldExpireDeploymentVersionArtifacts();
            this.expiryTypeBuildLog = deploymentExpiryConfig.shouldExpireDeploymentResultLogs();
            this.expiryTypeNothing = !this.expiryTypeResult && !this.expiryTypeArtifact && !this.expiryTypeBuildLog;
            this.setExpiryPeriod(deploymentExpiryConfig.getExpiryPeriod());
            this.deploymentsToKeep = deploymentExpiryConfig.getDeploymentsToKeep();
            this.maxIgnoredLogSize = deploymentExpiryConfig.getMaxIgnoredLogSize();
        }
    }

    public CombinedExpiryConfig(@Nullable BuildExpiryConfig buildExpiryConfig, @Nullable DeploymentExpiryConfig deploymentExpiryConfig) {
        this(buildExpiryConfig);
        if (deploymentExpiryConfig != null) {
            this.deploymentsToKeep = deploymentExpiryConfig.getDeploymentsToKeep();
        }
    }

    @NotNull
    public List<String> getSelectedExpiryTypesLabelKeys(boolean deploymentExpiryEnabled) {
        if (this.expiryTypeResult) {
            return Collections.singletonList(CombinedExpiryConfig.getExpiryTypeLabelKey(BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE, deploymentExpiryEnabled));
        }
        if (this.expiryTypeNothing) {
            return Collections.singletonList(CombinedExpiryConfig.getExpiryTypeLabelKey(BuildExpiryType.NOTHING_BUILD_EXPIRY_TYPE, deploymentExpiryEnabled));
        }
        ArrayList<String> labelKeys = new ArrayList<String>();
        if (this.expiryTypeBuildLog) {
            labelKeys.add(CombinedExpiryConfig.getExpiryTypeLabelKey(BuildExpiryType.BUILD_LOG_EXPIRY_TYPE, deploymentExpiryEnabled));
        }
        if (this.expiryTypeArtifact) {
            labelKeys.add(CombinedExpiryConfig.getExpiryTypeLabelKey(BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE, deploymentExpiryEnabled));
        }
        return labelKeys;
    }

    private void setExpiryPeriod(@Nullable Period period) {
        if (period == null || Period.ZERO.equals((Object)period)) {
            this.duration = 0;
            this.period = "days";
        } else if (period.getDays() != 0) {
            this.duration = period.getDays();
            this.period = "days";
        } else if (period.getWeeks() != 0) {
            this.duration = period.getWeeks();
            this.period = "weeks";
        } else if (period.getMonths() != 0) {
            this.duration = period.getMonths();
            this.period = "months";
        } else {
            throw new IllegalStateException("Invalid expiry period: " + PeriodFormat.getDefault().print((ReadablePeriod)period));
        }
    }

    @NotNull
    public BuildExpiryConfig toBuildExpiryConfig() {
        BuildExpiryConfig buildExpiryConfig = new BuildExpiryConfig();
        buildExpiryConfig.setEnabled(this.isEnabled());
        buildExpiryConfig.setBuildsToKeep(this.buildsToKeep);
        buildExpiryConfig.setCronExpression(this.cronExpression);
        buildExpiryConfig.setDuration(this.duration);
        buildExpiryConfig.setPeriod(this.period);
        buildExpiryConfig.setLabelsToKeep(this.labelsToKeep);
        buildExpiryConfig.setExpiryTypeNothing(this.expiryTypeNothing);
        buildExpiryConfig.setExpiryTypeArtifact(this.expiryTypeArtifact);
        buildExpiryConfig.setExpiryTypeBuildLog(this.expiryTypeBuildLog);
        buildExpiryConfig.setExpiryTypeResult(this.expiryTypeResult);
        buildExpiryConfig.setMaxIgnoredLogSize(this.maxIgnoredLogSize);
        buildExpiryConfig.setMaximumBuildsToKeep(this.maximumBuildsToKeep);
        return buildExpiryConfig;
    }

    @NotNull
    public DeploymentExpiryConfig toDeploymentExpiryConfig() {
        DeploymentExpiryConfigBuilder deploymentConfigBuilder = new DeploymentExpiryConfigBuilder();
        if (this.isEnabled()) {
            deploymentConfigBuilder.withExpiryEnabled();
        }
        if (this.duration == 0) {
            deploymentConfigBuilder.withExpiryPeriod(Period.ZERO);
        } else {
            deploymentConfigBuilder.withExpiryPeriod(PeriodFormat.getDefault().parsePeriod(this.duration + " " + this.period));
        }
        if (this.expiryTypeResult) {
            deploymentConfigBuilder.withExpiryType(DeploymentExpiryType.DEPLOYMENT_RESULT_EXPIRY);
            deploymentConfigBuilder.withExpiryType(DeploymentExpiryType.DEPLOYMENT_RESULT_LOG_EXPIRY);
            deploymentConfigBuilder.withExpiryType(DeploymentExpiryType.DEPLOYMENT_VERSION_ARTIFACTS_EXPIRY);
        } else {
            if (this.expiryTypeBuildLog) {
                deploymentConfigBuilder.withExpiryType(DeploymentExpiryType.DEPLOYMENT_RESULT_LOG_EXPIRY);
            }
            if (this.expiryTypeArtifact) {
                deploymentConfigBuilder.withExpiryType(DeploymentExpiryType.DEPLOYMENT_VERSION_ARTIFACTS_EXPIRY);
            }
        }
        deploymentConfigBuilder.withDeploymentsToKeep(this.deploymentsToKeep);
        deploymentConfigBuilder.withMaxIgnoredLogSize(this.maxIgnoredLogSize);
        return deploymentConfigBuilder.build();
    }

    @NotNull
    public static String getExpiryTypeLabelKey(@NotNull BuildExpiryType buildExpiryType, boolean withDeployments) {
        if (!BuildExpiryType.TYPES.contains(buildExpiryType)) {
            throw new IllegalArgumentException("Unknown expiry type: " + buildExpiryType);
        }
        if (withDeployments) {
            return EXPIRY_TYPE_LABELS_WITH_DEPLOYMENTS.get(buildExpiryType);
        }
        return EXPIRY_TYPE_LABELS.get(buildExpiryType);
    }

    public boolean isEnabled() {
        return this.expiryTypeArtifact || this.expiryTypeBuildLog || this.expiryTypeResult;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public boolean isExpiryTypeNothing() {
        return this.expiryTypeNothing;
    }

    public void setExpiryTypeNothing(boolean expiryTypeNothing) {
        this.expiryTypeNothing = expiryTypeNothing;
    }

    public boolean isExpiryTypeResult() {
        return this.expiryTypeResult;
    }

    public void setExpiryTypeResult(boolean expiryTypeResult) {
        this.expiryTypeResult = expiryTypeResult;
    }

    public boolean isExpiryTypeArtifact() {
        return this.expiryTypeArtifact;
    }

    public void setExpiryTypeArtifact(boolean expiryTypeArtifact) {
        this.expiryTypeArtifact = expiryTypeArtifact;
    }

    public boolean isExpiryTypeBuildLog() {
        return this.expiryTypeBuildLog;
    }

    public void setExpiryTypeBuildLog(boolean expiryTypeBuildLog) {
        this.expiryTypeBuildLog = expiryTypeBuildLog;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public int getBuildsToKeep() {
        return this.buildsToKeep;
    }

    public void setBuildsToKeep(int buildsToKeep) {
        this.buildsToKeep = buildsToKeep;
    }

    public int getDeploymentsToKeep() {
        return this.deploymentsToKeep;
    }

    public void setDeploymentsToKeep(int deploymentsToKeep) {
        this.deploymentsToKeep = deploymentsToKeep;
    }

    public String getLabelsToKeep() {
        return this.labelsToKeep;
    }

    public void setLabelsToKeep(String labelsToKeep) {
        this.labelsToKeep = labelsToKeep;
    }

    public long getMaxIgnoredLogSize() {
        return this.maxIgnoredLogSize;
    }

    public void setMaxIgnoredLogSize(long maxIgnoredLogSize) {
        this.maxIgnoredLogSize = maxIgnoredLogSize;
    }

    public int getMaximumBuildsToKeep() {
        return this.maximumBuildsToKeep;
    }

    public void setMaximumBuildsToKeep(int maximumBuildsToKeep) {
        this.maximumBuildsToKeep = maximumBuildsToKeep;
    }
}

