/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry;

import com.atlassian.bamboo.build.expiry.BuildExpiryBean;
import com.atlassian.bamboo.build.expiry.ExpiryScheduler;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryService;
import com.atlassian.fugue.Option;
import java.text.ParseException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class ExpirySchedulerImpl
implements ExpiryScheduler {
    private static final Logger log = Logger.getLogger(ExpirySchedulerImpl.class);
    private static final String EXPIRY_GROUP = "ExpiryGroup";
    private static final String EXPIRY_JOB_TRIGGER = "ExpiryJobTrigger";
    private static final String EXPIRY_JOB = "ExpiryJob";
    private final JobKey JOB_KEY = new JobKey("ExpiryJob", "ExpiryGroup");
    private final TriggerKey TRIGGER_KEY = new TriggerKey("ExpiryJobTrigger", "ExpiryGroup");
    private final Scheduler quartzScheduler;
    private final AdministrationConfigurationAccessor administrationConfigurationAccessor;

    public ExpirySchedulerImpl(Scheduler quartzScheduler, AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.quartzScheduler = quartzScheduler;
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void initialiseSchedule() {
        this.initialiseSchedule(this.administrationConfigurationAccessor.getAdministrationConfiguration().getBuildExpiryConfig().getCronExpression());
    }

    public void initialiseSchedule(@NotNull String cronExpressionStr) {
        try {
            this.unschedule();
            JobDetail jobDetail = JobBuilder.newJob(ExpiryJob.class).withIdentity(this.JOB_KEY).build();
            CronExpression cronExpression = new CronExpression(cronExpressionStr);
            CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(this.TRIGGER_KEY).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).forJob(this.JOB_KEY).build();
            this.quartzScheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule ExpiryJob", (Throwable)e);
        }
        catch (ParseException e) {
            log.error((Object)"Unable to schedule ExpiryJob", (Throwable)e);
        }
    }

    @Nullable
    public Trigger getTrigger() {
        try {
            return this.quartzScheduler.getTrigger(this.TRIGGER_KEY);
        }
        catch (SchedulerException e) {
            log.warn((Object)"Unable to get quartz trigger", (Throwable)e);
            return null;
        }
    }

    private void unschedule() {
        try {
            this.quartzScheduler.unscheduleJob(this.TRIGGER_KEY);
        }
        catch (SchedulerException e) {
            log.warn((Object)"Unable to unschedule ExpiryJob - expiry may still occur", (Throwable)e);
        }
    }

    public static class ExpiryJob
    implements Job {
        private static AtomicBoolean expiryJobRuns = new AtomicBoolean(false);
        private BuildExpiryBean buildExpiryBean;
        private DeploymentExpiryService deploymentExpiryService;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
            if (!expiryJobRuns.compareAndSet(false, true)) {
                log.info((Object)"Not running expiry as a previous expiry job still runs");
                return;
            }
            try {
                Exception firstCaughtException = null;
                try {
                    Option deploymentExpiryResult = this.deploymentExpiryService.triggerDeploymentsExpiration();
                    if (deploymentExpiryResult.isDefined()) {
                        ((Future)deploymentExpiryResult.get()).get();
                    }
                }
                catch (Exception e) {
                    firstCaughtException = e;
                }
                try {
                    this.buildExpiryBean.triggerBuildExpiry().get();
                }
                catch (Exception e) {
                    if (firstCaughtException == null) {
                        firstCaughtException = e;
                    }
                    log.error((Object)"Build expiry didn't complete", (Throwable)e);
                }
                if (firstCaughtException != null) {
                    throw new JobExecutionException((Throwable)firstCaughtException);
                }
            }
            finally {
                expiryJobRuns.set(false);
            }
        }

        public void setBuildExpiryBean(BuildExpiryBean buildExpiryBean) {
            this.buildExpiryBean = buildExpiryBean;
        }

        public void setDeploymentExpiryService(DeploymentExpiryService deploymentExpiryService) {
            this.deploymentExpiryService = deploymentExpiryService;
        }
    }
}

