/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry.plugin;

import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.expiry.CombinedExpiryConfig;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.plan.cache.ImmutableTopLevelPlan;
import com.atlassian.bamboo.plan.configuration.MiscellaneousPlanConfigurationPlugin;
import com.atlassian.bamboo.utils.BambooFunctions;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.opensymphony.xwork2.TextProvider;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildExpiryPerPlanPlugin
extends BaseConfigurablePlugin
implements MiscellaneousPlanConfigurationPlugin {
    private static final Logger log = Logger.getLogger(BuildExpiryPerPlanPlugin.class);
    public static final String BUILD_EXPIRY_CONFIG_CONSTANT = "buildExpiryConfig";
    static final String BUILD_EXPIRY_CONFIG = "custom.buildExpiryConfig";
    static final String PREFIX = "custom.buildExpiryConfig.";
    public static final String FIELD_ENABLED = "custom.buildExpiryConfig.enabled";
    static final String FIELD_DURATION = "custom.buildExpiryConfig.duration";
    static final String FIELD_PERIOD = "custom.buildExpiryConfig.period";
    static final String FIELD_BUILDS_TO_KEEP = "custom.buildExpiryConfig.buildsToKeep";
    static final String FIELD_MAX_BUILDS_TO_KEEP = "custom.buildExpiryConfig.maximumBuildsToKeep";
    static final String FIELD_MAX_IGNORED_LOG_SIZE = "custom.buildExpiryConfig.maxIgnoredLogSize";
    static final String FIELD_EXPIRY_TYPE_NOTHING = "custom.buildExpiryConfig.expiryTypeNothing";
    static final String FIELD_EXPIRY_TYPE_RESULT = "custom.buildExpiryConfig.expiryTypeResult";
    static final String FIELD_EXPIRY_TYPE_ARTIFACT = "custom.buildExpiryConfig.expiryTypeArtifact";
    static final String FIELD_EXPIRY_TYPE_BUILD_LOG = "custom.buildExpiryConfig.expiryTypeBuildLog";
    static final String FIELD_LABELS_TO_KEEP = "custom.buildExpiryConfig.labelsToKeep";
    private static final Set<String> ALL_CONFIGURATION_FIELDS = ImmutableSet.of((Object)"custom.buildExpiryConfig.enabled", (Object)"custom.buildExpiryConfig.duration", (Object)"custom.buildExpiryConfig.period", (Object)"custom.buildExpiryConfig.buildsToKeep", (Object)"custom.buildExpiryConfig.maximumBuildsToKeep", (Object)"custom.buildExpiryConfig.labelsToKeep", (Object[])new String[]{"custom.buildExpiryConfig.maxIgnoredLogSize", "custom.buildExpiryConfig.expiryTypeNothing", "custom.buildExpiryConfig.expiryTypeResult", "custom.buildExpiryConfig.expiryTypeArtifact", "custom.buildExpiryConfig.expiryTypeBuildLog"});
    private TextProvider textProvider;

    public boolean isApplicableTo(@NotNull ImmutablePlan plan) {
        return plan instanceof ImmutableTopLevelPlan;
    }

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!Boolean.parseBoolean(buildConfiguration.getString(FIELD_ENABLED))) {
            buildConfiguration.clearTree(BUILD_EXPIRY_CONFIG);
            buildConfiguration.setProperty(FIELD_ENABLED, (Object)Boolean.FALSE.toString());
            return errorCollection;
        }
        String expiryTypeNothing = buildConfiguration.getString(FIELD_EXPIRY_TYPE_NOTHING);
        String expiryTypeResult = buildConfiguration.getString(FIELD_EXPIRY_TYPE_RESULT);
        String expiryTypeArtifact = buildConfiguration.getString(FIELD_EXPIRY_TYPE_ARTIFACT);
        String expiryTypeBuildLog = buildConfiguration.getString(FIELD_EXPIRY_TYPE_BUILD_LOG);
        String durationString = buildConfiguration.getString(FIELD_DURATION);
        String period = buildConfiguration.getString(FIELD_PERIOD);
        String buildsToKeepString = buildConfiguration.getString(FIELD_BUILDS_TO_KEEP);
        String maximumBuildsToKeepString = buildConfiguration.getString(FIELD_MAX_BUILDS_TO_KEEP);
        int duration = 0;
        int buildsToKeep = 0;
        int maxBuildsToKeep = 0;
        if (StringUtils.isBlank((CharSequence)expiryTypeNothing) && StringUtils.isBlank((CharSequence)expiryTypeResult) && StringUtils.isBlank((CharSequence)expiryTypeArtifact) && StringUtils.isBlank((CharSequence)expiryTypeBuildLog)) {
            log.warn((Object)"Expiry type not specified. This shouldn't happen.");
            errorCollection.addError(FIELD_EXPIRY_TYPE_NOTHING, "Expiry type not specified.");
        }
        if (StringUtils.isNotBlank((CharSequence)expiryTypeNothing) && Boolean.parseBoolean(expiryTypeNothing)) {
            return errorCollection;
        }
        if (StringUtils.isBlank((CharSequence)period)) {
            log.warn((Object)"period type not specified. This shouldn't happen.");
            errorCollection.addError(FIELD_PERIOD, "Period type not specified.");
        }
        if (StringUtils.isBlank((CharSequence)durationString) && StringUtils.isBlank((CharSequence)buildsToKeepString) && StringUtils.isBlank((CharSequence)maximumBuildsToKeepString)) {
            errorCollection.addError(FIELD_ENABLED, this.textProvider.getText("buildExpiry.buildsToKeep.error.invalid"));
            return errorCollection;
        }
        if (StringUtils.isNotBlank((CharSequence)durationString)) {
            try {
                duration = buildConfiguration.getInt(FIELD_DURATION);
            }
            catch (ConversionException e) {
                errorCollection.addError(FIELD_DURATION, this.textProvider.getText("error.format.int"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)buildsToKeepString)) {
            try {
                buildsToKeep = buildConfiguration.getInt(FIELD_BUILDS_TO_KEEP);
            }
            catch (ConversionException e) {
                errorCollection.addError(FIELD_BUILDS_TO_KEEP, this.textProvider.getText("error.format.int"));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)maximumBuildsToKeepString)) {
            try {
                maxBuildsToKeep = buildConfiguration.getInt(FIELD_MAX_BUILDS_TO_KEEP);
            }
            catch (ConversionException e) {
                errorCollection.addError(FIELD_MAX_BUILDS_TO_KEEP, this.textProvider.getText("error.format.int"));
            }
        }
        if (duration == 0 && buildsToKeep == 0 && maxBuildsToKeep == 0) {
            errorCollection.addError(FIELD_ENABLED, this.textProvider.getText("buildExpiry.buildsToKeep.error.invalid"));
        }
        if (maxBuildsToKeep > 0 && buildsToKeep > maxBuildsToKeep) {
            errorCollection.addError(FIELD_BUILDS_TO_KEEP, this.textProvider.getText("buildExpiry.minimum.higher.than.maximum"));
        }
        return errorCollection;
    }

    @Override
    protected void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull BuildConfiguration buildConfiguration, @Nullable Plan plan) {
    }

    @Override
    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan plan) {
        BuildExpiryConfig planExpiryConfig = PlanHelper.getConfigObject((ImmutablePlan)plan, BUILD_EXPIRY_CONFIG_CONSTANT, BuildExpiryConfig.class);
        CombinedExpiryConfig expiryConfig = new CombinedExpiryConfig(planExpiryConfig);
        context.put(BUILD_EXPIRY_CONFIG, expiryConfig);
        context.put("selectedExpiryTypesLabel", this.getSelectedExpiryTypesLabel(expiryConfig));
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return ALL_CONFIGURATION_FIELDS;
    }

    public String getSelectedExpiryTypesLabel(@NotNull CombinedExpiryConfig expiryConfig) {
        List<String> labelKeys = expiryConfig.getSelectedExpiryTypesLabelKeys(false);
        List labels = Lists.transform(labelKeys, BambooFunctions.translate(this.textProvider));
        return Joiner.on((String)", ").join((Iterable)labels);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

