/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.expiry.plugin;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.expiry.BuildExpiryConfig;
import com.atlassian.bamboo.build.expiry.BuildExpiryType;
import com.atlassian.bamboo.plugin.module.ext.CustomBuildDefinitionTransformer;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class BuildExpiryPerPlanTransformer
implements CustomBuildDefinitionTransformer {
    public void transformBuildDefinition(@NotNull Map<String, Object> configObjects, @NotNull Map<String, String> configParameters, @NotNull BuildDefinition buildDefinition) {
        if (configParameters.containsKey("custom.buildExpiryConfig.enabled")) {
            String expiryTypeResult = configParameters.get("custom.buildExpiryConfig.expiryTypeResult");
            String expiryTypeNothing = configParameters.get("custom.buildExpiryConfig.expiryTypeNothing");
            String expiryTypeArtifact = configParameters.get("custom.buildExpiryConfig.expiryTypeArtifact");
            String expiryTypeBuildLog = configParameters.get("custom.buildExpiryConfig.expiryTypeBuildLog");
            String durationString = configParameters.get("custom.buildExpiryConfig.duration");
            String period = configParameters.get("custom.buildExpiryConfig.period");
            String buildsToKeepString = configParameters.get("custom.buildExpiryConfig.buildsToKeep");
            String maxBuildsToKeepString = configParameters.get("custom.buildExpiryConfig.maximumBuildsToKeep");
            String maxIgnoredLogSizeString = configParameters.get("custom.buildExpiryConfig.maxIgnoredLogSize");
            String labelsToKeep = configParameters.get("custom.buildExpiryConfig.labelsToKeep");
            ArrayList<BuildExpiryType> expiryTypes = new ArrayList<BuildExpiryType>();
            if (Boolean.parseBoolean(expiryTypeResult)) {
                expiryTypes.add(BuildExpiryType.RESULTS_BUILD_EXPIRY_TYPE);
            }
            if (Boolean.parseBoolean(expiryTypeArtifact)) {
                expiryTypes.add(BuildExpiryType.ARTIFACT_BUILD_EXPIRY_TYPE);
            }
            if (Boolean.parseBoolean(expiryTypeBuildLog)) {
                expiryTypes.add(BuildExpiryType.BUILD_LOG_EXPIRY_TYPE);
            }
            if (Boolean.parseBoolean(expiryTypeNothing)) {
                expiryTypes.add(BuildExpiryType.NOTHING_BUILD_EXPIRY_TYPE);
            }
            BuildExpiryConfig expiryConfig = new BuildExpiryConfig(expiryTypes, NumberUtils.toInt((String)durationString), period, NumberUtils.toInt((String)buildsToKeepString), labelsToKeep);
            expiryConfig.setEnabled(Boolean.parseBoolean(configParameters.get("custom.buildExpiryConfig.enabled")));
            expiryConfig.setMaxIgnoredLogSize(NumberUtils.toLong((String)maxIgnoredLogSizeString));
            expiryConfig.setMaximumBuildsToKeep(NumberUtils.toInt((String)maxBuildsToKeepString));
            configObjects.put("buildExpiryConfig", expiryConfig);
        }
    }
}

