/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.fileserver;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.fileserver.BuildDirectoryManager;
import com.atlassian.bamboo.configuration.AdministrationConfiguration;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.configuration.ConcurrentBuildConfig;
import com.atlassian.bamboo.fileserver.SystemDirectory;
import com.atlassian.bamboo.v2.build.agent.ExecutableBuildAgent;
import com.atlassian.bamboo.v2.build.agent.capability.AgentContext;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DefaultBuildDirectoryManager
implements BuildDirectoryManager {
    private static final Logger log = Logger.getLogger(DefaultBuildDirectoryManager.class);
    private AgentContext agentContext;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;

    @NotNull
    public File getBuildWorkingDirectory(@NotNull Key key) {
        return new File(this.getWorkingDirectoryOfCurrentAgent(), key.toString());
    }

    public File getWorkingDirectoryOfCurrentAgent() {
        return new File(this.getBaseBuildWorkingDirectory(), this.getAgentPathPrefix(this.agentContext.getBuildAgent()));
    }

    public File getBaseBuildWorkingDirectory() {
        return SystemDirectory.getBaseBuildWorkingDirectory();
    }

    public File getApplicationHome() {
        return SystemDirectory.getApplicationHome();
    }

    public String getAgentPathPrefix(ExecutableBuildAgent buildAgent) {
        String agentPrefix = "";
        AdministrationConfiguration administrationConfiguration = this.administrationConfigurationAccessor.getAdministrationConfiguration();
        ConcurrentBuildConfig concurrentBuildConfig = administrationConfiguration.getConcurrentBuildConfig();
        if (concurrentBuildConfig.isEnabled() && buildAgent != null) {
            agentPrefix = Long.toString(buildAgent.getId()) + File.separator;
        }
        return agentPrefix;
    }

    @NotNull
    public File getServerSideTaskWorkingDirectory(@NotNull ResultKey resultKey) {
        File serverSideRoot = this.getServerSideTaskWorkingDirectory();
        return new File(serverSideRoot, resultKey.getKey());
    }

    @NotNull
    public Path getServerSideTaskWorkingDirectory(@NotNull BuildDirectoryManager.ServerSideTaskType taskType) {
        File serverSideRoot = this.getServerSideTaskWorkingDirectory();
        return Paths.get(serverSideRoot.getAbsolutePath(), taskType.toString());
    }

    @NotNull
    public File getServerSideTaskWorkingDirectory() {
        return new File(this.getBaseBuildWorkingDirectory(), "serverSide");
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setAgentContext(AgentContext agentContext) {
        this.agentContext = agentContext;
    }
}

