/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.SimpleLogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LogInterceptorStack;
import com.atlassian.bamboo.build.logger.LogMutatorStack;
import com.atlassian.bamboo.utils.collection.FIFOBoundedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildLogger
implements BuildLogger {
    private static final Logger log = Logger.getLogger(AbstractBuildLogger.class);
    private static final int MAX_BUILDLOG_SIZE = 100;
    private static final int MAX_ERROR_LOG_SIZE = 100;
    private final List<LogEntry> entries = Collections.synchronizedList(new FIFOBoundedList(100));
    private final List<LogEntry> errorEntries = Collections.synchronizedList(new FIFOBoundedList(100));
    private long timeOfLastLog = 0L;
    private final LogInterceptorStack interceptorStack = new LogInterceptorStack();
    private final LogMutatorStack mutatorStack = new LogMutatorStack();
    private String linePrefix;

    public AbstractBuildLogger(String linePrefix) {
        this.linePrefix = linePrefix;
    }

    public abstract void onAddLogEntry(@NotNull LogEntry var1);

    public abstract void stopStreamingBuildLogs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LogEntry> getBuildLog() {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            return new ArrayList<LogEntry>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LogEntry> getErrorLog() {
        List<LogEntry> list = this.errorEntries;
        synchronized (list) {
            return new ArrayList<LogEntry>(this.errorEntries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<LogEntry> getLastNLogEntries(int n) {
        List<LogEntry> list = this.entries;
        synchronized (list) {
            int logLength = this.entries.size();
            return new ArrayList<LogEntry>(this.entries.subList(Math.max(0, logLength - n), logLength));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<String> getStringErrorLogs() {
        ArrayList<String> errors = new ArrayList<String>();
        List<LogEntry> list = this.errorEntries;
        synchronized (list) {
            for (LogEntry entry : this.errorEntries) {
                errors.add(entry.getUnstyledLog());
            }
        }
        return errors;
    }

    @NotNull
    public String addBuildLogEntry(@NotNull LogEntry logEntry) {
        LogEntry mutatedLogEntry = this.interceptAndMutate(logEntry);
        return this.addLogEntry(mutatedLogEntry);
    }

    @NotNull
    public String addErrorLogEntry(@NotNull LogEntry logEntry) {
        LogEntry mutatedLogEntry = this.interceptAndMutateError(logEntry);
        return this.addErrorLogEntryInternal(mutatedLogEntry);
    }

    protected String addErrorLogEntryInternal(@NotNull LogEntry logEntry) {
        this.errorEntries.add(logEntry);
        return this.addLogEntry(logEntry);
    }

    @NotNull
    protected LogEntry interceptAndMutate(@NotNull LogEntry logEntry) {
        LogEntry mutatedLogEnty = this.mutatorStack.mutate(logEntry);
        this.interceptorStack.intercept(mutatedLogEnty);
        return mutatedLogEnty;
    }

    @NotNull
    protected LogEntry interceptAndMutateError(@NotNull LogEntry logEntry) {
        LogEntry mutatedLogEnty = this.mutatorStack.mutateError(logEntry);
        this.interceptorStack.interceptError(mutatedLogEnty);
        return mutatedLogEnty;
    }

    @NotNull
    protected String addLogEntry(@NotNull LogEntry logEntry) {
        if (log.isTraceEnabled()) {
            log.trace((Object)logEntry.getUnstyledLog());
        }
        this.entries.add(logEntry);
        this.timeOfLastLog = System.currentTimeMillis();
        this.onAddLogEntry(logEntry);
        String unstyledLog = logEntry.getUnstyledLog();
        return this.linePrefix + ": " + unstyledLog;
    }

    @NotNull
    public String addBuildLogEntry(@NotNull String logString) {
        return this.addBuildLogEntry((LogEntry)new SimpleLogEntry(logString));
    }

    @NotNull
    public String addErrorLogEntry(String logString) {
        return this.addErrorLogEntry((LogEntry)new ErrorLogEntry(logString));
    }

    public void addErrorLogEntry(String logString, @Nullable Throwable e) {
        String[] stackFrames;
        this.addErrorLogEntry(logString);
        for (String stackFrame : stackFrames = ExceptionUtils.getStackFrames((Throwable)e)) {
            this.addErrorLogEntry(stackFrame);
        }
    }

    @NotNull
    public String addBuildLogHeader(String logString, boolean showBothBanner) {
        String banner = StringUtils.repeat((String)"-", (int)logString.length());
        if (showBothBanner) {
            this.addBuildLogEntry(banner);
        }
        this.addBuildLogEntry(logString);
        this.addBuildLogEntry(banner);
        return logString;
    }

    public void clearBuildLog() {
    }

    public long getTimeOfLastLog() {
        return this.timeOfLastLog;
    }

    @NotNull
    public LogInterceptorStack getInterceptorStack() {
        return this.interceptorStack;
    }

    @NotNull
    public LogMutatorStack getMutatorStack() {
        return this.mutatorStack;
    }

    public void close() {
    }
}

