/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogUtils;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NotThreadSafe
public class BuildLogFileAccessor {
    private static final Logger log = Logger.getLogger(BuildLogFileAccessor.class);
    public static final String ENCODING = "UTF-8";
    private String keyForLogging;
    @NotNull
    private final File logFile;
    private LineIterator lineIterator;
    private int totalLines = -1;
    private final Map<Class<?>, Integer> totalLinesByEntryType = new HashMap();

    BuildLogFileAccessor(@NotNull Key planKey, int buildNumber) {
        this.keyForLogging = planKey + "-" + buildNumber;
        this.logFile = ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getLogFile(planKey, (long)buildNumber);
    }

    BuildLogFileAccessor(@NotNull ResultKey resultKey) {
        this.keyForLogging = resultKey.toString();
        this.logFile = ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getLogFile(resultKey);
    }

    @Deprecated
    @VisibleForTesting
    BuildLogFileAccessor(@Nullable File file) {
        this.logFile = file;
    }

    public boolean openFileForIteration() {
        try {
            if (this.logFile.exists()) {
                this.lineIterator = FileUtils.lineIterator((File)this.logFile, (String)ENCODING);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            log.error((Object)("Failed to open log file for " + this.keyForLogging), (Throwable)e);
            return false;
        }
    }

    public void closeFileForIteration() {
        LineIterator.closeQuietly((LineIterator)this.lineIterator);
    }

    public boolean hasNext() {
        return this.lineIterator != null && this.lineIterator.hasNext();
    }

    @Nullable
    public LogEntry nextLogEntry() {
        String line = this.nextLine();
        if (line == null) {
            return null;
        }
        return BuildLogUtils.convertToLogEntry(line);
    }

    @Nullable
    public String nextLine() {
        Preconditions.checkState((this.lineIterator != null ? 1 : 0) != 0, (Object)("Attempted to iterate through log file for " + this.keyForLogging + " before iterator has been initialised"));
        if (this.lineIterator.hasNext()) {
            return this.lineIterator.nextLine();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public LogEntry searchFileForEntry(@Nullable String textToSearchFor, boolean searchInErrorMessages) throws IOException {
        if (StringUtils.isBlank((CharSequence)textToSearchFor)) {
            return null;
        }
        LineIterator newIterator = FileUtils.lineIterator((File)this.logFile, (String)ENCODING);
        try {
            while (newIterator.hasNext()) {
                String line = newIterator.nextLine();
                if (line == null || !line.contains(textToSearchFor)) continue;
                if (!searchInErrorMessages && line.startsWith("error")) continue;
                LogEntry logEntry = BuildLogUtils.convertToLogEntry(line);
                return logEntry;
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)newIterator);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public LogEntry searchFileForEntry(@Nullable String textToSearchFor, int lastNLines, boolean searchInErrorMessages) throws IOException {
        block6: {
            if (StringUtils.isBlank((CharSequence)textToSearchFor)) {
                return null;
            }
            lineIterator = null;
            try {
                lineIterator = FileUtils.lineIterator((File)this.logFile, (String)"UTF-8");
                totalLines = this.getNumberOfLinesInFile();
                numLinesToCheck = lastNLines < 0 ? totalLines : lastNLines;
                startLine = Math.max(totalLines - numLinesToCheck, 0);
                for (i = 0; lineIterator.hasNext() && i < startLine; ++i) {
                    lineIterator.nextLine();
                }
                while (lineIterator.hasNext()) {
                    line = lineIterator.nextLine();
                    if (line == null || !line.contains(textToSearchFor) || !searchInErrorMessages && line.startsWith("error")) continue;
                    var10_10 = BuildLogUtils.convertToLogEntry(line);
                    break block6;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var11_11) {
                LineIterator.closeQuietly(lineIterator);
                throw var11_11;
            }
        }
        LineIterator.closeQuietly((LineIterator)lineIterator);
        return var10_10;
lbl-1000:
        // 1 sources

        {
            var9_9 = null;
        }
        LineIterator.closeQuietly((LineIterator)lineIterator);
        return var9_9;
    }

    public List<LogEntry> getLastNLogs(int numLogs) throws IOException {
        ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
        int totalLines = this.getNumberOfLinesInFile();
        if (totalLines > 0) {
            try (LineIterator lineIterator = FileUtils.lineIterator((File)this.logFile, (String)ENCODING);){
                BuildLogUtils.skipLines(numLogs, totalLines, lineIterator);
                while (lineIterator.hasNext()) {
                    String line = lineIterator.next();
                    logs.add(BuildLogUtils.convertToLogEntry(line));
                }
            }
        }
        return logs;
    }

    public List<LogEntry> getLastNLogsOfType(int numLogs, Collection<Class<?>> types) throws IOException {
        CircularFifoQueue lastNLogEntries = new CircularFifoQueue(numLogs);
        try (LineIterator lineIterator = FileUtils.lineIterator((File)this.logFile, (String)ENCODING);){
            block9: while (lineIterator.hasNext()) {
                String line = lineIterator.next();
                Class<? extends LogEntry> logEntryType = BuildLogUtils.getLogEntryType(line);
                for (Class<? extends LogEntry> clazz : types) {
                    if (!clazz.isAssignableFrom(logEntryType)) continue;
                    lastNLogEntries.add(line);
                    continue block9;
                }
            }
        }
        return lastNLogEntries.stream().map(BuildLogUtils::convertToLogEntry).collect(Collectors.toList());
    }

    public int getNumberOfLinesInFile() throws IOException {
        this.calculateNumberOfLines();
        return this.totalLines;
    }

    public int getNumberOfLinesOfType(Collection<Class<?>> types) throws IOException {
        this.calculateNumberOfLines();
        return this.totalLinesByEntryType.keySet().stream().filter(calculatedType -> types.stream().anyMatch(type -> type.isAssignableFrom((Class<?>)calculatedType))).mapToInt(this.totalLinesByEntryType::get).sum();
    }

    private synchronized void calculateNumberOfLines() throws IOException {
        if (this.totalLines == -1 && this.logFile.exists()) {
            this.totalLines = 0;
            try (BufferedReader reader = new BufferedReader(new FileReader(this.logFile));){
                String line = reader.readLine();
                while (line != null) {
                    ++this.totalLines;
                    Class<? extends LogEntry> logEntryType = BuildLogUtils.getLogEntryType(line);
                    this.totalLinesByEntryType.put(logEntryType, this.totalLinesByEntryType.getOrDefault(logEntryType, 0) + 1);
                    line = reader.readLine();
                }
            }
        }
    }
}

