/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogUtils;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.utils.expirables.ExpirableReferences;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildLogFileWriter
implements Closeable,
Flushable {
    private static final Logger log = Logger.getLogger(BuildLogFileWriter.class);
    private final Lock lock = new ReentrantLock();
    @NotNull
    private final File logFile;
    private static final Duration BUFFERED_WRITER_TIME_TO_IDLE = Duration.ofSeconds(30L);
    private ResettableLazyReference<BufferedWriter> writer;

    public BuildLogFileWriter(File logFile, @NotNull ExpiryTicker expiryTicker) {
        this.logFile = logFile;
        this.writer = this.newWriter(expiryTicker);
    }

    private ResettableLazyReference<BufferedWriter> newWriter(ExpiryTicker expiryTicker) {
        Supplier<BufferedWriter> newBufferedWriter = () -> {
            FileWriter out;
            try {
                FileUtils.forceMkdir((File)this.logFile.getParentFile());
                out = new FileWriter(this.logFile, true);
            }
            catch (IOException e) {
                log.error((Object)"", (Throwable)e);
                throw BambooObjectUtils.asRuntimeException((Throwable)e);
            }
            return new BufferedWriter(out);
        };
        return ExpirableReferences.expirableWithClose(newBufferedWriter, BUFFERED_WRITER_TIME_TO_IDLE, expiryTicker);
    }

    public void writeLog(@NotNull LogEntry logEntry) throws IOException {
        this.lock.lock();
        try {
            BufferedWriter writer = (BufferedWriter)this.writer.get();
            assert (writer != null);
            writer.write(BuildLogUtils.convertToLogFileEntry(logEntry));
            writer.newLine();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.writer.isInitialized()) {
                BufferedWriter bufferedWriter = (BufferedWriter)this.writer.get();
                this.writer.reset();
                bufferedWriter.flush();
                bufferedWriter.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.lock.lock();
        try {
            if (this.writer.isInitialized()) {
                ((BufferedWriter)this.writer.get()).flush();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

