/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.build.BuildOutputLogEntry;
import com.atlassian.bamboo.build.CommandLogEntry;
import com.atlassian.bamboo.build.ErrorLogEntry;
import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.LogEntryDateFormats;
import com.atlassian.bamboo.build.SimpleLogEntry;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.StorageLocationService;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildLogUtils {
    private static final Logger log = Logger.getLogger(BuildLogUtils.class);
    @VisibleForTesting
    static final String SEPARATOR = "\t";
    private static final LogEntry EMPTY_LOG_ENTRY = new SimpleLogEntry("", null);
    @VisibleForTesting
    static final String LOG_ENTRY_TYPE_ERROR = "error";
    @VisibleForTesting
    static final String LOG_ENTRY_TYPE_BUILD = "build";
    @VisibleForTesting
    static final String LOG_ENTRY_TYPE_COMMAND = "command";
    @VisibleForTesting
    static final String LOG_ENTRY_TYPE_SIMPLE = "simple";

    private BuildLogUtils() {
    }

    public static String convertToLogFileEntry(@NotNull LogEntry logEntry) {
        StringBuilder fileEntry = new StringBuilder();
        if (logEntry instanceof ErrorLogEntry) {
            fileEntry.append(LOG_ENTRY_TYPE_ERROR);
        } else if (logEntry instanceof BuildOutputLogEntry) {
            fileEntry.append(LOG_ENTRY_TYPE_BUILD);
        } else if (logEntry instanceof CommandLogEntry) {
            fileEntry.append(LOG_ENTRY_TYPE_COMMAND);
        } else {
            fileEntry.append(LOG_ENTRY_TYPE_SIMPLE);
        }
        fileEntry.append(SEPARATOR).append(logEntry.getFormattedDate());
        fileEntry.append(SEPARATOR);
        String logText = logEntry.getUnstyledLog();
        if (logText != null) {
            logText = StringUtils.remove((String)logText, (char)'\n');
            fileEntry.append(logText);
        }
        return fileEntry.toString();
    }

    @NotNull
    public static Class<? extends LogEntry> getLogEntryType(@NotNull String logLine) {
        String logType;
        switch (logType = StringUtils.substringBefore((String)logLine, (String)SEPARATOR)) {
            case "build": {
                return BuildOutputLogEntry.class;
            }
            case "error": {
                return ErrorLogEntry.class;
            }
            case "command": {
                return CommandLogEntry.class;
            }
        }
        return SimpleLogEntry.class;
    }

    @NotNull
    public static LogEntry convertToLogEntry(@Nullable String fileEntry) {
        return BuildLogUtils.convertToLogEntryInternal(fileEntry, LogEntryDateFormats.formatterInstance());
    }

    private static LogEntry convertToLogEntryInternal(@Nullable String rawLogEntry, @NotNull FastDateFormat dateFormat) {
        String[] split = BuildLogUtils.splitLogEntry(rawLogEntry);
        if (split.length == 0) {
            return EMPTY_LOG_ENTRY;
        }
        if (split.length != 3) {
            return new SimpleLogEntry(rawLogEntry, null);
        }
        String type = split[0];
        String date = split[1];
        String log = split[2];
        Date time = BuildLogUtils.convertDate(date);
        if (type.equals(LOG_ENTRY_TYPE_ERROR)) {
            return new ErrorLogEntry(log, time);
        }
        if (type.equals(LOG_ENTRY_TYPE_BUILD)) {
            return new BuildOutputLogEntry(log, time);
        }
        if (type.equals(LOG_ENTRY_TYPE_COMMAND)) {
            return new CommandLogEntry(log, time);
        }
        return new SimpleLogEntry(log, time);
    }

    @NotNull
    public static LogEntry convertSpecsLogToLogEntry(@Nullable String rawLogEntry) {
        String[] split = BuildLogUtils.splitSpecsLogEntry(rawLogEntry);
        if (split.length == 0) {
            return EMPTY_LOG_ENTRY;
        }
        return BuildLogUtils.isSpecsLogEntryWithDate(split) ? new SimpleLogEntry(split[1], BuildLogUtils.convertDate(split[0])) : new SimpleLogEntry(rawLogEntry, null);
    }

    public static boolean isSpecsLogEntryWithDate(@NotNull String[] split) {
        return split.length == 2 && BuildLogUtils.convertDate(split[0]) != null;
    }

    @Internal
    @NotNull
    public static String[] splitLogEntry(@Nullable String fileEntry) {
        return BuildLogUtils.splitLogEntry(fileEntry, 3);
    }

    @Internal
    @NotNull
    public static String[] splitSpecsLogEntry(@Nullable String rawLogEntry) {
        return BuildLogUtils.splitLogEntry(rawLogEntry, 2);
    }

    @Deprecated
    public static File getLogFileDirectory(@NotNull Key entityKey) {
        return ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getBuildLogsDirectory(entityKey);
    }

    @Deprecated
    public static String getLogFileName(@NotNull Key entityKey, int resultNumber) {
        return ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getLogFileName(entityKey, resultNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFileThroughLogger(@NotNull File file, @NotNull BuildLogger buildLogger) throws IOException {
        LineIterator iterator = FileUtils.lineIterator((File)file, (String)"UTF-8");
        try {
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                buildLogger.addBuildLogEntry(BuildLogUtils.convertToLogEntry(line));
            }
        }
        finally {
            LineIterator.closeQuietly((LineIterator)iterator);
        }
    }

    public static void skipLines(int numLogs, int totalLines, LineIterator lineIterator) {
        int numLinesToCheck = numLogs < 0 ? totalLines : numLogs;
        int startLine = totalLines - numLinesToCheck;
        for (int i = 0; lineIterator.hasNext() && i < startLine; ++i) {
            lineIterator.next();
        }
    }

    private static String[] splitLogEntry(@Nullable String rawLogEntry, int max) {
        if (rawLogEntry == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return StringUtils.splitByWholeSeparatorPreserveAllTokens((String)rawLogEntry, (String)SEPARATOR, (int)max);
    }

    @Nullable
    private static Date convertDate(@NotNull String date) {
        Date time = null;
        try {
            time = LogEntryDateFormats.formatterInstance().parse(date);
        }
        catch (Exception ignored) {
            log.debug(null, (Throwable)ignored);
        }
        return time;
    }
}

