/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.AbstractBuildLogger;
import com.atlassian.bamboo.build.logger.LazyBuildLogFileWriter;
import com.atlassian.bamboo.build.logger.LazyBuildLogFileWriterImpl;
import com.atlassian.bamboo.build.logger.LoggerId;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import com.atlassian.bamboo.serialization.ServerSideOnly;
import java.io.File;
import org.jetbrains.annotations.NotNull;

@ServerSideOnly
public class BuildLoggerImpl
extends AbstractBuildLogger {
    protected final ExpiryTicker expiryTicker;
    private final LazyBuildLogFileWriter lazyBuildLogFileWriter;
    private static final LazyBuildLogFileWriter NO_OP_WRITER = new LazyBuildLogFileWriter(){

        @Override
        public void write(LogEntry logEntry) {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    };

    public BuildLoggerImpl(LoggerId loggerId, @NotNull ExpiryTicker expiryTicker) {
        super(loggerId.getLinePrefix());
        this.expiryTicker = expiryTicker;
        if (loggerId.isPersistent()) {
            File logFile = new File(loggerId.getLogFileDirectory(), loggerId.getLogFileName());
            this.lazyBuildLogFileWriter = new LazyBuildLogFileWriterImpl(logFile, expiryTicker);
        } else {
            this.lazyBuildLogFileWriter = NO_OP_WRITER;
        }
    }

    @Override
    public void onAddLogEntry(@NotNull LogEntry logEntry) {
        this.lazyBuildLogFileWriter.write(logEntry);
    }

    @Override
    public synchronized void stopStreamingBuildLogs() {
        this.lazyBuildLogFileWriter.close();
    }

    public synchronized void flush() {
        this.lazyBuildLogFileWriter.flush();
    }
}

