/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.BuildLogFileWriter;
import com.atlassian.bamboo.build.logger.LazyBuildLogFileWriter;
import com.atlassian.bamboo.expirables.ExpiryTicker;
import io.atlassian.util.concurrent.LazyReference;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class LazyBuildLogFileWriterImpl
implements LazyBuildLogFileWriter {
    private static final Logger log = Logger.getLogger(LazyBuildLogFileWriterImpl.class);
    private volatile LazyReference<BuildLogFileWriter> fileWriterRef;

    public LazyBuildLogFileWriterImpl(final File logFile, final ExpiryTicker expiryTicker) {
        this.fileWriterRef = new LazyReference<BuildLogFileWriter>(){

            protected BuildLogFileWriter create() throws Exception {
                return new BuildLogFileWriter(logFile, expiryTicker);
            }
        };
    }

    @Override
    public void close() {
        BuildLogFileWriter fileWriter = this.getFileWriter();
        try {
            fileWriter.close();
        }
        catch (IOException e) {
            log.error((Object)"Failed to close the log file writer", (Throwable)e);
        }
        this.fileWriterRef = null;
    }

    @Override
    public void write(LogEntry logEntry) {
        BuildLogFileWriter fileWriter = this.getFileWriter();
        try {
            fileWriter.writeLog(logEntry);
        }
        catch (IOException e) {
            log.info((Object)"Unable to stream log to build logs", (Throwable)e);
        }
    }

    @Override
    public void flush() {
        BuildLogFileWriter fileWriter = this.getFileWriter();
        try {
            fileWriter.flush();
        }
        catch (IOException e) {
            log.info((Object)"Unable to flush log file writer", (Throwable)e);
        }
    }

    private BuildLogFileWriter getFileWriter() {
        LazyReference<BuildLogFileWriter> localFileWriter = this.fileWriterRef;
        if (localFileWriter == null) {
            return null;
        }
        return (BuildLogFileWriter)localFileWriter.get();
    }
}

