/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.LoggerId;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.storage.StorageLocationService;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class LoggerIds {
    private LoggerIds() {
    }

    public static LoggerId<Key> get(Key key) {
        return new NonPersistentLogger(key);
    }

    public static LoggerId<ResultKey> get(ResultKey resultKey) {
        return new PersistentLogger(resultKey);
    }

    private static class NonPersistentLogger
    extends LoggerId<Key> {
        NonPersistentLogger(Key key) {
            super(key);
        }

        @NotNull
        public BuildLogger getLogger(@NotNull BuildLoggerManager buildLoggerManager) {
            return buildLoggerManager.getLogger(this.key);
        }

        public boolean isPersistent() {
            return false;
        }

        public File getLogFileDirectory() {
            throw new UnsupportedOperationException();
        }

        public String getLogFileName() {
            throw new UnsupportedOperationException();
        }
    }

    private static class PersistentLogger
    extends LoggerId<ResultKey> {
        private PersistentLogger(ResultKey resultKey) {
            super((Key)resultKey);
        }

        @NotNull
        public BuildLogger getLogger(@NotNull BuildLoggerManager buildLoggerManager) {
            return buildLoggerManager.getLogger((ResultKey)this.key);
        }

        public boolean isPersistent() {
            return true;
        }

        public File getLogFileDirectory() {
            return ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getBuildLogsDirectory(((ResultKey)this.key).getEntityKey());
        }

        public String getLogFileName() {
            return ((StorageLocationService)ComponentAccessor.STORAGE_LOCATION_SERVICE.get()).getLogFileName((ResultKey)this.key);
        }

        public String getLinePrefix() {
            return ((ResultKey)this.key).toString();
        }
    }
}

