/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger.interceptors;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.Queue;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.jetbrains.annotations.NotNull;

public class LogMemorisingInterceptor
implements LogInterceptor {
    private final Queue<LogEntry> logEntries;

    public LogMemorisingInterceptor(int linesToRemember) {
        this.logEntries = Queues.synchronizedQueue((Queue)new CircularFifoQueue(linesToRemember));
    }

    public void intercept(@NotNull LogEntry logEntry) {
        this.logEntries.add(logEntry);
    }

    public void interceptError(@NotNull LogEntry logEntry) {
        this.logEntries.add(logEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Iterable<LogEntry> getLogEntries() {
        Queue<LogEntry> queue = this.logEntries;
        synchronized (queue) {
            return ImmutableList.copyOf(this.logEntries);
        }
    }
}

