/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger.interceptors;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogMutator;
import com.atlassian.bamboo.util.PasswordMaskingUtils;
import com.atlassian.bamboo.variable.VariableContext;
import org.jetbrains.annotations.NotNull;

public class PasswordMaskingLogMutator
implements LogMutator {
    private final VariableContext variableContext;

    public PasswordMaskingLogMutator(VariableContext variableContext) {
        this.variableContext = variableContext;
    }

    public LogEntry mutate(@NotNull LogEntry logEntry) {
        return this.createMutatedLog(logEntry);
    }

    public LogEntry mutateError(@NotNull LogEntry logEntry) {
        return this.createMutatedLog(logEntry);
    }

    private LogEntry createMutatedLog(LogEntry originalLogEntry) {
        String modifiedLog = PasswordMaskingUtils.maskPossiblePasswordValues((String)originalLogEntry.getUnstyledLog(), (VariableContext)this.variableContext);
        return originalLogEntry.cloneAndMutate(modifiedLog);
    }
}

