/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.build.monitoring.BuildHungDetails;
import com.atlassian.bamboo.build.monitoring.BuildHungDetailsImpl;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.event.BuildHungEvent;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.event.api.EventPublisher;
import java.time.Duration;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class BuildHangingMonitor {
    private static final Logger log = Logger.getLogger(BuildHangingMonitor.class);
    private static final AtomicBoolean running = new AtomicBoolean(false);
    private static final String BUILD_HANGING_CONFIG = "buildHangingConfig";
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private BuildLoggerManager buildLoggerManager;
    private BuildExecutionManager buildExecutionManager;
    private CachedPlanManager cachedPlanManager;
    private EventPublisher eventPublisher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBuildsForHanging() {
        if (running.get()) {
            log.info((Object)"BuildHangingMonitor already running");
            return;
        }
        try {
            running.set(true);
            log.debug((Object)"Checking currently running builds for potential hanging.");
            BuildHangingConfig globalConfig = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBuildHangingConfig();
            Iterable currentlyExecuting = this.buildExecutionManager.getCurrentlyExecuting();
            for (CurrentlyBuilding currentlyBuilding : currentlyExecuting) {
                if (currentlyBuilding.getStartTime() == null || currentlyBuilding.getBuildHangDetails() != null) continue;
                BuildHangingConfig config = globalConfig;
                BuildIdentifier buildIdentifier = currentlyBuilding.getBuildIdentifier();
                String buildKey = buildIdentifier.getPlanKey();
                ImmutableBuildable build = (ImmutableBuildable)this.cachedPlanManager.getPlanByKey(buildIdentifier.getPlanResultKey().getPlanKey(), ImmutableBuildable.class);
                if (build != null) {
                    BuildHangingConfig buildConfig = PlanHelper.getConfigObject((ImmutablePlan)build, BUILD_HANGING_CONFIG, BuildHangingConfig.class);
                    if (buildConfig != null) {
                        log.debug((Object)("Overriding Build Hanging config found for " + buildKey));
                        config = buildConfig;
                    } else {
                        log.debug((Object)("Using global build hanging defaults for " + buildKey));
                    }
                }
                if (config != null && !config.isDisabled()) {
                    BuildLogger buildLogger;
                    long timeOfLastLog;
                    boolean logTimeExceeded = false;
                    boolean buildTimeExceeded = false;
                    long currentBuildTime = currentlyBuilding.getElapsedTime();
                    double expectedTime = (double)currentlyBuilding.getAverageDuration() * config.getMultiplier();
                    log.debug((Object)("Expected Time: " + (long)expectedTime + ", Current Time: " + currentBuildTime));
                    if ((double)currentBuildTime >= expectedTime) {
                        buildTimeExceeded = true;
                        log.debug((Object)"Expected Build Time Exceeded");
                    }
                    long timeSinceLastLog = (timeOfLastLog = (buildLogger = this.buildLoggerManager.getLogger((ResultKey)buildIdentifier.getPlanResultKey())).getTimeOfLastLog()) == 0L ? currentBuildTime : System.currentTimeMillis() - timeOfLastLog;
                    long maxLogTime = Duration.ofMinutes(config.getMinutesBetweenLogs()).toMillis();
                    log.debug((Object)("Time Since Last Log: " + timeSinceLastLog + ", Max log time: " + maxLogTime));
                    if (timeSinceLastLog >= maxLogTime) {
                        logTimeExceeded = true;
                        log.debug((Object)"Expected Log Time Exceeded");
                    }
                    if (!buildTimeExceeded || !logTimeExceeded) continue;
                    log.warn((Object)("Bamboo has detected that " + buildKey + "-" + buildIdentifier.getBuildNumber() + " may have hung."));
                    log.warn((Object)("Time Since Last Log: " + timeSinceLastLog + ", Max log time: " + maxLogTime));
                    log.warn((Object)("Expected Build Time: " + expectedTime + ", Current Build Time: " + currentBuildTime));
                    BuildHungDetailsImpl buildHungDetails = new BuildHungDetailsImpl();
                    buildHungDetails.setLastLogTime(timeOfLastLog);
                    buildHungDetails.setExpectedLogTime(config.getMinutesBetweenLogs());
                    buildHungDetails.setExpectedBuildTime((long)expectedTime);
                    buildHungDetails.setTimeHangDetected(new Date());
                    currentlyBuilding.setBuildHangDetails((BuildHungDetails)buildHungDetails);
                    BuildHungEvent buildHungEvent = new BuildHungEvent(this, buildKey, buildIdentifier.getBuildNumber(), currentlyBuilding, buildLogger.getBuildLog());
                    this.eventPublisher.publish((Object)buildHungEvent);
                    continue;
                }
                log.debug((Object)"Build Hanging Config is disabled or null.");
            }
        }
        finally {
            running.set(false);
        }
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }
}

