/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.monitoring.BuildHungDetails;
import com.google.common.base.Objects;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildHungDetailsImpl
implements BuildHungDetails {
    private static final Logger log = Logger.getLogger(BuildHungDetailsImpl.class);
    private static final String EXPECTED_BUILD_TIME = "custom.buildmonitoring.buildhung.expectedBuildTime";
    private static final String EXPECTED_LOG_TIME = "custom.buildmonitoring.buildhung.expectedLogTime";
    private static final String TIME_HANG_DETECTED = "custom.buildmonitoring.buildhung.timeHangDetected";
    private static final String TIME_LAST_LOG = "custom.buildmonitoring.buildhung.lastLogTime";
    private Date timeHangDetected;
    private long expectedBuildTime;
    private long expectedLogTime;
    private long lastLogTime;

    @NotNull
    public Map<String, String> getDataMap() {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put(EXPECTED_BUILD_TIME, Long.toString(this.expectedBuildTime));
        dataMap.put(EXPECTED_LOG_TIME, Long.toString(this.expectedLogTime));
        if (this.timeHangDetected != null) {
            dataMap.put(TIME_HANG_DETECTED, Long.toString(this.timeHangDetected.getTime()));
        }
        dataMap.put(TIME_LAST_LOG, Long.toString(this.lastLogTime));
        return dataMap;
    }

    public void populateDataFromMap(Map<String, String> dataMap) {
        this.timeHangDetected = new Date(Long.parseLong(dataMap.get(TIME_HANG_DETECTED)));
        this.expectedBuildTime = Long.parseLong(dataMap.get(EXPECTED_BUILD_TIME));
        this.expectedLogTime = Long.parseLong(dataMap.get(EXPECTED_LOG_TIME));
        this.lastLogTime = Long.parseLong(dataMap.get(TIME_LAST_LOG));
    }

    public long getTimeSinceLastLogTime() {
        return new Date().getTime() - this.getLastLogTime();
    }

    public long getLastLogTime() {
        return this.lastLogTime;
    }

    public void setLastLogTime(long lastLogTime) {
        this.lastLogTime = lastLogTime;
    }

    public Date getTimeHangDetected() {
        return this.timeHangDetected;
    }

    public void setTimeHangDetected(Date timeHangDetected) {
        this.timeHangDetected = timeHangDetected;
    }

    public long getExpectedBuildTime() {
        return this.expectedBuildTime;
    }

    public void setExpectedBuildTime(long expectedBuildTime) {
        this.expectedBuildTime = expectedBuildTime;
    }

    public long getExpectedLogTime() {
        return this.expectedLogTime;
    }

    public void setExpectedLogTime(long expectedLogTime) {
        this.expectedLogTime = expectedLogTime;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.timeHangDetected, this.expectedBuildTime, this.expectedLogTime, this.lastLogTime});
    }

    public boolean equals(Object o) {
        if (!(o instanceof BuildHungDetailsImpl)) {
            return false;
        }
        BuildHungDetailsImpl rhs = (BuildHungDetailsImpl)o;
        return Objects.equal((Object)this.timeHangDetected, (Object)rhs.timeHangDetected) && Objects.equal((Object)this.expectedBuildTime, (Object)rhs.expectedBuildTime) && Objects.equal((Object)this.expectedLogTime, (Object)rhs.expectedLogTime) && Objects.equal((Object)this.lastLogTime, (Object)rhs.lastLogTime);
    }
}

