/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.monitoring.BuildHangingMonitor;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class BuildMonitorJobScheduler
implements Job {
    private static final Logger log = Logger.getLogger(BuildMonitorJobScheduler.class);
    private int buildCheckInterval;
    private Scheduler scheduler;
    private BuildHangingMonitor buildHangingMonitor;

    public void scheduleBuildMonitoring() throws SchedulerException {
        JobKey jobKey = new JobKey("BuildHangingMonitor", "BuildHangingMonitor");
        JobDetail jobDetail = JobBuilder.newJob(BuildMonitorJobScheduler.class).withIdentity(jobKey).build();
        log.info((Object)("Build hanging monitor running every " + this.buildCheckInterval + "s."));
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("BuildHangingMonitor").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)this.buildCheckInterval)).startNow().build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.buildHangingMonitor.checkBuildsForHanging();
    }

    public void setBuildCheckInterval(int buildCheckInterval) {
        this.buildCheckInterval = buildCheckInterval;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setBuildHangingMonitor(BuildHangingMonitor buildHangingMonitor) {
        this.buildHangingMonitor = buildHangingMonitor;
    }
}

