/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.CustomBuildProcessorServer;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.utils.error.SimpleErrorCollection;
import com.atlassian.bamboo.v2.build.BaseConfigurablePlugin;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.xwork2.TextProvider;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BuildMonitoringPerPlanPlugin
extends BaseConfigurablePlugin
implements CustomBuildProcessorServer {
    private static final Logger log = Logger.getLogger(BuildMonitoringPerPlanPlugin.class);
    private BuildContext buildContext;
    static final String BUILD_HANGING_CONFIG = "buildHangingConfig";
    static final String BUILD_HANGING_PREFIX = "custom.buildHangingConfig";
    static final String FIELD_ENABLED = "custom.buildHangingConfig.enabled";
    static final String FIELD_MULTIPLIER = "custom.buildHangingConfig.multiplier";
    static final String FIELD_LOG_TIME = "custom.buildHangingConfig.minutesBetweenLogs";
    static final String FIELD_QUEUE_TIMEOUT = "custom.buildHangingConfig.minutesQueueTimeout";
    private TextProvider textProvider;

    @Override
    @NotNull
    public ErrorCollection validate(@NotNull BuildConfiguration buildConfiguration) {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (!Boolean.parseBoolean(buildConfiguration.getString(FIELD_ENABLED))) {
            buildConfiguration.clearTree(BUILD_HANGING_PREFIX);
            buildConfiguration.setProperty(FIELD_ENABLED, (Object)Boolean.FALSE.toString());
            return errorCollection;
        }
        try {
            int logTime = buildConfiguration.getInt(FIELD_LOG_TIME);
            if (logTime <= 0) {
                errorCollection.addError(FIELD_LOG_TIME, "Please enter a number larger than zero");
            }
        }
        catch (ConversionException e) {
            errorCollection.addError(FIELD_LOG_TIME, this.textProvider.getText("error.format.int"));
        }
        try {
            double multiplier = buildConfiguration.getDouble(FIELD_MULTIPLIER);
            if (multiplier <= 0.0) {
                errorCollection.addError(FIELD_MULTIPLIER, "Please enter a number larger than zero");
            }
        }
        catch (ConversionException e) {
            errorCollection.addError(FIELD_MULTIPLIER, "Please enter a number");
        }
        try {
            int queueTimeout = buildConfiguration.getInt(FIELD_QUEUE_TIMEOUT);
            if (queueTimeout <= 0) {
                errorCollection.addError(FIELD_QUEUE_TIMEOUT, "Please enter a number larger than zero");
            }
        }
        catch (ConversionException e) {
            errorCollection.addError(FIELD_QUEUE_TIMEOUT, "Please enter a number");
        }
        return errorCollection;
    }

    @Override
    protected void populateContextForView(@NotNull Map<String, Object> context, @NotNull Plan plan) {
        BuildHangingConfig hangingConfig = PlanHelper.getConfigObject((ImmutablePlan)plan, BUILD_HANGING_CONFIG, BuildHangingConfig.class);
        if (hangingConfig != null) {
            context.put(BUILD_HANGING_CONFIG, hangingConfig);
        }
    }

    public void init(@NotNull BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    @NotNull
    public BuildContext call() throws Exception {
        return this.buildContext;
    }

    @NotNull
    public Set<String> getConfigurationKeys() {
        return ImmutableSet.of((Object)FIELD_ENABLED, (Object)FIELD_LOG_TIME, (Object)FIELD_MULTIPLIER, (Object)FIELD_QUEUE_TIMEOUT);
    }

    public boolean isConfigurationMissing(@NotNull HierarchicalConfiguration configuration) {
        return !configuration.containsKey(FIELD_ENABLED);
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

