/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.BuildDefinition;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.plugin.module.ext.CustomBuildDefinitionTransformer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BuildMonitoringTransformer
implements CustomBuildDefinitionTransformer {
    public void transformBuildDefinition(@NotNull Map<String, Object> configObjects, @NotNull Map<String, String> configParameters, @NotNull BuildDefinition buildDefinition) {
        if (Boolean.parseBoolean(configParameters.get("custom.buildHangingConfig.enabled"))) {
            BuildHangingConfig hangingConfig = new BuildHangingConfig();
            this.copyConfig(configParameters, hangingConfig);
            configObjects.put("buildHangingConfig", hangingConfig);
        }
    }

    private void copyConfig(Map<String, String> configParameters, BuildHangingConfig hangingConfig) {
        String multiplierString = configParameters.get("custom.buildHangingConfig.multiplier");
        String logTimeString = configParameters.get("custom.buildHangingConfig.minutesBetweenLogs");
        String queueTimeoutString = configParameters.get("custom.buildHangingConfig.minutesQueueTimeout");
        if (logTimeString != null) {
            hangingConfig.setMinutesBetweenLogs(Integer.parseInt(logTimeString));
        }
        if (multiplierString != null) {
            hangingConfig.setMultiplier(Double.parseDouble(multiplierString));
        }
        if (queueTimeoutString != null) {
            hangingConfig.setMinutesBeforeQueueTimeout(Integer.parseInt(queueTimeoutString));
        }
    }
}

