/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.monitoring.BuildHangingConfig;
import com.atlassian.bamboo.build.monitoring.BuildQueueTimeoutDetails;
import com.atlassian.bamboo.build.monitoring.BuildQueueTimeoutDetailsImpl;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.event.BuildQueueTimeoutEvent;
import com.atlassian.bamboo.plan.PlanHelper;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableBuildable;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.bamboo.v2.build.BuildIdentifier;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.queue.QueueManagerUtils;
import com.atlassian.event.api.EventPublisher;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class BuildQueueMonitor {
    private static final Logger log = Logger.getLogger(BuildQueueMonitor.class);
    private static final String BUILD_HANGING_CONFIG = "buildHangingConfig";
    private EventPublisher eventPublisher;
    private BuildExecutionManager buildExecutionManager;
    private BuildQueueManager buildQueueManager;
    private CachedPlanManager cachedPlanManager;
    private AdministrationConfigurationAccessor administrationConfigurationAccessor;
    private static final AtomicBoolean running = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBuildsForTimeInQueue() {
        if (!running.compareAndSet(false, true)) {
            log.info((Object)"BuildQueueMonitor already running");
            return;
        }
        try {
            log.debug((Object)"Checking currently scheduled builds for queue timeout.");
            BuildHangingConfig config = this.administrationConfigurationAccessor.getAdministrationConfiguration().getBuildHangingConfig();
            if (config == null) {
                config = new BuildHangingConfig();
            }
            Iterable queuedExecutables = QueueManagerUtils.getQueuedExecutables((BuildQueueManager)this.buildQueueManager);
            for (ResultKey resultKey : queuedExecutables) {
                CurrentlyBuilding currentlyBuilding = this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey(resultKey);
                if (currentlyBuilding == null || currentlyBuilding.getBuildQueueTimeoutDetails() != null) continue;
                BuildIdentifier buildIdentifier = currentlyBuilding.getBuildIdentifier();
                String buildKey = buildIdentifier.getPlanKey();
                ImmutableBuildable build = (ImmutableBuildable)this.cachedPlanManager.getPlanByKey(buildIdentifier.getPlanResultKey().getPlanKey(), ImmutableBuildable.class);
                if (build != null) {
                    BuildHangingConfig buildConfig = PlanHelper.getConfigObject((ImmutablePlan)build, BUILD_HANGING_CONFIG, BuildHangingConfig.class);
                    if (buildConfig != null) {
                        log.debug((Object)("Overriding Build Queue Timeout config found for " + buildKey));
                        config = buildConfig;
                    } else {
                        log.debug((Object)("Using global Queue Timeout defaults for " + buildKey));
                    }
                }
                if (!config.isDisabled()) {
                    if (BambooDateUtils.getMinutesDistanceToNow((Date)currentlyBuilding.getQueueTime()) < (long)config.getMinutesBeforeQueueTimeout()) continue;
                    BuildQueueTimeoutDetailsImpl queueTimeoutDetails = new BuildQueueTimeoutDetailsImpl(new Date(), config.getMinutesBeforeQueueTimeout());
                    currentlyBuilding.setBuildQueueTimeoutDetails((BuildQueueTimeoutDetails)queueTimeoutDetails);
                    BuildQueueTimeoutEvent buildQueueTimeoutEvent = new BuildQueueTimeoutEvent((Object)this, currentlyBuilding);
                    this.eventPublisher.publish((Object)buildQueueTimeoutEvent);
                    continue;
                }
                log.debug((Object)"Build Queue Timeout config is disabled or null.");
            }
        }
        finally {
            running.set(false);
        }
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    public void setBuildQueueManager(BuildQueueManager buildQueueManager) {
        this.buildQueueManager = buildQueueManager;
    }

    public void setAdministrationConfigurationAccessor(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        this.administrationConfigurationAccessor = administrationConfigurationAccessor;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }
}

