/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.monitoring.BuildQueueMonitor;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class BuildQueueMonitorJobScheduler
implements Job {
    private static final Logger log = Logger.getLogger(BuildQueueMonitorJobScheduler.class);
    private Scheduler scheduler;
    private BuildQueueMonitor buildQueueMonitor;
    private int buildQueueCheckInterval;

    public void scheduleBuildQueueMonitoring() throws SchedulerException {
        JobKey jobKey = new JobKey("BuildQueueMonitor", "BuildQueueMonitor");
        JobDetail jobDetail = JobBuilder.newJob(BuildQueueMonitorJobScheduler.class).withIdentity(jobKey).build();
        log.info((Object)("Build queue monitor running every " + this.buildQueueCheckInterval + "s."));
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity("BuildQueueMonitor").withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)this.buildQueueCheckInterval)).startNow().build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.buildQueueMonitor.checkBuildsForTimeInQueue();
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setBuildQueueMonitor(BuildQueueMonitor buildQueueMonitor) {
        this.buildQueueMonitor = buildQueueMonitor;
    }

    public void setBuildQueueCheckInterval(int buildQueueCheckInterval) {
        this.buildQueueCheckInterval = buildQueueCheckInterval;
    }
}

