/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import java.util.Date;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BuildStopDelayedJob
implements Job {
    public static final String BUILD_RESULT_KEY = "buildResultKey";
    public static final int AGENT_RESPONSE_CHECK_DELAY_SECONDS = 60;
    private static final Logger log = Logger.getLogger(BuildStopDelayedJob.class);
    private BuildExecutionManager buildExecutionManager;
    private BuildLoggerManager buildLoggerManager;
    private ResultsSummaryManager resultsSummaryManager;
    private ErrorUpdateHandler errorUpdateHandler;

    @NotNull
    public static String getJobName(@NotNull PlanResultKey planResultKey) {
        return planResultKey.getKey();
    }

    @NotNull
    public static String getJobGroupName() {
        Class<BuildStopDelayedJob> jobClass = BuildStopDelayedJob.class;
        return jobClass.getSimpleName();
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap context = jobExecutionContext.getJobDetail().getJobDataMap();
        String key = (String)context.get((Object)BUILD_RESULT_KEY);
        PlanResultKey planResultKey = PlanKeys.getPlanResultKey((String)key);
        CurrentlyBuilding currentlyBuilding = this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)planResultKey);
        if (currentlyBuilding != null) {
            if (currentlyBuilding.tryToFinish()) {
                ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
                if (resultsSummary != null && resultsSummary.isActive()) {
                    this.logCancellation(planResultKey, "agent had been requested to stop the build but sent no response");
                    boolean isForcedCancellation = true;
                    BuildCancelledDetails bcd = new BuildCancelledDetails(new Date(), true);
                    currentlyBuilding.setBuildCancelledDetails(bcd);
                    this.buildExecutionManager.finishBuild(resultsSummary.getPlanResultKey(), true);
                }
            } else {
                log.info((Object)String.format("Build %s already being stopped", planResultKey));
            }
        } else {
            ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(planResultKey);
            if (resultsSummary != null && resultsSummary.isActive()) {
                this.buildExecutionManager.finishBuild(resultsSummary.getPlanResultKey(), true);
            }
        }
    }

    private void logCancellation(PlanResultKey planResultKey, String reason) {
        String errorMessage = "Build " + planResultKey + " had to be cancelled: " + reason;
        log.error((Object)errorMessage);
        this.errorUpdateHandler.recordError((ResultKey)planResultKey, errorMessage, null);
        BuildLogger buildLogger = this.buildLoggerManager.getLogger((ResultKey)planResultKey);
        buildLogger.addErrorLogEntry(errorMessage);
    }

    public void setBuildExecutionManager(BuildExecutionManager buildExecutionManager) {
        this.buildExecutionManager = buildExecutionManager;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setResultsSummaryManager(ResultsSummaryManager resultsSummaryManager) {
        this.resultsSummaryManager = resultsSummaryManager;
    }

    public void setErrorUpdateHandler(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }
}

