/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.DeploymentResultKeyImpl;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.deployments.runtime.DeploymentInProgress;
import com.atlassian.bamboo.deployments.runtime.DeploymentsInProgressService;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class DeploymentStopDelayedJob
implements Job {
    public static final String RESULT_KEY = "resultKey";
    public static final int AGENT_RESPONSE_CHECK_DELAY_SECONDS = 60;
    private static final Logger log = Logger.getLogger(DeploymentStopDelayedJob.class);
    private DeploymentExecutionService deploymentExecutionService;
    private DeploymentsInProgressService deploymentsInProgressService;
    private DeploymentResultService deploymentResultService;
    private BuildLoggerManager buildLoggerManager;
    private ErrorUpdateHandler errorUpdateHandler;

    @NotNull
    public static String getJobName(@NotNull ResultKey resultKey) {
        return resultKey.getKey();
    }

    @NotNull
    public static String getJobGroupName() {
        Class<DeploymentStopDelayedJob> jobClass = DeploymentStopDelayedJob.class;
        return jobClass.getSimpleName();
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap context = jobExecutionContext.getJobDetail().getJobDataMap();
        String key = (String)context.get((Object)RESULT_KEY);
        DeploymentResultKeyImpl deploymentResultKey = DeploymentResultKeyImpl.from((String)key);
        DeploymentInProgress deploymentInProgress = this.deploymentsInProgressService.getDeploymentInProgressById(deploymentResultKey.getDeploymentResultId());
        if (deploymentInProgress != null) {
            DeploymentResult deploymentResult = this.deploymentResultService.getDeploymentResult(deploymentResultKey.getDeploymentResultId());
            if (deploymentResult != null && LifeCycleState.isActive((LifeCycleState)deploymentResult.getLifeCycleState())) {
                this.logCancellation((ResultKey)deploymentResultKey, "agent had been requested to stop the deployment but sent no response");
                this.deploymentExecutionService.terminateDeployment((DeploymentResultKey)deploymentResultKey);
            } else {
                log.info((Object)"deployment is already being stopped");
            }
        } else {
            DeploymentResult deploymentResult = this.deploymentResultService.getDeploymentResult(deploymentResultKey.getDeploymentResultId());
            if (deploymentResult != null && LifeCycleState.isActive((LifeCycleState)deploymentResult.getLifeCycleState())) {
                this.deploymentExecutionService.terminateDeployment((DeploymentResultKey)deploymentResultKey);
            }
        }
    }

    private void logCancellation(ResultKey planResultKey, String reason) {
        String errorMessage = "Deployment " + planResultKey + " had to be cancelled: " + reason;
        log.error((Object)errorMessage);
        this.errorUpdateHandler.recordError(planResultKey, errorMessage, null);
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(planResultKey);
        buildLogger.addErrorLogEntry(errorMessage);
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setErrorUpdateHandler(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }

    public void setDeploymentExecutionService(DeploymentExecutionService deploymentExecutionService) {
        this.deploymentExecutionService = deploymentExecutionService;
    }

    public void setDeploymentsInProgressService(DeploymentsInProgressService deploymentsInProgressService) {
        this.deploymentsInProgressService = deploymentsInProgressService;
    }

    public void setDeploymentResultService(DeploymentResultService deploymentResultService) {
        this.deploymentResultService = deploymentResultService;
    }
}

