/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildExecutionManager;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.core.BambooIdProvider;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.execution.service.DeploymentExecutionService;
import com.atlassian.bamboo.deployments.results.DeploymentResult;
import com.atlassian.bamboo.deployments.results.service.DeploymentResultService;
import com.atlassian.bamboo.deployments.runtime.DeploymentInProgress;
import com.atlassian.bamboo.deployments.runtime.DeploymentsInProgressService;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.util.BambooDateUtils;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildCancelledDetails;
import com.atlassian.bamboo.v2.build.CurrentlyBuilding;
import com.atlassian.bamboo.v2.build.agent.BuildAgent;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.atlassian.bamboo.v2.build.queue.QueueManagerUtils;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.PersistJobDataAfterExecution;

@PersistJobDataAfterExecution
@DisallowConcurrentExecution
public class OrphanedBuildMonitorJob
implements Job {
    private static final Logger log = Logger.getLogger(OrphanedBuildMonitorJob.class);
    private JobExecutionContext context;
    private static final String MAP_KEY_QUEUED = "queuedCandidates";
    private static final String MAP_KEY_IN_PROGRESS = "inProgressCandidates";
    public static final String MAP_KEY_REACTION_DELAY = "reactionTime";
    private int reactionDelay = -1;
    @Inject
    private BuildExecutionManager buildExecutionManager;
    @Inject
    private BuildLoggerManager buildLoggerManager;
    @Inject
    private BuildQueueManager buildQueueManager;
    @Inject
    private ResultsSummaryManager resultsSummaryManager;
    @Inject
    private ErrorUpdateHandler errorUpdateHandler;
    @Inject
    private DeploymentsInProgressService deploymentsInProgressService;
    @Inject
    private DeploymentResultService deploymentResultService;
    @Inject
    private DeploymentExecutionService deploymentExecutionService;
    @Inject
    private AgentManager agentManager;

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.context = jobExecutionContext;
        this.cleanUpBuildsAndDeploymentsWithInconsistentQueuedStatus();
        this.cleanUpBuildsWithDbStatusInProgressButDifferentDataInCbc();
    }

    private void cleanUpBuildsWithDbStatusInProgressButDifferentDataInCbc() {
        HashMap<CleanupCandidate, Date> newCleanupCandidates = new HashMap<CleanupCandidate, Date>();
        Iterable buildsInInProgressState = BambooIterables.transform((Iterable)this.resultsSummaryManager.getAllInProgressResultSummaries(BuildResultsSummary.class), CleanupCandidate::new);
        Iterable deploymentsInInProgressState = BambooIterables.transform((Iterable)this.deploymentResultService.getDeploymentResultsByLifeCycleState(Collections.singletonList(LifeCycleState.IN_PROGRESS)), CleanupCandidate::new);
        String candidateType = MAP_KEY_IN_PROGRESS;
        for (CleanupCandidate resultInInProgressState : Iterables.concat((Iterable)buildsInInProgressState, (Iterable)deploymentsInInProgressState)) {
            BuildAgent buildAgent;
            String msg;
            Long agentId;
            boolean isQueued;
            boolean isMissing;
            if (resultInInProgressState.isBuild()) {
                ResultsSummary resultsSummary = (ResultsSummary)Narrow.downTo((Object)resultInInProgressState.getResultObject(), ResultsSummary.class);
                CurrentlyBuilding currentlyBuilding = this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)resultsSummary.getPlanResultKey());
                isMissing = currentlyBuilding == null;
                isQueued = !isMissing && currentlyBuilding.isCurrentlyQueuedOnly();
                agentId = resultsSummary.getBuildAgentId();
            } else {
                DeploymentResult deploymentResult = (DeploymentResult)Narrow.downTo((Object)resultInInProgressState.getResultObject(), DeploymentResult.class);
                DeploymentInProgress deploymentInProgress = this.deploymentsInProgressService.getDeploymentInProgressById(deploymentResult.getId());
                isMissing = deploymentInProgress == null;
                isQueued = !isMissing && deploymentInProgress.getAgentId() == null;
                agentId = deploymentResult.getAgentId();
            }
            if (isQueued || isMissing) {
                boolean isEligibleForCleanup = this.checkEligibilityForCleanup(resultInInProgressState, this.getCleanupCandidates(candidateType), newCleanupCandidates);
                if (!isEligibleForCleanup) continue;
                msg = isMissing ? "it was marked as in progress in DB but Bamboo has no record of this build." : "it was marked as in progress in DB but no agents were assigned to it.";
                this.logCancellation(resultInInProgressState.getResultKey(), msg);
                this.finishBuildOrDeployment(resultInInProgressState);
                continue;
            }
            if (agentId == null || (buildAgent = this.agentManager.getAgent(agentId.longValue())) != null && buildAgent.isActive()) continue;
            msg = "it was marked as building on " + agentId + " but that agent is offline";
            this.logCancellation(resultInInProgressState.getResultKey(), msg);
            this.finishBuildOrDeployment(resultInInProgressState);
        }
        this.storeCleanupCandidates(candidateType, newCleanupCandidates);
    }

    private void cleanUpBuildsAndDeploymentsWithInconsistentQueuedStatus() {
        HashSet queuedExecutables = Sets.newHashSet((Iterable)QueueManagerUtils.getQueuedExecutables((BuildQueueManager)this.buildQueueManager));
        Iterable buildsInQueuedState = BambooIterables.transform((Iterable)this.resultsSummaryManager.getAllQueuedResultSummaries(BuildResultsSummary.class), CleanupCandidate::new);
        Iterable deploymentsInQueuedState = BambooIterables.transform((Iterable)this.deploymentResultService.getDeploymentResultsByLifeCycleState(Collections.singletonList(LifeCycleState.QUEUED)), CleanupCandidate::new);
        if (log.isDebugEnabled()) {
            log.debug((Object)(Iterables.size((Iterable)buildsInQueuedState) + " results found in a queued state."));
        }
        HashMap<CleanupCandidate, Date> newCleanupCandidates = new HashMap<CleanupCandidate, Date>();
        for (CleanupCandidate resultInQueuedState : Iterables.concat((Iterable)buildsInQueuedState, (Iterable)deploymentsInQueuedState)) {
            boolean isEligibleForCleanup;
            boolean isBuildInQueue = queuedExecutables.contains(resultInQueuedState.getResultKey());
            if (isBuildInQueue || !(isEligibleForCleanup = this.checkEligibilityForCleanup(resultInQueuedState, this.getCleanupCandidates(MAP_KEY_QUEUED), newCleanupCandidates))) continue;
            this.logCancellation(resultInQueuedState.getResultKey(), "it was marked as queued but was not present in the queue for (at least) the past " + this.getReactionDelay() + " seconds.");
            this.finishBuildOrDeployment(resultInQueuedState);
        }
        this.storeCleanupCandidates(MAP_KEY_QUEUED, newCleanupCandidates);
    }

    private void logCancellation(ResultKey planResultKey, String reason) {
        String errorMessage = "Build " + planResultKey + " had to be cancelled: " + reason;
        log.error((Object)errorMessage);
        this.errorUpdateHandler.recordError(planResultKey, errorMessage, null);
        try {
            BuildLogger buildLogger = this.buildLoggerManager.getLogger(planResultKey);
            buildLogger.addErrorLogEntry(errorMessage);
        }
        catch (Exception e) {
            log.error((Object)"Unable to log build cancellation: ", (Throwable)e);
        }
    }

    private boolean checkEligibilityForCleanup(CleanupCandidate cleanupCandidate, Map<CleanupCandidate, Date> cleanupCandidates, Map<CleanupCandidate, Date> newCleanupCandidates) {
        String sourceOfTruth;
        Date candidateSince = cleanupCandidates.get(cleanupCandidate);
        String string = sourceOfTruth = cleanupCandidate.getLifeCycleState() == LifeCycleState.QUEUED ? "queue" : "CBC";
        if (candidateSince != null) {
            if (BambooDateUtils.getSecondsDistanceToNow((Date)candidateSince) > (long)this.getReactionDelay()) {
                log.info((Object)(cleanupCandidate.getResultKey() + " marked as " + cleanupCandidate.getLifeCycleState() + " but not present in " + sourceOfTruth + " since " + candidateSince));
                return true;
            }
        } else {
            log.debug((Object)(cleanupCandidate.getResultKey() + " marked as " + cleanupCandidate.getLifeCycleState() + " but not present in the " + sourceOfTruth + ", build will be cancelled in " + this.getReactionDelay() + " seconds unless an agent picked it up"));
            candidateSince = new Date();
        }
        newCleanupCandidates.put(cleanupCandidate, candidateSince);
        return false;
    }

    private void storeCleanupCandidates(String candidateType, Map<CleanupCandidate, Date> newCleanupCandidates) {
        this.getJobDataMap().put(candidateType, newCleanupCandidates);
    }

    private JobDataMap getJobDataMap() {
        return this.context.getJobDetail().getJobDataMap();
    }

    @NotNull
    private Map<CleanupCandidate, Date> getCleanupCandidates(String candidateType) {
        HashMap<CleanupCandidate, Date> candidates = (HashMap<CleanupCandidate, Date>)this.getJobDataMap().get((Object)candidateType);
        if (candidates == null) {
            candidates = new HashMap<CleanupCandidate, Date>();
            this.storeCleanupCandidates(candidateType, candidates);
        }
        return candidates;
    }

    private int getReactionDelay() {
        if (this.reactionDelay == -1) {
            this.reactionDelay = this.getJobDataMap().getInt(MAP_KEY_REACTION_DELAY);
        }
        return this.reactionDelay;
    }

    private void finishBuildOrDeployment(@NotNull CleanupCandidate cleanupCandidate) {
        if (cleanupCandidate.isBuild()) {
            ResultsSummary resultsSummary = (ResultsSummary)Narrow.downTo((Object)cleanupCandidate.getResultObject(), ResultsSummary.class);
            CurrentlyBuilding currentlyBuilding = this.buildExecutionManager.getCurrentlyBuildingByPlanResultKey((ResultKey)resultsSummary.getPlanResultKey());
            if (currentlyBuilding != null) {
                if (currentlyBuilding.tryToFinish()) {
                    boolean isForcedCancellation = true;
                    BuildCancelledDetails bcd = new BuildCancelledDetails(new Date(), true);
                    currentlyBuilding.setBuildCancelledDetails(bcd);
                    this.buildExecutionManager.finishBuild(resultsSummary.getPlanResultKey(), true);
                } else {
                    log.info((Object)String.format("Build %s already being finished", cleanupCandidate.getResultKey()));
                }
            } else {
                this.buildExecutionManager.finishBuild(resultsSummary.getPlanResultKey(), true);
            }
        } else {
            this.deploymentExecutionService.terminateDeployment((DeploymentResultKey)cleanupCandidate.getResultKey());
        }
    }

    private static class CleanupCandidate {
        @NotNull
        private final BambooIdProvider resultObject;
        @NotNull
        private final ResultKey resultKey;
        @NotNull
        private final LifeCycleState lifeCycleState;

        public CleanupCandidate(@NotNull ResultsSummary resultsSummary) {
            this.resultObject = resultsSummary;
            this.resultKey = resultsSummary.getPlanResultKey();
            this.lifeCycleState = resultsSummary.getLifeCycleState();
        }

        public CleanupCandidate(@NotNull DeploymentResult deploymentResult) {
            this.resultObject = deploymentResult;
            this.resultKey = deploymentResult.getKey();
            this.lifeCycleState = deploymentResult.getLifeCycleState();
        }

        public boolean isBuild() {
            return this.resultObject instanceof ResultsSummary;
        }

        public boolean isDeployment() {
            return this.resultObject instanceof DeploymentResult;
        }

        @NotNull
        public ResultKey getResultKey() {
            return this.resultKey;
        }

        @NotNull
        public LifeCycleState getLifeCycleState() {
            return this.lifeCycleState;
        }

        @NotNull
        public BambooIdProvider getResultObject() {
            return this.resultObject;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CleanupCandidate that = (CleanupCandidate)o;
            return this.resultObject.equals(that.resultObject);
        }

        public int hashCode() {
            return this.resultObject.hashCode();
        }
    }
}

