/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.monitoring;

import com.atlassian.bamboo.build.monitoring.OrphanedBuildMonitorJob;
import com.atlassian.bamboo.schedule.BambooScheduler;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class OrphanedBuildMonitorJobScheduler
implements BambooScheduler {
    private static final Logger log = Logger.getLogger(OrphanedBuildMonitorJobScheduler.class);
    private final Scheduler scheduler;
    private final int reactionDelay;
    private static final int INITIAL_DELAY_SECONDS = 300;

    public OrphanedBuildMonitorJobScheduler(Scheduler scheduler, int heartbeatTimeoutSeconds, int heartbeatInterval) {
        this.scheduler = scheduler;
        this.reactionDelay = heartbeatTimeoutSeconds + 2 * heartbeatInterval;
    }

    public void initialiseSchedule() {
        Class<OrphanedBuildMonitorJob> jobClass = OrphanedBuildMonitorJob.class;
        JobKey jobKey = new JobKey(jobClass.getSimpleName(), this.getClass().getSimpleName());
        JobDetail jobDetail = JobBuilder.newJob(jobClass).withIdentity(jobKey).build();
        jobDetail.getJobDataMap().put("reactionTime", this.reactionDelay);
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobKey.getName()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatMinutelyForever((int)1)).startAt(new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(300L))).build();
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
            log.info((Object)"Orphaned build monitor running every 1m.");
        }
        catch (SchedulerException e) {
            log.error((Object)"Unable to schedule orphaned build monitoring.");
        }
    }
}

