/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.pipeline.tasks;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomBuildProcessor;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.warning.BuildWarningSummaryCollationService;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plugin.descriptor.CustomBuildProcessorModuleDescriptor;
import com.atlassian.bamboo.setup.HomeDirectoryLayout;
import com.atlassian.bamboo.task.TaskExecutor;
import com.atlassian.bamboo.util.BambooFileUtils;
import com.atlassian.bamboo.util.BambooObjectUtils;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.agent.BuildPhase;
import com.atlassian.bamboo.v2.build.agent.InterruptibleBuildPhase;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.task.BuildStateHelper;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ExecuteBuildTask
implements InterruptibleBuildPhase,
BuildPhase {
    private static final Logger log = Logger.getLogger(ExecuteBuildTask.class);
    private BuildLoggerManager buildLoggerManager;
    private ErrorUpdateHandler errorUpdateHandler;
    private ExecutionPhaseService executionPhaseService;
    private PluginAccessor pluginAccessor;
    private TaskExecutor taskExecutor;
    @Inject
    private ArtifactManager artifactManager;
    @Inject
    private HomeDirectoryLayout homeDirectoryLayout;
    @Inject
    private BuildWarningSummaryCollationService buildWarningSummaryCollationService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public CommonContext call(@NotNull CommonContext commonContext, @NotNull ReadOnlyCapabilitySet capabilitySet) throws Exception {
        ResultKey resultKey = commonContext.getResultKey();
        log.info((Object)("Starting execution: " + resultKey + ", logger: " + System.identityHashCode(buildLogger)));
        try (BuildLogger buildLogger = this.buildLoggerManager.getLogger(resultKey);){
            CurrentResult buildResult = commonContext.getCurrentResult();
            this.executionPhaseService.executionStarted(commonContext);
            BuildContext buildContext = (BuildContext)Narrow.to((Object)commonContext, BuildContext.class);
            try {
                List taskResults = this.taskExecutor.execute(commonContext, capabilitySet);
                commonContext.getCurrentResult().getTaskResults().addAll(taskResults);
                BuildStateHelper.calculateBuildAndLifeCycleState(buildResult, commonContext.getCurrentResult().getTaskResults());
                if (buildContext != null) {
                    this.buildWarningSummaryCollationService.publishCollectedWarnings(buildContext);
                    this.performCustomBuildProcess(buildContext, buildLogger);
                }
            }
            catch (Throwable throwable) {
                String errorMessage = "Failed to execute the build '" + resultKey.getKey() + "'";
                log.fatal((Object)errorMessage, throwable);
                buildLogger.addErrorLogEntry(errorMessage + ": " + throwable.getMessage());
                this.errorUpdateHandler.recordError(commonContext.getResultKey(), errorMessage, throwable);
                buildResult.setBuildState(BuildState.FAILED);
                buildResult.addBuildErrors(Collections.singletonList(errorMessage + "\n" + ExceptionUtils.getStackTrace((Throwable)throwable)));
            }
            if (buildContext != null) {
                File workingDirectory = BuildContextHelper.getBuildWorkingDirectory(buildContext);
                this.cleanWorkingDirectory(buildContext, buildLogger, workingDirectory);
            }
            buildLogger.addBuildLogEntry("Finalising the build...");
            buildLogger.addBuildLogEntry("Stopping timer.");
            buildLogger.addBuildLogEntry("Build " + resultKey.getKey() + " completed.");
            this.executionPhaseService.executionFinished(commonContext);
            CommonContext commonContext2 = commonContext;
            return commonContext2;
        }
    }

    private void cleanWorkingDirectory(@NotNull BuildContext buildContext, @NotNull BuildLogger buildLogger, @NotNull File workingDirectory) {
        if (buildContext.getBuildDefinition().isCleanWorkingDirectory().booleanValue()) {
            PlanKey planKey = buildContext.getPlanResultKey().getPlanKey();
            try {
                if (!BambooFileUtils.isDirectoryImportant(workingDirectory)) {
                    BambooFileUtils.cleanDirectory(workingDirectory);
                    String message = "Successfully removed working directory at '" + workingDirectory.getAbsolutePath() + "'";
                    buildLogger.addBuildLogEntry(message);
                    log.info((Object)(message + " for plan '" + planKey + "'"));
                }
            }
            catch (Exception e) {
                String message = "Could not remove working directory for plan '" + planKey + "': " + e.getMessage();
                log.error((Object)message, (Throwable)e);
                buildLogger.addErrorLogEntry(message);
                this.errorUpdateHandler.recordError(buildContext.getResultKey(), message, (Throwable)e);
            }
        }
    }

    private void performCustomBuildProcess(BuildContext buildContext, @NotNull BuildLogger buildLogger) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CustomBuildProcessorModuleDescriptor.class);
        for (CustomBuildProcessorModuleDescriptor moduleDescriptor : moduleDescriptors) {
            log.info((Object)buildLogger.addBuildLogEntry("Running post build plugin '" + moduleDescriptor.getName() + "'"));
            CustomBuildProcessor buildProcessor = (CustomBuildProcessor)moduleDescriptor.getModule();
            if (buildProcessor == null) continue;
            try {
                buildProcessor.init(buildContext);
                BuildContext returnedBuildContext = buildProcessor.call();
                if (returnedBuildContext == null) continue;
                buildContext = returnedBuildContext;
            }
            catch (InterruptedException e) {
                log.warn((Object)("Running of plugin " + buildProcessor + " was interuptted."));
            }
            catch (Throwable e) {
                log.warn((Object)("Failed to execute plugin with class " + moduleDescriptor.getModuleClass().getName() + " : " + buildContext.getBuildResultKey()), e);
                buildLogger.addErrorLogEntry("Failed to execute plugin '" + moduleDescriptor.getName() + "' with error: " + BambooObjectUtils.getMessageOrStackTrace((Throwable)e));
            }
        }
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setExecutionPhaseService(ExecutionPhaseService executionPhaseService) {
        this.executionPhaseService = executionPhaseService;
    }

    public void setErrorUpdateHandler(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }
}

