/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.pipeline.tasks;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.BuildLoggerManager;
import com.atlassian.bamboo.build.CustomPreBuildAction;
import com.atlassian.bamboo.build.artifact.ArtifactHandlingUtils;
import com.atlassian.bamboo.build.artifact.ArtifactManager;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.deployments.CustomPreDeploymentAction;
import com.atlassian.bamboo.deployments.CustomPreDeploymentActionManager;
import com.atlassian.bamboo.deployments.CustomPreDeploymentActionModuleDescriptor;
import com.atlassian.bamboo.deployments.execution.DeploymentContext;
import com.atlassian.bamboo.execution.ExecutionPhaseService;
import com.atlassian.bamboo.logger.ErrorUpdateHandler;
import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.atlassian.bamboo.plugin.BambooPluginUtils;
import com.atlassian.bamboo.plugin.descriptor.CustomPreBuildActionModuleDescriptor;
import com.atlassian.bamboo.task.TaskExecutor;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.atlassian.bamboo.v2.build.BuildContextHelper;
import com.atlassian.bamboo.v2.build.CommonContext;
import com.atlassian.bamboo.v2.build.CurrentResult;
import com.atlassian.bamboo.v2.build.agent.InterruptibleBuildPhase;
import com.atlassian.bamboo.v2.build.agent.capability.ReadOnlyCapabilitySet;
import com.atlassian.bamboo.v2.build.task.BuildStateHelper;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrepareBuildTask
implements InterruptibleBuildPhase {
    private static final Logger log = Logger.getLogger(PrepareBuildTask.class);
    private BuildLoggerManager buildLoggerManager;
    private ErrorUpdateHandler errorUpdateHandler;
    private PluginAccessor pluginAccessor;
    private CustomPreDeploymentActionManager customPreDeploymentActionManager;
    private ArtifactManager artifactManager;
    private TaskExecutor taskExecutor;
    private ExecutionPhaseService executionPhaseService;

    @NotNull
    public CommonContext call(@NotNull CommonContext commonContext, @NotNull ReadOnlyCapabilitySet capabilitySet) {
        DeploymentContext deploymentContext;
        BuildContext buildContext;
        ResultKey planResultKey = commonContext.getResultKey();
        BuildLogger buildLogger = this.buildLoggerManager.getLogger(planResultKey);
        log.info((Object)buildLogger.addBuildLogEntry("Executing build " + commonContext.getDisplayName()));
        CurrentResult buildResult = commonContext.getCurrentResult();
        buildResult.setTasksStartDate(new Date());
        ErrorCollection errorCollection = commonContext.getErrorCollection();
        List preparationTaskResults = this.taskExecutor.executePreparationTasks(commonContext, capabilitySet);
        buildResult.setTaskResults(preparationTaskResults);
        if (!preparationTaskResults.isEmpty()) {
            BuildStateHelper.calculateBuildAndLifeCycleState(buildResult, preparationTaskResults);
            if (buildResult.getBuildState() == BuildState.FAILED) {
                String errorMessage = "Failed to prepare the build '" + commonContext.getDisplayName() + "'";
                log.fatal((Object)errorMessage);
                buildLogger.addErrorLogEntry(errorMessage);
                errorCollection.addErrorMessage(errorMessage);
                this.errorUpdateHandler.recordError(commonContext.getEntityKey(), errorMessage);
                buildResult.addBuildErrors(Arrays.asList(errorMessage));
                buildLogger.close();
                buildResult.getTaskResults().addAll(this.taskExecutor.executeFinalTasks(commonContext, capabilitySet));
                return commonContext;
            }
        }
        if ((buildContext = (BuildContext)Narrow.to((Object)commonContext, BuildContext.class)) != null && this.prepareArtifacts(buildContext, buildLogger, errorCollection)) {
            this.runPreBuildActions(buildContext, buildLogger, errorCollection);
        }
        if ((deploymentContext = (DeploymentContext)Narrow.to((Object)commonContext, DeploymentContext.class)) != null) {
            this.runPreDeploymentActions(deploymentContext, buildLogger, errorCollection);
        }
        if (errorCollection.hasAnyErrors()) {
            log.warn((Object)buildLogger.addErrorLogEntry(errorCollection.getTotalErrors() + " error(s) found when performing pre-build actions. "));
            this.errorUpdateHandler.addErrorCollection(commonContext.getResultKey(), errorCollection);
            buildResult.setBuildState(BuildState.FAILED);
            this.executionPhaseService.executionFinished(commonContext);
            buildResult.getTaskResults().addAll(this.taskExecutor.executeFinalTasks(commonContext, capabilitySet));
        }
        return commonContext;
    }

    private void runPreBuildActions(final BuildContext buildContext, final BuildLogger buildLogger, final ErrorCollection errorCollection) {
        List customPreBuildActionModuleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(CustomPreBuildActionModuleDescriptor.class);
        for (CustomPreBuildActionModuleDescriptor moduleDescriptor : customPreBuildActionModuleDescriptors) {
            final CustomPreBuildAction customPreBuildAction = (CustomPreBuildAction)moduleDescriptor.getModule();
            if (customPreBuildAction == null) continue;
            BambooPluginUtils.Callable callable = new BambooPluginUtils.Callable("Exception occurred while executing custom pre-build action '" + customPreBuildAction + "'. Building will abort..."){

                @Nullable
                public Object call() throws Exception {
                    customPreBuildAction.init(buildContext);
                    return customPreBuildAction.call();
                }

                @Override
                public void onThrow(@NotNull Throwable e) {
                    buildLogger.addBuildLogEntry(this.getErrorMessage() + " : " + e);
                    errorCollection.addErrorMessage(this.getErrorMessage(), new Exception(e));
                }
            };
            log.info((Object)buildLogger.addBuildLogEntry("Running pre-build action: " + moduleDescriptor.getName()));
            BambooPluginUtils.callUnsafeCode(callable);
        }
    }

    private void runPreDeploymentActions(final DeploymentContext deploymentContext, final BuildLogger buildLogger, final ErrorCollection errorCollection) {
        List customPreDeploymentActionModuleDescriptors = this.customPreDeploymentActionManager.getCustomPreDeploymentActionModuleDescriptors();
        for (CustomPreDeploymentActionModuleDescriptor moduleDescriptor : customPreDeploymentActionModuleDescriptors) {
            final CustomPreDeploymentAction customPreDeploymentAction = (CustomPreDeploymentAction)moduleDescriptor.getModule();
            BambooPluginUtils.Callable callable = new BambooPluginUtils.Callable("Exception occurred while executing custom pre-deployment action '" + customPreDeploymentAction + "'. Deploying will abort..."){

                @Nullable
                public Object call() throws Exception {
                    customPreDeploymentAction.execute(deploymentContext);
                    return null;
                }

                @Override
                public void onThrow(@NotNull Throwable e) {
                    buildLogger.addBuildLogEntry(this.getErrorMessage() + " : " + e);
                    errorCollection.addErrorMessage(this.getErrorMessage(), new Exception(e));
                }
            };
            log.info((Object)buildLogger.addBuildLogEntry("Running pre-deployment action: " + moduleDescriptor.getName()));
            BambooPluginUtils.callUnsafeCode(callable);
        }
    }

    private boolean prepareArtifacts(BuildContext buildContext, BuildLogger buildLogger, ErrorCollection errorCollection) {
        Collection subscriptionContexts = buildContext.getArtifactContext().getSubscriptionContexts();
        for (ArtifactSubscriptionContext subscriptionContext : subscriptionContexts) {
            String artifactName = subscriptionContext.getArtifactDefinitionContext().getName();
            String destinationPath = subscriptionContext.getDestinationPath();
            File buildWorkingDirectory = BuildContextHelper.getBuildWorkingDirectory((CommonContext)buildContext);
            Path resolvedArtifactLocation = ArtifactHandlingUtils.resolveArtifactLocation(buildWorkingDirectory.toPath(), destinationPath);
            Stopwatch stopWatch = Stopwatch.createStarted();
            log.info((Object)buildLogger.addBuildLogEntry("Preparing artifact '" + artifactName + "' for use at " + resolvedArtifactLocation + " (location: " + destinationPath + ')'));
            if (!this.artifactManager.retrieve(buildLogger, buildContext.getPlanResultKey(), subscriptionContext, BuildContextHelper.getArtifactHandlerConfiguration((CommonContext)buildContext), buildWorkingDirectory, buildContext.getArtifactContext().getSharedArtifactsFromPreviousStages())) {
                String errorMessage = "Failure in artifact preparation phase during processing of: " + subscriptionContext;
                buildLogger.addBuildLogEntry(errorMessage);
                errorCollection.addErrorMessage(errorMessage);
                log.warn((Object)errorMessage);
                return false;
            }
            log.info((Object)buildLogger.addBuildLogEntry("Artifact '" + artifactName + "' prepared in " + stopWatch + " at " + subscriptionContext.getEffectiveDestinationPath()));
        }
        return true;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setCustomPreDeploymentActionManager(CustomPreDeploymentActionManager customPreDeploymentActionManager) {
        this.customPreDeploymentActionManager = customPreDeploymentActionManager;
    }

    public void setErrorUpdateHandler(ErrorUpdateHandler errorUpdateHandler) {
        this.errorUpdateHandler = errorUpdateHandler;
    }

    public void setBuildLoggerManager(BuildLoggerManager buildLoggerManager) {
        this.buildLoggerManager = buildLoggerManager;
    }

    public void setArtifactManager(ArtifactManager artifactManager) {
        this.artifactManager = artifactManager;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setExecutionPhaseService(ExecutionPhaseService executionPhaseService) {
        this.executionPhaseService = executionPhaseService;
    }
}

