/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.statistics;

import com.atlassian.bamboo.build.statistics.FailurePeriod;
import com.atlassian.bamboo.build.statistics.StatisticsCollector;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.util.NumberUtils;
import com.atlassian.bamboo.utils.Comparators;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatisticsCollectorImpl
implements StatisticsCollector {
    private static final Logger log = Logger.getLogger(StatisticsCollectorImpl.class);
    private final ImmutablePlan plan;
    private final List<Integer> successBuildNumbers = new ArrayList<Integer>();
    private final List<Integer> failureBuildNumbers = new ArrayList<Integer>();
    private final List<Integer> allBuildNumbers = new ArrayList<Integer>();
    private final List<FailurePeriod> failurePeriods = new ArrayList<FailurePeriod>();

    public StatisticsCollectorImpl(@Nullable ImmutablePlan plan, @Nullable List<? extends ResultsSummary> results) {
        this.plan = plan;
        if (results != null) {
            this.init(results);
        }
    }

    public void init(@NotNull List<? extends ResultsSummary> results) {
        ArrayList<? extends ResultsSummary> sortedResults = new ArrayList<ResultsSummary>(results);
        Collections.sort(sortedResults, Comparators.getResultsSummaryNumberOrdering());
        FailurePeriod openFailurePeriod = null;
        for (ResultsSummary resultsSummary : sortedResults) {
            Integer buildNumber = resultsSummary.getBuildNumber();
            BuildState state = resultsSummary.getBuildState();
            if (this.successBuildNumbers.contains(buildNumber) || this.failureBuildNumbers.contains(buildNumber)) continue;
            if (BuildState.SUCCESS == state) {
                if (openFailurePeriod != null) {
                    openFailurePeriod.setFixingBuild(resultsSummary);
                    openFailurePeriod = null;
                }
                this.successBuildNumbers.add(buildNumber);
            } else if (BuildState.FAILED == state || BuildState.UNKNOWN == state) {
                if (openFailurePeriod == null) {
                    openFailurePeriod = new FailurePeriod(this.plan.getPlanKey(), this.plan.getLastBuildNumber());
                    this.failurePeriods.add(openFailurePeriod);
                }
                openFailurePeriod.addFailingBuild(resultsSummary);
                this.failureBuildNumbers.add(buildNumber);
            }
            this.allBuildNumbers.add(buildNumber);
        }
        Collections.sort(this.successBuildNumbers);
        Collections.sort(this.failureBuildNumbers);
        Collections.sort(this.allBuildNumbers);
    }

    @Override
    public List<FailurePeriod> getFailurePeriods() {
        return this.failurePeriods;
    }

    @Override
    public double getSuccessPercentage() {
        if (this.getTotalNumberOfResults() > 0) {
            double percentage = (double)this.getTotalSuccesses() / (double)this.getTotalNumberOfResults() * 100.0;
            return Math.floor(percentage);
        }
        return 0.0;
    }

    @Override
    public int getTotalNumberOfResults() {
        return this.getTotalFailures() + this.getTotalSuccesses();
    }

    @Override
    public int getTotalFailures() {
        return this.failureBuildNumbers.size();
    }

    @Override
    public int getTotalSuccesses() {
        return this.successBuildNumbers.size();
    }

    @Override
    public List<Integer> getAllTestBuildNumbers() {
        return this.allBuildNumbers;
    }

    @Override
    public List<Integer> getSuccessfulBuildNumbers() {
        return this.successBuildNumbers;
    }

    @Override
    public List<Integer> getFailedBuildNumbers() {
        return this.failureBuildNumbers;
    }

    @Override
    public int getCreatedInBuild() {
        return this.getAllTestBuildNumbers().get(0);
    }

    @Override
    public int getLastRanInBuild() {
        return this.getAllTestBuildNumbers().get(this.getAllTestBuildNumbers().size() - 1);
    }

    @Override
    @Nullable
    public FailurePeriod getLongestElapsedTimePeriod() {
        FailurePeriod period = null;
        for (FailurePeriod currentFailure : this.getFailurePeriods()) {
            if (period != null && currentFailure.getElapsedTime() <= period.getElapsedTime()) continue;
            period = currentFailure;
        }
        return period;
    }

    @Override
    public FailurePeriod getLongestElapsedBuildPeriod() {
        FailurePeriod period = null;
        for (FailurePeriod currentFailure : this.getFailurePeriods()) {
            try {
                if (period != null && currentFailure.getElapsedBuilds() <= period.getElapsedBuilds()) continue;
                period = currentFailure;
            }
            catch (Exception e) {
                log.error((Object)"Bamboo failed to find the elapsed number of builds before the test was fixed to check if it was the longest", (Throwable)e);
            }
        }
        return period;
    }

    @Override
    public long getAverageElapsedTime() {
        long elapsedTime = 0L;
        int i = 0;
        for (FailurePeriod failurePeriod : this.getFailurePeriods()) {
            elapsedTime += failurePeriod.getElapsedTime();
            ++i;
        }
        return elapsedTime / (long)i;
    }

    @Override
    public float getAverageElapsedBuilds() {
        long elapsedBuilds = 0L;
        int i = 0;
        for (FailurePeriod failurePeriod : this.getFailurePeriods()) {
            try {
                int elapsedThisPeriod = failurePeriod.getElapsedBuilds();
                elapsedBuilds += (long)elapsedThisPeriod;
                ++i;
            }
            catch (Exception e) {
                log.error((Object)"Bamboo failed to find the elapsed number of builds before the test was fixed to average", (Throwable)e);
            }
        }
        if (i > 0) {
            float l = (float)elapsedBuilds / (float)i;
            return NumberUtils.round((float)l, (int)2);
        }
        return 0.0f;
    }
}

