/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.status;

import com.atlassian.bamboo.event.ChainCompletedEvent;
import com.atlassian.bamboo.event.PlanResultEvent;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.plan.cache.ImmutablePlan;
import com.atlassian.bamboo.resultsummary.ImmutableResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryManager;
import com.atlassian.bamboo.resultsummary.vcs.RepositoryChangeset;
import com.atlassian.event.api.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildStatusUpdater {
    private static final Logger log = Logger.getLogger(AbstractBuildStatusUpdater.class);
    private final CachedPlanManager cachedPlanManager;
    private final ResultsSummaryManager resultsSummaryManager;

    public AbstractBuildStatusUpdater(CachedPlanManager cachedPlanManager, ResultsSummaryManager resultsSummaryManager) {
        this.cachedPlanManager = cachedPlanManager;
        this.resultsSummaryManager = resultsSummaryManager;
    }

    @EventListener
    public void onChainCompletedEvent(@NotNull ChainCompletedEvent event) {
        this.handleEvent(event);
    }

    protected void handleEvent(PlanResultEvent event) {
        if (!this.isBuildStatusHandlingEnabled()) {
            log.debug((Object)"Updating Bitbucket with build status is disabled - no updates sent");
            return;
        }
        ResultsSummary resultsSummary = this.resultsSummaryManager.getResultsSummary(event.getPlanResultKey(), ResultDataRead.FULL);
        if (resultsSummary == null) {
            log.error((Object)String.format("Couldn't find results summary with build key: %s", event.getPlanResultKey()));
            return;
        }
        ImmutablePlan plan = this.cachedPlanManager.getPlanByKey(event.getPlanKey(), ImmutableChain.class);
        if (plan == null) {
            log.error((Object)String.format("Couldn't find plan with key: %s", event.getPlanKey()));
            return;
        }
        this.send(event, plan, (ImmutableResultsSummary)resultsSummary);
    }

    @NotNull
    protected static List<String> getRelevantChangesetIds(@NotNull ImmutableResultsSummary resultsSummary, @NotNull Predicate<RepositoryChangeset> isRelevantPredicate) {
        return resultsSummary.getRepositoryChangesets().stream().filter(isRelevantPredicate).map(RepositoryChangeset::getChangesetId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected abstract boolean isBuildStatusHandlingEnabled();

    protected abstract void send(@NotNull PlanResultEvent var1, @NotNull ImmutablePlan var2, @NotNull ImmutableResultsSummary var3);
}

