/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.strategy;

import com.atlassian.bamboo.build.strategy.AbstractBuildStrategy;
import com.atlassian.bamboo.deployments.environments.DeploymentTriggerBranchSelectionMode;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.struts.TextProvider;
import java.util.Arrays;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class AfterSuccessfulPlanTrigger
extends AbstractBuildStrategy {
    private static final Logger log = Logger.getLogger(AfterSuccessfulPlanTrigger.class);
    public static final String KEY = "afterSuccessfulPlan";
    private static final String LEGACY_TRIGGERING_PLAN_KEY = "triggeringPlan";
    public static final String CFG_BRANCH_SELECTION_MODE = "deployment.trigger.afterSuccessfulPlan.branchSelectionMode";
    public static final String CFG_TRIGGERING_PLAN_KEY = "deployment.trigger.afterSuccessfulPlan.triggeringPlan";
    public static final String CFG_TRIGGERING_BRANCH_KEY = "deployment.trigger.afterSuccessfulPlan.triggeringBranch";
    private static final String NAME = "After successful build plan";
    private DeploymentTriggerBranchSelectionMode branchSelectionMode;
    private PlanKey triggeringPlanKey;
    private PlanKey triggeringBranchKey;
    private CachedPlanManager cachedPlanManager;
    private TextProvider textProvider;

    public String getKey() {
        return KEY;
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return NAME;
    }

    @Override
    public void init(@NotNull Triggerable triggerable) {
        super.init(triggerable);
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        String branchSelectionModeString = config.getString(CFG_BRANCH_SELECTION_MODE, null);
        this.branchSelectionMode = StringUtils.isNotEmpty((CharSequence)branchSelectionModeString) ? DeploymentTriggerBranchSelectionMode.valueOf((String)branchSelectionModeString) : DeploymentTriggerBranchSelectionMode.INHERITED;
        String triggeringBranchKeyString = config.getString(CFG_TRIGGERING_BRANCH_KEY, null);
        if (StringUtils.isNotEmpty((CharSequence)triggeringBranchKeyString)) {
            this.triggeringBranchKey = PlanKeys.getPlanKey((String)triggeringBranchKeyString);
            String triggeringPlanKeyString = config.getString(CFG_TRIGGERING_PLAN_KEY, null);
            if (StringUtils.isNotEmpty((CharSequence)triggeringPlanKeyString)) {
                this.triggeringPlanKey = PlanKeys.getPlanKey((String)triggeringPlanKeyString);
            } else {
                log.warn((Object)String.format("Incomplete trigger configuration, unknown sourcePlan for sourceBranch '%s'", triggeringBranchKeyString));
            }
        } else {
            String triggeringPlanKeyString = config.getString(CFG_TRIGGERING_PLAN_KEY);
            if (StringUtils.isNotEmpty((CharSequence)triggeringPlanKeyString)) {
                this.triggeringPlanKey = PlanKeys.getPlanKey((String)triggeringPlanKeyString);
            } else {
                String triggeringPlanKeyLegacyString = config.getString(LEGACY_TRIGGERING_PLAN_KEY);
                if (StringUtils.isNotEmpty((CharSequence)triggeringPlanKeyLegacyString)) {
                    this.triggeringPlanKey = PlanKeys.getPlanKey((String)triggeringPlanKeyLegacyString);
                }
            }
        }
        if (this.triggeringBranchKey == null && this.triggeringPlanKey != null) {
            this.triggeringBranchKey = this.triggeringPlanKey;
        }
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.addProperty(CFG_BRANCH_SELECTION_MODE, (Object)this.branchSelectionMode.name());
        if (this.triggeringPlanKey != null) {
            configuration.addProperty(CFG_TRIGGERING_PLAN_KEY, (Object)this.triggeringPlanKey.getKey());
        }
        if (this.triggeringBranchKey != null) {
            configuration.addProperty(CFG_TRIGGERING_BRANCH_KEY, (Object)this.triggeringBranchKey.getKey());
        }
        return configuration;
    }

    @Override
    public void addDefaultValues(BuildConfiguration buildConfiguration) {
        super.addDefaultValues(buildConfiguration);
        buildConfiguration.setProperty(CFG_BRANCH_SELECTION_MODE, (Object)DeploymentTriggerBranchSelectionMode.INHERITED);
    }

    @Override
    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        DeploymentTriggerBranchSelectionMode tmpBranchSelectionMode = null;
        try {
            tmpBranchSelectionMode = DeploymentTriggerBranchSelectionMode.valueOf((String)buildConfiguration.getString(CFG_BRANCH_SELECTION_MODE));
        }
        catch (Exception e) {
            errorCollection.addError(CFG_BRANCH_SELECTION_MODE, this.textProvider.getText("deployment.trigger.afterSuccessfulPlan.branchSelectionMode.error.empty"));
        }
        if (tmpBranchSelectionMode != null) {
            switch (tmpBranchSelectionMode) {
                case CUSTOM: {
                    String triggeringBranchStringKey = buildConfiguration.getString(CFG_TRIGGERING_BRANCH_KEY);
                    if (StringUtils.isBlank((CharSequence)triggeringBranchStringKey)) {
                        errorCollection.addError(CFG_TRIGGERING_BRANCH_KEY, this.textProvider.getText("deployment.trigger.afterSuccessfulPlan.triggeringBranch.error.emptyKey"));
                        break;
                    }
                    try {
                        PlanKey branchKey = PlanKeys.getPlanKey((String)triggeringBranchStringKey);
                        ImmutableChain branch = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(branchKey, ImmutableChain.class);
                        if (branch != null) break;
                        errorCollection.addError(CFG_TRIGGERING_BRANCH_KEY, this.textProvider.getText("deployment.trigger.afterSuccessfulPlan.triggeringBranch.error.notExistent", Arrays.asList(triggeringBranchStringKey)));
                    }
                    catch (IllegalArgumentException e) {
                        errorCollection.addError(CFG_TRIGGERING_BRANCH_KEY, this.textProvider.getText("deployment.trigger.afterSuccessfulPlan.triggeringBranch.error.notPlanKey", Arrays.asList(triggeringBranchStringKey)));
                    }
                    break;
                }
            }
        }
        return errorCollection;
    }

    @Override
    public boolean canTrigger(@NotNull Class<? extends Triggerable> type) {
        return Environment.class.isAssignableFrom(type);
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    @NotNull
    public DeploymentTriggerBranchSelectionMode getBranchSelectionMode() {
        return this.branchSelectionMode;
    }

    public void setBranchSelectionMode(DeploymentTriggerBranchSelectionMode branchSelectionMode) {
        this.branchSelectionMode = branchSelectionMode;
    }

    public PlanKey getTriggeringPlanKey() {
        return this.triggeringPlanKey;
    }

    public void setTriggeringPlanKey(PlanKey triggeringPlanKey) {
        this.triggeringPlanKey = triggeringPlanKey;
    }

    public PlanKey getTriggeringBranchKey() {
        return this.triggeringBranchKey;
    }

    public void setTriggeringBranchKey(PlanKey triggeringBranchKey) {
        this.triggeringBranchKey = triggeringBranchKey;
    }
}

