/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.strategy;

import com.atlassian.bamboo.build.strategy.AbstractQuartzStrategy;
import com.atlassian.bamboo.deployments.DeploymentException;
import com.atlassian.bamboo.deployments.environments.DeploymentTriggerBranchSelectionMode;
import com.atlassian.bamboo.deployments.environments.Environment;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.environments.service.EnvironmentTriggerService;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanKeys;
import com.atlassian.bamboo.plan.cache.CachedPlanManager;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.template.TemplateRenderer;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.core.cron.generator.CronExpressionDescriptor;
import com.atlassian.core.cron.parser.CronExpressionParser;
import com.atlassian.core.i18n.I18nTextProvider;
import com.atlassian.struts.TextProvider;
import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@Deprecated
public class CronTriggerBuildStrategy
extends AbstractQuartzStrategy {
    private static final Logger log = Logger.getLogger(CronTriggerBuildStrategy.class);
    public static final String KEY = "schedule";
    private static final String CFG_CRON_EXPRESSION = "repository.change.schedule.cronExpression";
    public static final String CFG_DEPLOYMENTS_MODE = "deployment.trigger.schedule.deploymentsMode";
    public static final String CFG_BRANCH_SELECTION_MODE = "deployment.trigger.schedule.branchSelectionMode";
    public static final String CFG_SOURCE_PLAN = "deployment.trigger.schedule.sourcePlan";
    public static final String CFG_SOURCE_BRANCH = "deployment.trigger.schedule.sourceBranch";
    private String cronExpression = "0 0 0 ? * *";
    private DeploymentTriggerBranchSelectionMode branchSelectionMode;
    private PlanKey sourcePlan;
    private PlanKey sourceBranch;
    private CachedPlanManager cachedPlanManager;
    private TextProvider textProvider;
    private TemplateRenderer templateRenderer;
    private EnvironmentTriggerService environmentTriggerService;

    public String getKey() {
        return KEY;
    }

    public String getName() {
        return "Scheduled builds";
    }

    @Override
    public String getDescription() {
        return StringUtils.defaultString((String)this.textProvider.getText("repository.change.schedule.description"));
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        configuration.addProperty(CFG_CRON_EXPRESSION, (Object)this.getCronExpression());
        if (this.branchSelectionMode != null) {
            configuration.addProperty(CFG_BRANCH_SELECTION_MODE, (Object)this.branchSelectionMode.name());
        }
        if (this.sourcePlan != null) {
            configuration.addProperty(CFG_SOURCE_PLAN, (Object)this.sourcePlan.getKey());
        }
        if (this.sourceBranch != null) {
            configuration.addProperty(CFG_SOURCE_BRANCH, (Object)this.sourceBranch.getKey());
        }
        return configuration;
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        String sourceBranchString;
        super.populateFromConfig(config);
        this.cronExpression = config.getString(CFG_CRON_EXPRESSION, null);
        String branchSelectionModeString = config.getString(CFG_BRANCH_SELECTION_MODE, null);
        if (branchSelectionModeString != null) {
            this.branchSelectionMode = DeploymentTriggerBranchSelectionMode.valueOf((String)branchSelectionModeString);
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceBranchString = config.getString(CFG_SOURCE_BRANCH, null)))) {
            this.sourceBranch = PlanKeys.getPlanKey((String)sourceBranchString);
            String sourcePlanString = config.getString(CFG_SOURCE_PLAN, null);
            if (StringUtils.isNotBlank((CharSequence)sourcePlanString)) {
                this.sourcePlan = PlanKeys.getPlanKey((String)sourcePlanString);
            } else {
                log.warn((Object)String.format("Incomplete trigger configuration, unknown sourcePlan for sourceBranch '%s'", sourceBranchString));
            }
        }
    }

    @Override
    public void addDefaultValues(BuildConfiguration buildConfiguration) {
        super.addDefaultValues(buildConfiguration);
        buildConfiguration.setProperty(CFG_CRON_EXPRESSION, (Object)this.getCronExpression());
        buildConfiguration.setProperty(CFG_BRANCH_SELECTION_MODE, (Object)DeploymentTriggerBranchSelectionMode.INHERITED);
    }

    @Override
    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String cronExpressionStr = buildConfiguration.getString(CFG_CRON_EXPRESSION);
        if (StringUtils.isEmpty((CharSequence)cronExpressionStr)) {
            errorCollection.addError(CFG_CRON_EXPRESSION, this.textProvider.getText("repository.change.schedule.cronExpression.error.required"));
        } else {
            try {
                CronExpression cronExpr = new CronExpression(cronExpressionStr);
                cronExpr.getNextValidTimeAfter(new Date());
            }
            catch (ParseException e) {
                errorCollection.addError(CFG_CRON_EXPRESSION, this.textProvider.getText("repository.change.schedule.cronExpression.error.invalid"));
            }
            catch (UnsupportedOperationException e) {
                errorCollection.addError(CFG_CRON_EXPRESSION, this.textProvider.getText("repository.change.schedule.cronExpression.error.unsupported"));
            }
            catch (Exception e) {
                errorCollection.addError(CFG_CRON_EXPRESSION, this.textProvider.getText("repository.change.schedule.cronExpression.error.failure"));
                log.error((Object)"Validation of Cron Expression Failed", (Throwable)e);
            }
        }
        boolean deploymentsMode = buildConfiguration.getBoolean(CFG_DEPLOYMENTS_MODE);
        if (deploymentsMode) {
            DeploymentTriggerBranchSelectionMode tmpBranchSelectionMode = null;
            try {
                tmpBranchSelectionMode = DeploymentTriggerBranchSelectionMode.valueOf((String)buildConfiguration.getString(CFG_BRANCH_SELECTION_MODE));
            }
            catch (Exception e) {
                errorCollection.addError(CFG_BRANCH_SELECTION_MODE, this.textProvider.getText("deployment.trigger.schedule.branchSelectionMode.error.empty"));
            }
            if (tmpBranchSelectionMode == DeploymentTriggerBranchSelectionMode.CUSTOM) {
                String sourceBranchStringKey = buildConfiguration.getString(CFG_SOURCE_BRANCH);
                if (StringUtils.isEmpty((CharSequence)sourceBranchStringKey)) {
                    errorCollection.addError(CFG_SOURCE_BRANCH, this.textProvider.getText("deployment.trigger.schedule.sourceBranch.error.emptyKey"));
                } else {
                    try {
                        PlanKey branchKey = PlanKeys.getPlanKey((String)sourceBranchStringKey);
                        ImmutableChain branch = (ImmutableChain)this.cachedPlanManager.getPlanByKeyIfOfType(branchKey, ImmutableChain.class);
                        if (branch == null) {
                            errorCollection.addError(CFG_SOURCE_BRANCH, this.textProvider.getText("deployment.trigger.schedule.sourceBranch.error.notExistent", Arrays.asList(sourceBranchStringKey)));
                        }
                    }
                    catch (IllegalArgumentException e) {
                        errorCollection.addError(CFG_SOURCE_BRANCH, this.textProvider.getText("deployment.trigger.schedule.sourceBranch.error.notPlanKey", Arrays.asList(sourceBranchStringKey)));
                    }
                }
            }
        }
        return errorCollection;
    }

    @Override
    @NotNull
    protected Class<? extends Job> getStrategyJob() {
        throw new UnsupportedOperationException("why are you calling me?");
    }

    @Override
    @Nullable
    protected Trigger getTrigger(@NotNull Triggerable plan) {
        try {
            CronExpression cronExpression = new CronExpression(this.getCronExpression());
            return TriggerBuilder.newTrigger().withIdentity("schedule:" + this.getUniqueId(plan)).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)cronExpression)).startNow().build();
        }
        catch (ParseException e) {
            log.warn((Object)("Unable to parse CronExpression: " + this.getCronExpression()), (Throwable)e);
            return null;
        }
    }

    @Override
    protected JobDetail createJobDetail(@NotNull Triggerable triggerable, @NotNull String jobName) {
        JobDetail jobDetail = super.createJobDetail(triggerable, jobName);
        if (this.branchSelectionMode != null) {
            jobDetail.getJobDataMap().put(CFG_BRANCH_SELECTION_MODE, this.branchSelectionMode.name());
        }
        if (this.sourceBranch != null) {
            jobDetail.getJobDataMap().put(CFG_SOURCE_BRANCH, this.sourceBranch.getKey());
        }
        return jobDetail;
    }

    @Override
    @NotNull
    public String getTriggerDetailsSummaryHtml(@NotNull Triggerable triggerable, @NotNull I18nTextProvider i18nTextProvider) {
        String prettyCronExpression = "";
        boolean isPretty = false;
        try {
            CronExpressionParser parser = new CronExpressionParser(this.cronExpression);
            CronExpressionDescriptor descriptor = new CronExpressionDescriptor(i18nTextProvider);
            prettyCronExpression = descriptor.getPrettySchedule(parser.getCronEditorBean());
            isPretty = !parser.getCronEditorBean().getCronString().equals(prettyCronExpression);
        }
        catch (Exception e) {
            log.warn((Object)("Exception parsing croexpression: " + this.cronExpression), (Throwable)e);
        }
        return this.templateRenderer.render("fragments/triggers/view/viewCronTriggerBuildStrategy.ftl", (Map)ImmutableMap.of((Object)"trigger", (Object)this, (Object)"cronExpression", (Object)prettyCronExpression, (Object)"isPretty", (Object)isPretty));
    }

    @NotNull
    public DeploymentTriggerBranchSelectionMode getBranchSelectionMode() {
        return this.branchSelectionMode;
    }

    @Nullable
    public PlanKey getSourcePlanKey(@NotNull Triggerable triggerable) {
        Environment environment = (Environment)Narrow.downTo((Object)triggerable, Environment.class);
        if (environment != null) {
            try {
                return this.environmentTriggerService.getCalculatedTriggeringPlanKey((InternalEnvironment)environment, this.branchSelectionMode, this.sourceBranch);
            }
            catch (DeploymentException e) {
                log.warn((Object)"", (Throwable)e);
            }
        }
        return null;
    }

    public void setCachedPlanManager(CachedPlanManager cachedPlanManager) {
        this.cachedPlanManager = cachedPlanManager;
    }

    public void setEnvironmentTriggerService(EnvironmentTriggerService environmentTriggerService) {
        this.environmentTriggerService = environmentTriggerService;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public void setTemplateRenderer(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setBranchSelectionMode(DeploymentTriggerBranchSelectionMode branchSelectionMode) {
        this.branchSelectionMode = branchSelectionMode;
    }

    public PlanKey getSourceBranch() {
        return this.sourceBranch;
    }

    public void setSourceBranch(PlanKey sourceBranch) {
        this.sourceBranch = sourceBranch;
    }

    public PlanKey getSourcePlan() {
        return this.sourcePlan;
    }

    public void setSourcePlan(PlanKey sourcePlan) {
        this.sourcePlan = sourcePlan;
    }
}

