/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.strategy;

import com.atlassian.bamboo.FeatureManager;
import com.atlassian.bamboo.build.BuildTriggerCondition;
import com.atlassian.bamboo.build.strategy.AfterSuccessfulPlanTrigger;
import com.atlassian.bamboo.build.strategy.BuildStrategy;
import com.atlassian.bamboo.build.strategy.BuildStrategyManager;
import com.atlassian.bamboo.build.strategy.CronTriggerBuildStrategy;
import com.atlassian.bamboo.build.strategy.ManualBuildStrategy;
import com.atlassian.bamboo.build.strategy.PollingBuildStrategy;
import com.atlassian.bamboo.build.strategy.SingleDailyBuildStrategy;
import com.atlassian.bamboo.build.strategy.StashBuildStrategy;
import com.atlassian.bamboo.build.strategy.TriggeredBuildStrategy;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.spring.ComponentAccessor;
import com.atlassian.bamboo.trigger.BuildTriggerConditionModuleDescriptor;
import com.atlassian.bamboo.trigger.TriggerActivator;
import com.atlassian.bamboo.trigger.TriggerModuleDescriptor;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.Comparators;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.atlassian.util.concurrent.Lazy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class DefaultBuildStrategyManager
implements BuildStrategyManager {
    private static final Logger log = Logger.getLogger(DefaultBuildStrategyManager.class);
    private final Supplier<ImmutableMap<String, Class<? extends BuildStrategy>>> key2ClassSupplier = Lazy.supplier((Supplier)new Supplier<ImmutableMap<String, Class<? extends BuildStrategy>>>(){

        @Override
        public ImmutableMap<String, Class<? extends BuildStrategy>> get() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)"poll", PollingBuildStrategy.class);
            builder.put((Object)"daily", SingleDailyBuildStrategy.class);
            builder.put((Object)"trigger", TriggeredBuildStrategy.class);
            builder.put((Object)"schedule", CronTriggerBuildStrategy.class);
            builder.put((Object)"afterSuccessfulPlan", AfterSuccessfulPlanTrigger.class);
            builder.put((Object)"stash", StashBuildStrategy.class);
            return builder.build();
        }
    });
    private final PluginAccessor pluginAccessor;
    private final com.google.common.base.Supplier<FeatureManager> featureManager = ComponentAccessor.FEATURE_MANAGER;

    public DefaultBuildStrategyManager(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    @NotNull
    private BuildStrategy getNewTriggerInstance(@Nullable String key) {
        try {
            ImmutableMap<String, Class<? extends BuildStrategy>> key2Class = this.key2ClassSupplier.get();
            ManualBuildStrategy buildStrategy = key2Class.containsKey((Object)key) ? (BuildStrategy)((Class)key2Class.get((Object)key)).newInstance() : new ManualBuildStrategy();
            return this.autowireBuildStrategy(buildStrategy);
        }
        catch (Exception e) {
            log.warn((Object)"", (Throwable)e);
            return new ManualBuildStrategy();
        }
    }

    protected <T extends BuildStrategy> T autowireBuildStrategy(T buildStrategy) {
        ContainerManager.autowireComponent(buildStrategy);
        return buildStrategy;
    }

    @NotNull
    private List<BuildStrategy> getTriggerTypes(@NotNull Class<? extends Triggerable> type) {
        return ImmutableList.copyOf(this.getTriggerTypesInternal(type, true));
    }

    @NotNull
    public BuildStrategy getNewBuildStrategyInstance(String key) {
        return this.getNewTriggerInstance(key);
    }

    @NotNull
    private List<BuildStrategy> getTriggerTypesForCreate(@NotNull Class<? extends Triggerable> type, boolean sourceControlUsed) {
        ArrayList buildStrategies = Lists.newArrayList(this.getTriggerTypesInternal(type, sourceControlUsed));
        buildStrategies.add(new ManualBuildStrategy());
        return ImmutableList.copyOf((Collection)buildStrategies);
    }

    @NotNull
    public List<BuildStrategy> getBuildStrategies() {
        return this.getBuildStrategies(true);
    }

    private Iterable<BuildStrategy> getTriggerTypesInternal(@NotNull Class<? extends Triggerable> triggerableType, boolean sourceControlUsed) {
        if (sourceControlUsed) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)this.autowireBuildStrategy(new PollingBuildStrategy()));
            builder.add((Object)this.autowireBuildStrategy(new TriggeredBuildStrategy()));
            builder.add((Object)this.autowireBuildStrategy(new CronTriggerBuildStrategy()));
            builder.add((Object)this.autowireBuildStrategy(new SingleDailyBuildStrategy()));
            builder.add((Object)this.autowireBuildStrategy(new AfterSuccessfulPlanTrigger()));
            builder.add((Object)this.autowireBuildStrategy(new StashBuildStrategy()));
            return Iterables.filter((Iterable)builder.build(), (Predicate)new CanTriggerPredicate(triggerableType));
        }
        return Iterables.filter(Arrays.asList(this.autowireBuildStrategy(new CronTriggerBuildStrategy()), this.autowireBuildStrategy(new SingleDailyBuildStrategy()), this.autowireBuildStrategy(new AfterSuccessfulPlanTrigger())), (Predicate)new CanTriggerPredicate(triggerableType));
    }

    @NotNull
    public List<BuildStrategy> getBuildStrategiesForPlanCreate(boolean sourceControlUsed) {
        Iterable elements = Narrow.iterableDownTo(this.getTriggerTypesForCreate(ImmutableChain.class, sourceControlUsed), BuildStrategy.class);
        return ImmutableList.copyOf((Iterable)elements);
    }

    @NotNull
    public List<BuildStrategy> getBuildStrategies(boolean sourceControlUsed) {
        Iterable elements = Narrow.iterableDownTo(this.getTriggerTypesInternal(ImmutableChain.class, sourceControlUsed), BuildStrategy.class);
        return ImmutableList.copyOf((Iterable)elements);
    }

    @NotNull
    public List<BuildTriggerCondition> getBuildTriggerConditions() {
        List<BuildTriggerCondition> plugins = this.pluginAccessor.getEnabledModulesByClass(BuildTriggerCondition.class);
        return plugins != null ? plugins : Collections.emptyList();
    }

    @NotNull
    public List<BuildTriggerConditionModuleDescriptor> getAvailableBuildTriggerConditionModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(BuildTriggerConditionModuleDescriptor.class);
    }

    @NotNull
    public Iterable<TriggerModuleDescriptor> getAvailableTriggerDescriptors(@NotNull Triggerable triggerable) {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(TriggerModuleDescriptor.class).stream().filter(tmd -> tmd.canTrigger(triggerable)).sorted((Comparator<TriggerModuleDescriptor>)Comparators.getModuleDescriptorNameOrdering()).collect(Collectors.toList());
    }

    public Iterable<TriggerModuleDescriptor> getAvailableTriggerDescriptorsByType(Class<? extends Triggerable> triggerableClass) {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(TriggerModuleDescriptor.class).stream().filter(tmd -> tmd.canTriggerType(triggerableClass)).sorted((Comparator<TriggerModuleDescriptor>)Comparators.getModuleDescriptorNameOrdering()).collect(Collectors.toList());
    }

    @Nullable
    public TriggerModuleDescriptor getTriggerDescriptor(@Nullable String pluginKey) {
        if (StringUtils.isNotEmpty((CharSequence)pluginKey)) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(pluginKey);
            return (TriggerModuleDescriptor)Narrow.reinterpret((Object)moduleDescriptor, TriggerModuleDescriptor.class);
        }
        return null;
    }

    @Nullable
    public BuildTriggerConditionModuleDescriptor getBuildTriggerConditionDescriptor(String pluginKey) {
        if (StringUtils.isNotEmpty((CharSequence)pluginKey)) {
            ModuleDescriptor moduleDescriptor = this.pluginAccessor.getEnabledPluginModule(pluginKey);
            return (BuildTriggerConditionModuleDescriptor)Narrow.reinterpret((Object)moduleDescriptor, BuildTriggerConditionModuleDescriptor.class);
        }
        return null;
    }

    @Nullable
    public TriggerActivator getTriggerActivator(@NotNull String pluginKey) {
        TriggerModuleDescriptor triggerModuleDescriptor = this.getTriggerDescriptor(pluginKey);
        if (triggerModuleDescriptor != null) {
            return (TriggerActivator)triggerModuleDescriptor.getModule();
        }
        return null;
    }

    private class CanTriggerPredicate
    implements Predicate<BuildStrategy> {
        private final Class<? extends Triggerable> type;

        private CanTriggerPredicate(Class<? extends Triggerable> type) {
            this.type = type;
        }

        public boolean apply(@Nullable BuildStrategy input) {
            return ((BuildStrategy)Preconditions.checkNotNull((Object)input)).canTrigger(this.type);
        }
    }
}

