/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.strategy;

import com.atlassian.bamboo.build.strategy.AbstractQuartzStrategy;
import com.atlassian.bamboo.build.strategy.RepositoryAwareBuildStrategy;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.text.ParseException;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronExpression;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

@Deprecated
public class PollingBuildStrategy
extends AbstractQuartzStrategy
implements RepositoryAwareBuildStrategy {
    private static final Logger log = Logger.getLogger(PollingBuildStrategy.class);
    private static final String POLLING_CRON_EXPRESSION = "repository.change.poll.cronExpression";
    private static final String POLLING_PERIOD = "repository.change.poll.pollingPeriod";
    private static final String POLLING_SCHEDULE_STRATEGY = "repository.change.poll.type";
    public static final int DEFAULT_POLLING_PERIOD = 180;
    private int pollingPeriod = 180;
    private PollingStrategy pollingStrategy = PollingStrategy.PERIOD;
    private String pollingCronExpression = "0 0 0 ? * *";
    private Set<Long> triggeringRepositories = new HashSet<Long>();

    public String getKey() {
        return "poll";
    }

    public String getName() {
        return "Repository Polling";
    }

    @Override
    public String getDescription() {
        return StringUtils.defaultString((String)this.getTextProvider().getText("repository.change.poll.description"));
    }

    @Override
    public void addDefaultValues(BuildConfiguration buildConfiguration) {
        super.addDefaultValues(buildConfiguration);
        buildConfiguration.setProperty(POLLING_SCHEDULE_STRATEGY, (Object)PollingStrategy.PERIOD);
        buildConfiguration.setProperty(POLLING_PERIOD, (Object)180);
        buildConfiguration.setProperty(POLLING_CRON_EXPRESSION, (Object)this.pollingCronExpression);
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = super.toConfiguration();
        config.setProperty(POLLING_SCHEDULE_STRATEGY, (Object)this.pollingStrategy.name());
        config.setProperty(POLLING_CRON_EXPRESSION, (Object)this.pollingCronExpression);
        config.setProperty(POLLING_PERIOD, (Object)String.valueOf(this.getPollingPeriod()));
        return config;
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        this.populateFromConfigInternal(config);
    }

    protected void populateFromConfigInternal(@NotNull HierarchicalConfiguration config) {
        this.setPollingStrategy(config.getString(POLLING_SCHEDULE_STRATEGY, PollingStrategy.PERIOD.name()));
        if (PollingStrategy.CRON == this.pollingStrategy) {
            this.setPollingCronExpression(config.getString(POLLING_CRON_EXPRESSION));
        } else {
            this.setPollingPeriod(config.getInt(POLLING_PERIOD, 180));
        }
    }

    @Override
    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        PollingStrategy strategy = PollingStrategy.valueOf(buildConfiguration.getString(POLLING_SCHEDULE_STRATEGY, ""));
        if (PollingStrategy.PERIOD == strategy) {
            String pollingPeriodString = buildConfiguration.getString(POLLING_PERIOD);
            if (StringUtils.isBlank((CharSequence)pollingPeriodString)) {
                errorCollection.addError(POLLING_PERIOD, "Please specify the polling frequency (in seconds)");
            } else {
                try {
                    int pollingPeriod = Integer.parseInt(pollingPeriodString);
                    if (pollingPeriod <= 0) {
                        errorCollection.addError(POLLING_PERIOD, "Please enter a positive repository polling frequency");
                    }
                }
                catch (NumberFormatException e) {
                    errorCollection.addError(POLLING_PERIOD, "Please enter a numeric polling frequency (in seconds)");
                }
            }
        } else if (PollingStrategy.CRON == strategy) {
            String cronExpressionStr = buildConfiguration.getString(POLLING_CRON_EXPRESSION);
            if (StringUtils.isEmpty((CharSequence)cronExpressionStr)) {
                errorCollection.addError(POLLING_CRON_EXPRESSION, this.getTextProvider().getText("repository.change.schedule.cronExpression.error.required"));
            } else {
                try {
                    CronExpression cronExpr = new CronExpression(cronExpressionStr);
                    cronExpr.getNextValidTimeAfter(new Date());
                }
                catch (ParseException e) {
                    errorCollection.addError(POLLING_CRON_EXPRESSION, this.getTextProvider().getText("repository.change.schedule.cronExpression.error.invalid"));
                }
                catch (UnsupportedOperationException e) {
                    errorCollection.addError(POLLING_CRON_EXPRESSION, this.getTextProvider().getText("repository.change.schedule.cronExpression.error.unsupported"));
                }
                catch (Exception e) {
                    errorCollection.addError(POLLING_CRON_EXPRESSION, this.getTextProvider().getText("repository.change.schedule.cronExpression.error.failure"));
                    log.error((Object)"Validation of Cron Expression Failed", (Throwable)e);
                }
            }
        } else {
            errorCollection.addError(POLLING_SCHEDULE_STRATEGY, "Could not determine whether polling based on a time period, or polling based on a cron schedule should be used");
        }
        return errorCollection;
    }

    @Override
    @NotNull
    protected Class<? extends Job> getStrategyJob() {
        throw new UnsupportedOperationException("why are you calling me?");
    }

    @Override
    @Nullable
    protected Trigger getTrigger(@NotNull Triggerable triggerable) {
        TriggerBuilder trigger;
        TriggerKey triggerKey = new TriggerKey("poll:" + this.getUniqueId(triggerable), "DEFAULT");
        if (PollingStrategy.CRON == this.pollingStrategy) {
            try {
                CronExpression pollingCronExpression = new CronExpression(this.pollingCronExpression);
                trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((CronExpression)pollingCronExpression));
            }
            catch (ParseException e) {
                log.warn((Object)("Change Polling for plan " + triggerable.getId() + " did not start. Unable to parse Cron Expression " + this.pollingCronExpression), (Throwable)e);
                return null;
            }
        } else {
            trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey.getName()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)this.getPollingPeriod()));
        }
        trigger.startNow();
        return trigger.build();
    }

    public int getPollingPeriod() {
        return this.pollingPeriod;
    }

    public void setPollingPeriod(int pollingPeriod) {
        this.pollingPeriod = pollingPeriod;
    }

    public String getPollingStrategy() {
        return this.pollingStrategy.name();
    }

    public void setPollingStrategy(String pollingStrategy) {
        this.pollingStrategy = PollingStrategy.valueOf(pollingStrategy);
    }

    public String getPollingCronExpression() {
        return this.pollingCronExpression;
    }

    public void setPollingCronExpression(String pollingCronExpression) {
        this.pollingCronExpression = pollingCronExpression;
    }

    public Set<Long> getTriggeringRepositories() {
        return this.triggeringRepositories;
    }

    public void setTriggeringRepositories(Set<Long> triggeringRepositories) {
        this.triggeringRepositories = triggeringRepositories;
    }

    @Override
    public boolean canTrigger(@NotNull Class<? extends Triggerable> type) {
        return ImmutableChain.class.isAssignableFrom(type);
    }

    public static enum PollingStrategy {
        PERIOD,
        CRON;

    }
}

