/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.strategy;

import com.atlassian.bamboo.build.strategy.AbstractQuartzStrategy;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.CronScheduleBuilder;
import org.quartz.Job;
import org.quartz.ScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

@Deprecated
public class SingleDailyBuildStrategy
extends AbstractQuartzStrategy {
    private static final Logger log = Logger.getLogger(SingleDailyBuildStrategy.class);
    private static final String BUILD_DAILY_BUILD_TIME = "repository.change.daily.buildTime";
    private int hour;
    private int minute;

    public String getKey() {
        return "daily";
    }

    public String getName() {
        return "Single Daily Build";
    }

    @Override
    public String getDescription() {
        String description = this.getTextProvider().getText("repository.change.daily.description");
        return description != null ? description : "";
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration configuration = super.toConfiguration();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, this.getHour());
        calendar.set(12, this.getMinute());
        configuration.addProperty(BUILD_DAILY_BUILD_TIME, (Object)this.getDateFormat().format(calendar.getTime()));
        return configuration;
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        super.populateFromConfig(config);
        String hhmm = (String)config.getProperty(BUILD_DAILY_BUILD_TIME);
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.getDateFormat().parse(hhmm));
            this.setHour(calendar.get(11));
            this.setMinute(calendar.get(12));
        }
        catch (ParseException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        String dailyBuildTime = buildConfiguration.getString(BUILD_DAILY_BUILD_TIME);
        if (StringUtils.isEmpty((CharSequence)dailyBuildTime)) {
            errorCollection.addError(BUILD_DAILY_BUILD_TIME, this.getTextProvider().getText("repository.change.daily.buildTime.error.required"));
        } else {
            try {
                this.getDateFormat().parse(dailyBuildTime);
            }
            catch (ParseException ex) {
                errorCollection.addError(BUILD_DAILY_BUILD_TIME, this.getTextProvider().getText("repository.change.daily.buildTime.error.invalid"));
            }
        }
        return errorCollection;
    }

    @Override
    @NotNull
    protected Class<? extends Job> getStrategyJob() {
        throw new UnsupportedOperationException("why are you calling me?");
    }

    @Override
    @Nullable
    protected Trigger getTrigger(@NotNull Triggerable plan) {
        return TriggerBuilder.newTrigger().withIdentity("daily:" + this.getUniqueId(plan)).withSchedule((ScheduleBuilder)CronScheduleBuilder.dailyAtHourAndMinute((int)this.getHour(), (int)this.getMinute())).startNow().build();
    }

    @Override
    public boolean canTrigger(@NotNull Class<? extends Triggerable> type) {
        return ImmutableChain.class.isAssignableFrom(type) && super.canTrigger(type);
    }

    public int getHour() {
        return this.hour;
    }

    public void setHour(int hour) {
        this.hour = hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public void setMinute(int minute) {
        this.minute = minute;
    }

    public String getFormattedTime() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, this.getHour());
        calendar.set(12, this.getMinute());
        return this.getDateFormat().format(calendar.getTime());
    }

    private SimpleDateFormat getDateFormat() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
        dateFormat.setLenient(true);
        return dateFormat;
    }
}

