/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.strategy;

import com.atlassian.bamboo.build.strategy.AbstractBuildStrategy;
import com.atlassian.bamboo.build.strategy.RepositoryAwareBuildStrategy;
import com.atlassian.bamboo.plan.cache.ImmutableChain;
import com.atlassian.bamboo.trigger.Triggerable;
import com.atlassian.bamboo.util.Narrow;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.atlassian.bamboo.ww2.actions.build.admin.create.BuildConfiguration;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.opensymphony.xwork2.TextProvider;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class TriggeredBuildStrategy
extends AbstractBuildStrategy
implements RepositoryAwareBuildStrategy {
    public static final String TRIGGER_IP_ADDRESS = "repository.change.trigger.triggerIpAddress";
    public static final String NAME = "Repository Triggered Build";
    private transient EventPublisher eventPublisher;
    private String triggerIpAddress;
    private Set<Long> triggeringRepositories = new HashSet<Long>();

    @Override
    public void init(@NotNull Triggerable triggerable) {
        ImmutableChain chain = (ImmutableChain)Narrow.downTo((Object)triggerable, ImmutableChain.class);
        if (chain != null) {
            // empty if block
        }
    }

    public String getKey() {
        return "trigger";
    }

    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        TextProvider textProvider = (TextProvider)ContainerManager.getComponent((String)"textProvider");
        String description = textProvider.getText("repository.change.trigger.description");
        return description != null ? description : "";
    }

    @Override
    public ErrorCollection validate(BuildConfiguration buildConfiguration) {
        ErrorCollection errorCollection = super.validate(buildConfiguration);
        for (String triggerIpAddress : StringUtils.split((String)buildConfiguration.getString(TRIGGER_IP_ADDRESS), (String)" ,")) {
            InetAddressValidator validator = InetAddressValidator.getInstance();
            if (!StringUtils.isNotEmpty((CharSequence)triggerIpAddress) || validator.isValid(triggerIpAddress)) continue;
            errorCollection.addError(TRIGGER_IP_ADDRESS, "Please enter a valid IP address");
            break;
        }
        return errorCollection;
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = super.toConfiguration();
        config.setProperty(TRIGGER_IP_ADDRESS, (Object)this.getTriggerIpAddress());
        return config;
    }

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.setTriggerIpAddresses(config.getString(TRIGGER_IP_ADDRESS));
        super.populateFromConfig(config);
    }

    public String getTriggerIpAddress() {
        return this.triggerIpAddress;
    }

    public void setTriggerIpAddresses(String triggerIpAddresses) {
        this.triggerIpAddress = triggerIpAddresses;
    }

    @NotNull
    public String[] getAllowedTriggerIpAddresses() {
        String[] triggerIpAddresses = StringUtils.split((String)this.triggerIpAddress, (String)" ,");
        return triggerIpAddresses != null ? triggerIpAddresses : new String[]{};
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Set<Long> getTriggeringRepositories() {
        return this.triggeringRepositories;
    }

    public void setTriggeringRepositories(Set<Long> triggeringRepositories) {
        this.triggeringRepositories = triggeringRepositories;
    }
}

