/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.test;

import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.test.TestCollationService;
import com.atlassian.bamboo.build.test.TestCollectionResult;
import com.atlassian.bamboo.build.test.TestReportCollector;
import com.atlassian.bamboo.build.test.TestReportProvider;
import com.atlassian.bamboo.build.test.junit.JunitTestReportCollector;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.utils.FileVisitor;
import com.atlassian.bamboo.utils.SystemProperty;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCollationServiceImpl
implements TestCollationService {
    private static final Logger log = Logger.getLogger(TestCollationServiceImpl.class);
    private static final int COLLATE_TESTS_THREAD_POOL_SIZE = 20;

    public void collateTestResults(@NotNull TaskContext taskContext, @NotNull TestReportProvider testReportProvider) {
        CurrentBuildResult buildResult = taskContext.getBuildContext().getBuildResult();
        HashSet failedTestResults = new HashSet();
        HashSet successfulTestResults = new HashSet();
        HashSet skippedTestResults = new HashSet();
        TestCollectionResult testCollectionResult = testReportProvider.getTestCollectionResult();
        failedTestResults.addAll(testCollectionResult.getFailedTestResults());
        successfulTestResults.addAll(testCollectionResult.getSuccessfulTestResults());
        skippedTestResults.addAll(testCollectionResult.getSkippedTestResults());
        buildResult.appendTestResults(successfulTestResults, failedTestResults, skippedTestResults);
    }

    public void collateTestResults(@NotNull TaskContext taskContext, @NotNull String filePattern) {
        this.collateTestResults(taskContext, filePattern, new JunitTestReportCollector(), false);
    }

    public void collateTestResults(@NotNull TaskContext taskContext, @NotNull String filePattern, boolean pickupOutdatedFiles) {
        this.collateTestResults(taskContext, filePattern, new JunitTestReportCollector(), pickupOutdatedFiles);
    }

    public void collateTestResults(@NotNull TaskContext taskContext, @NotNull String filePattern, @NotNull TestReportCollector testReportCollector) {
        this.collateTestResults(taskContext, filePattern, testReportCollector, false);
    }

    public void collateTestResults(@NotNull TaskContext taskContext, @NotNull String filePattern, @NotNull TestReportCollector testReportCollector, boolean pickupOutdatedFiles) {
        this.collateTestResults(taskContext, null, filePattern, testReportCollector, pickupOutdatedFiles);
    }

    public void collateTestResults(@NotNull TaskContext taskContext, @Nullable String resultDirectory, @NotNull String filePattern, final @NotNull TestReportCollector testReportCollector, final boolean pickupOutdatedFiles) {
        final BuildLogger buildLogger = taskContext.getBuildLogger();
        CurrentBuildResult buildResult = taskContext.getBuildContext().getBuildResult();
        final CopyOnWriteArrayList<String> parsingErrors = new CopyOnWriteArrayList<String>();
        final Set failedTestResults = Collections.synchronizedSet(new HashSet());
        final Set successfulTestResults = Collections.synchronizedSet(new HashSet());
        final Set skippedTestResults = Collections.synchronizedSet(new HashSet());
        final Date taskStartDate = buildResult.getTasksStartDate();
        final AtomicInteger numberOfFilesFound = new AtomicInteger(0);
        try {
            File sourceDirectory = this.getSourceDirectory(taskContext, resultDirectory);
            if (sourceDirectory.exists()) {
                buildLogger.addBuildLogEntry("Parsing test results under " + sourceDirectory + "...");
                log.debug((Object)String.format("Parsing test results in %s, file pattern %s", sourceDirectory.getAbsolutePath(), filePattern));
                final ExecutorService executorService = Executors.newFixedThreadPool(20);
                FileVisitor fileVisitor = new FileVisitor(sourceDirectory){

                    @Override
                    public void visitFile(File file) {
                        boolean isFileRecentEnough;
                        boolean isFileExtensionSupported = this.fileExtensionIsSupported(file, testReportCollector);
                        boolean bl = isFileRecentEnough = pickupOutdatedFiles || this.isFileRecentEnough(file);
                        if (isFileExtensionSupported && isFileRecentEnough) {
                            log.debug((Object)String.format("Submitting file %s to test report collector", file));
                            executorService.submit(this.newTestResultFileParser(file));
                        } else {
                            if (log.isDebugEnabled() && !isFileExtensionSupported) {
                                log.debug((Object)String.format("File %s has extension not supported by test report collector %s", file, testReportCollector.getClass()));
                            }
                            if (!isFileRecentEnough) {
                                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                                String msg = String.format("File %s was ignored because it was modified (%s) before task started (%s)", file, dateFormat.format(new Date(file.lastModified())), dateFormat.format(taskStartDate));
                                log.info((Object)buildLogger.addBuildLogEntry(msg));
                            }
                        }
                    }

                    private boolean isFileRecentEnough(File file) {
                        return file.lastModified() >= taskStartDate.getTime() - SystemProperty.FS_TIMESTAMP_RESOLUTION_MS.getTypedValue();
                    }

                    private Runnable newTestResultFileParser(File file) {
                        return () -> {
                            try {
                                numberOfFilesFound.incrementAndGet();
                                TestCollectionResult result = testReportCollector.collect(file);
                                log.debug((Object)String.format("File %s parsing result: %d successful, %d failed, %d skipped", file, result.getSuccessfulTestResults().size(), result.getFailedTestResults().size(), result.getSkippedTestResults().size()));
                                failedTestResults.addAll(result.getFailedTestResults());
                                successfulTestResults.addAll(result.getSuccessfulTestResults());
                                skippedTestResults.addAll(result.getSkippedTestResults());
                            }
                            catch (Throwable e) {
                                if (testReportCollector.canIgnoreResultsFrom(file)) {
                                    log.info((Object)("Unable to parse file '" + file + " but it appears not to be a file with test results: " + e.getMessage()), e);
                                }
                                String error = buildLogger.addErrorLogEntry("Failed to parse test result file \"" + file + "\"");
                                parsingErrors.add(error);
                                log.error((Object)error, e);
                            }
                        };
                    }

                    private boolean fileExtensionIsSupported(File file, TestReportCollector testReportCollector2) {
                        Set supportedExtensions = testReportCollector2.getSupportedFileExtensions();
                        return supportedExtensions.isEmpty() || FilenameUtils.isExtension((String)file.getName(), (Collection)supportedExtensions);
                    }
                };
                fileVisitor.visitFilesThatMatch(filePattern);
                executorService.shutdown();
                executorService.awaitTermination(60L, TimeUnit.MINUTES);
            }
            if (buildResult.getBuildErrors().isEmpty() && numberOfFilesFound.get() == 0) {
                buildResult.getBuildErrors().add("Could not find test result reports in the " + sourceDirectory + " directory.");
            }
        }
        catch (InterruptedException e) {
            String error = buildLogger.addErrorLogEntry("Failed to parse test result files. Build was interrupted.");
            parsingErrors.add(error);
            log.error((Object)error);
        }
        if (!parsingErrors.isEmpty()) {
            buildResult.incParserErrorsCount(parsingErrors.size());
            buildResult.addBuildErrors(parsingErrors);
        }
        buildResult.appendTestResults(successfulTestResults, failedTestResults, skippedTestResults);
    }

    private File getSourceDirectory(TaskContext taskContext, String resultDirectory) {
        if (StringUtils.isBlank((CharSequence)resultDirectory)) {
            return taskContext.getRootDirectory();
        }
        File rdFile = new File(resultDirectory);
        if (rdFile.isAbsolute()) {
            return rdFile;
        }
        return new File(taskContext.getRootDirectory(), resultDirectory);
    }
}

